/*
 * Decompiled with CFR 0.152.
 */
package net.sterbendes.greeneries.neoforge.data;

import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import org.jetbrains.annotations.NotNull;

public record LootTableSubProv(HolderLookup.Provider provider) implements LootTableSubProvider
{
    public static final Stream<ResourceKey<Block>> dropSeedsOrSelf = Stream.of("very_short_common_bent", "short_common_bent", "bushy_common_bent", "very_short_red_fescue", "short_red_fescue", "bushy_red_fescue", "medium_red_fescue", "very_short_blue_grass", "short_blue_grass", "bushy_blue_grass").map(s -> ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greeneries", (String)s)));

    public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        dropSeedsOrSelf.forEach(blockKey -> consumer.accept(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)blockKey.location().withPrefix("blocks/")), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.lootTableItem((ItemLike)this.lookupBlock((ResourceKey<Block>)blockKey)).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.SHEARS}))), ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WHEAT_SEEDS).when(LootItemRandomChanceCondition.randomChance((float)0.125f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount(this.getFortuneEnchantHolder(), (int)2)).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay())})))));
    }

    private Block lookupBlock(ResourceKey<Block> blockKey) {
        return (Block)((Holder.Reference)this.provider.lookupOrThrow(Registries.BLOCK).get(blockKey).orElseThrow()).value();
    }

    private Holder<Enchantment> getFortuneEnchantHolder() {
        return (Holder)this.provider.lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.FORTUNE).orElseThrow();
    }
}

