/*
 * Decompiled with CFR 0.152.
 */
package net.sterbendes.greeneries.blocks;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.sterbendes.greeneries.GreeneriesMod;
import net.sterbendes.greeneries.blocks.ModBlockColors;
import net.sterbendes.greeneries.blocks.ReedBlock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class ModBlocks {
    private static final Map<String, Holder<Block>> allGreeneriesBlocks = new LinkedHashMap<String, Holder<Block>>();

    private static TallGrassBlock createTallGrassBlock(BlockBehaviour.Properties properties) {
        return new TallGrassBlock(properties){};
    }

    public static void registerGrass(String name, String ... variants) {
        ModBlocks.registerGrass(name, ModBlockColors.VARYING_GRASS_BLOCK_COLOR, variants);
    }

    public static void registerGrass(String name, @Nullable BlockColor blockTint, String ... variants) {
        for (String variant : variants) {
            ModBlocks.register(variant + "_" + name, blockTint, ModBlocks::createTallGrassBlock, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS));
        }
    }

    private static void register(String name, @Nullable BlockColor blockTint, Function<BlockBehaviour.Properties, Block> blockSupplier, BlockBehaviour.Properties properties) {
        ResourceKey id = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greeneries", (String)name));
        properties.setId(id);
        Holder<Block> holder = GreeneriesMod.register(name, BuiltInRegistries.BLOCK, () -> (Block)blockSupplier.apply(properties));
        GreeneriesMod.register(name, BuiltInRegistries.ITEM, () -> new BlockItem((Block)holder.value(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greeneries", (String)name)))));
        GreeneriesMod.platform.setRenderLayer(() -> holder.value(), ChunkSectionLayer.CUTOUT);
        if (blockTint != null) {
            GreeneriesMod.platform.setBlockColor(() -> holder.value(), blockTint);
        }
        allGreeneriesBlocks.put(name, holder);
    }

    public static Collection<Holder<Block>> getAllGreeneriesBlocks() {
        return allGreeneriesBlocks.values();
    }

    public static Holder<Block> get(String name) {
        return allGreeneriesBlocks.get(name);
    }

    @ApiStatus.Internal
    public static void init() {
    }

    static {
        ModBlocks.registerGrass("grass", "very_short", "bushy", "medium");
        ModBlocks.registerGrass("red_fescue", "very_short", "short", "bushy", "medium");
        ModBlocks.registerGrass("common_bent", ModBlockColors.VARYING_GRASS_BLOCK_COLOR, "very_short", "short", "bushy");
        ModBlocks.registerGrass("blue_grass", "very_short", "short", "bushy");
        ModBlocks.register("medium_eagle_fern", ModBlockColors.VARYING_FERN_BLOCK_COLOR, ModBlocks::createTallGrassBlock, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FERN));
        ModBlocks.register("tall_eagle_fern", ModBlockColors.VARYING_FERN_BLOCK_COLOR, DoublePlantBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LARGE_FERN));
        ModBlocks.register("short_royal_fern", ModBlockColors.VARYING_FERN_BLOCK_COLOR, ModBlocks::createTallGrassBlock, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FERN));
        ModBlocks.register("medium_royal_fern", ModBlockColors.VARYING_FERN_BLOCK_COLOR, ModBlocks::createTallGrassBlock, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FERN));
        ModBlocks.register("tall_royal_fern", ModBlockColors.VARYING_FERN_BLOCK_COLOR, DoublePlantBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LARGE_FERN));
        ModBlocks.register("cattail", ModBlockColors.FOLIAGE_COLOR, ReedBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_SEAGRASS));
        ModBlocks.register("reed", ModBlockColors.FOLIAGE_COLOR, ReedBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_SEAGRASS));
    }
}

