/*
 * Decompiled with CFR 0.152.
 */
package net.sterbendes.greeneries.blocks;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_11515;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2526;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.sterbendes.greeneries.GreeneriesMod;
import net.sterbendes.greeneries.blocks.ModBlockColors;
import net.sterbendes.greeneries.blocks.ReedBlock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class ModBlocks {
    private static final Map<String, class_6880<class_2248>> allGreeneriesBlocks = new LinkedHashMap<String, class_6880<class_2248>>();

    private static class_2526 createTallGrassBlock(class_4970.class_2251 properties) {
        return new class_2526(properties){};
    }

    public static void registerGrass(String name, String ... variants) {
        ModBlocks.registerGrass(name, ModBlockColors.VARYING_GRASS_BLOCK_COLOR, variants);
    }

    public static void registerGrass(String name, @Nullable class_322 blockTint, String ... variants) {
        for (String variant : variants) {
            ModBlocks.register(variant + "_" + name, blockTint, ModBlocks::createTallGrassBlock, class_4970.class_2251.method_9630((class_4970)class_2246.field_10479));
        }
    }

    private static void register(String name, @Nullable class_322 blockTint, Function<class_4970.class_2251, class_2248> blockSupplier, class_4970.class_2251 properties) {
        class_5321 id = class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"greeneries", (String)name));
        properties.method_63500(id);
        class_6880<class_2248> holder = GreeneriesMod.register(name, class_7923.field_41175, () -> (class_2248)blockSupplier.apply(properties));
        GreeneriesMod.register(name, class_7923.field_41178, () -> new class_1747((class_2248)holder.comp_349(), new class_1792.class_1793().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"greeneries", (String)name)))));
        GreeneriesMod.platform.setRenderLayer(() -> holder.comp_349(), class_11515.field_60925);
        if (blockTint != null) {
            GreeneriesMod.platform.setBlockColor(() -> holder.comp_349(), blockTint);
        }
        allGreeneriesBlocks.put(name, holder);
    }

    public static Collection<class_6880<class_2248>> getAllGreeneriesBlocks() {
        return allGreeneriesBlocks.values();
    }

    public static class_6880<class_2248> get(String name) {
        return allGreeneriesBlocks.get(name);
    }

    @ApiStatus.Internal
    public static void init() {
    }

    static {
        ModBlocks.registerGrass("grass", "very_short", "bushy", "medium");
        ModBlocks.registerGrass("red_fescue", "very_short", "short", "bushy", "medium");
        ModBlocks.registerGrass("common_bent", ModBlockColors.VARYING_GRASS_BLOCK_COLOR, "very_short", "short", "bushy");
        ModBlocks.registerGrass("blue_grass", "very_short", "short", "bushy");
        ModBlocks.register("medium_eagle_fern", ModBlockColors.VARYING_FERN_BLOCK_COLOR, ModBlocks::createTallGrassBlock, class_4970.class_2251.method_9630((class_4970)class_2246.field_10112));
        ModBlocks.register("tall_eagle_fern", ModBlockColors.VARYING_FERN_BLOCK_COLOR, class_2320::new, class_4970.class_2251.method_9630((class_4970)class_2246.field_10313));
        ModBlocks.register("short_royal_fern", ModBlockColors.VARYING_FERN_BLOCK_COLOR, ModBlocks::createTallGrassBlock, class_4970.class_2251.method_9630((class_4970)class_2246.field_10112));
        ModBlocks.register("medium_royal_fern", ModBlockColors.VARYING_FERN_BLOCK_COLOR, ModBlocks::createTallGrassBlock, class_4970.class_2251.method_9630((class_4970)class_2246.field_10112));
        ModBlocks.register("tall_royal_fern", ModBlockColors.VARYING_FERN_BLOCK_COLOR, class_2320::new, class_4970.class_2251.method_9630((class_4970)class_2246.field_10313));
        ModBlocks.register("cattail", ModBlockColors.FOLIAGE_COLOR, ReedBlock::new, class_4970.class_2251.method_9630((class_4970)class_2246.field_10238));
        ModBlocks.register("reed", ModBlockColors.FOLIAGE_COLOR, ReedBlock::new, class_4970.class_2251.method_9630((class_4970)class_2246.field_10238));
    }
}

