/*
 * Decompiled with CFR 0.152.
 */
package net.sterbendes.greeneries.blocks;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1163;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1926;
import net.minecraft.class_1933;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2526;
import net.minecraft.class_322;
import net.minecraft.class_326;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.sterbendes.greeneries.GreeneriesMod;
import net.sterbendes.greeneries.blocks.ReedBlock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class ModBlocks {
    private static final Map<String, class_6880<class_2248>> allGreeneriesBlocks = new LinkedHashMap<String, class_6880<class_2248>>();
    public static final class_322 VARYING_GRASS_BLOCK_COLOR = (blockState, blockAndTintGetter, blockPos, i) -> {
        int color;
        int n = color = blockAndTintGetter != null && blockPos != null ? class_1163.method_4962((class_1920)blockAndTintGetter, (class_2338)blockPos) : class_1933.method_49724();
        if (blockPos == null) {
            return color;
        }
        class_5819 randomSource = class_5819.method_43049((long)class_2338.method_10064((int)blockPos.method_10263(), (int)0, (int)blockPos.method_10260()));
        int rand1 = randomSource.method_43054() / 22 >> 8 & 0xFF0000;
        int rand2 = randomSource.method_43054() / 18 >> 16 & 0xFF00;
        int rand3 = randomSource.method_43054() / 24 >> 24 & 0xFF;
        return color + rand1 + rand2 + rand3;
    };
    public static final class_322 VARYING_FERN_BLOCK_COLOR = (blockState, blockAndTintGetter, blockPos, i) -> {
        int color;
        int n = color = blockAndTintGetter != null && blockPos != null ? class_1163.method_4962((class_1920)blockAndTintGetter, (class_2338)blockPos) : class_1933.method_49724();
        if (blockPos == null) {
            return color;
        }
        class_5819 randomSource = class_5819.method_43049((long)class_2338.method_10064((int)blockPos.method_10263(), (int)0, (int)blockPos.method_10260()));
        int rand1 = randomSource.method_43054() / 22 >> 8 & 0xFF0000;
        int rand2 = randomSource.method_43054() / 18 >> 16 & 0xFF00;
        int rand3 = randomSource.method_43054() / 24 >> 24 & 0xFF;
        return color + rand1 + rand2 + rand3;
    };
    public static final class_322 FOLIAGE_COLOR = (blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter != null && blockPos != null ? class_1163.method_4966((class_1920)blockAndTintGetter, (class_2338)blockPos) : class_1926.method_8341();
    public static final class_326 GRASS_ITEM_COLOR = (stack, i) -> class_1933.method_49724();

    public static void registerVariants(String name, String ... variants) {
        ModBlocks.registerVariants(name, VARYING_GRASS_BLOCK_COLOR, GRASS_ITEM_COLOR, variants);
    }

    public static void registerVariants(String name, @Nullable class_322 blockTint, @Nullable class_326 itemTint, String ... variants) {
        for (String variant : variants) {
            ModBlocks.register(variant + "_" + name, blockTint, itemTint, () -> new class_2526(class_4970.class_2251.method_9630((class_4970)class_2246.field_10479)){});
        }
    }

    private static void register(String name, @Nullable class_322 blockTint, @Nullable class_326 itemTint, Supplier<class_2248> blockSupplier) {
        class_6880<class_2248> holder = GreeneriesMod.register(name, class_7923.field_41175, blockSupplier);
        GreeneriesMod.register(name, class_7923.field_41178, () -> new class_1747((class_2248)holder.comp_349(), new class_1792.class_1793()));
        GreeneriesMod.platform.setRenderLayer(() -> holder.comp_349(), class_1921.method_23581());
        if (blockTint != null) {
            GreeneriesMod.platform.setBlockColor(() -> holder.comp_349(), blockTint);
        }
        if (itemTint != null) {
            GreeneriesMod.platform.setItemColor(() -> holder.comp_349(), itemTint);
        }
        allGreeneriesBlocks.put(name, holder);
    }

    public static Collection<class_6880<class_2248>> getAllGreeneriesBlocks() {
        return allGreeneriesBlocks.values();
    }

    public static class_6880<class_2248> get(String name) {
        return allGreeneriesBlocks.get(name);
    }

    @ApiStatus.Internal
    public static void init() {
    }

    static {
        ModBlocks.registerVariants("grass", "very_short", "bushy", "medium");
        ModBlocks.registerVariants("red_fescue", "very_short", "short", "bushy", "medium");
        ModBlocks.registerVariants("common_bent", VARYING_GRASS_BLOCK_COLOR, null, "very_short", "short", "bushy");
        ModBlocks.registerVariants("blue_grass", "very_short", "short", "bushy");
        ModBlocks.register("medium_eagle_fern", VARYING_FERN_BLOCK_COLOR, GRASS_ITEM_COLOR, () -> new class_2526(class_4970.class_2251.method_9630((class_4970)class_2246.field_10112)){});
        ModBlocks.register("tall_eagle_fern", VARYING_FERN_BLOCK_COLOR, GRASS_ITEM_COLOR, () -> new class_2320(class_4970.class_2251.method_9630((class_4970)class_2246.field_10313)));
        ModBlocks.register("short_royal_fern", VARYING_FERN_BLOCK_COLOR, null, () -> new class_2526(class_4970.class_2251.method_9630((class_4970)class_2246.field_10112)){});
        ModBlocks.register("medium_royal_fern", VARYING_FERN_BLOCK_COLOR, null, () -> new class_2526(class_4970.class_2251.method_9630((class_4970)class_2246.field_10112)){});
        ModBlocks.register("tall_royal_fern", VARYING_FERN_BLOCK_COLOR, null, () -> new class_2320(class_4970.class_2251.method_9630((class_4970)class_2246.field_10313)){});
        ModBlocks.register("cattail", FOLIAGE_COLOR, null, () -> new ReedBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10238)));
        ModBlocks.register("reed", FOLIAGE_COLOR, null, () -> new ReedBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10238)));
    }
}

