/*
 * Decompiled with CFR 0.152.
 */
package net.sterbendes.greeneries.blocks;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2526;
import net.minecraft.class_4970;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.sterbendes.greeneries.GreeneriesMod;
import net.sterbendes.greeneries.blocks.ModBlockColors;
import net.sterbendes.greeneries.blocks.ReedBlock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class ModBlocks {
    private static final Map<String, class_6880<class_2248>> allGreeneriesBlocks = new LinkedHashMap<String, class_6880<class_2248>>();

    public static void registerVariants(String name, String ... variants) {
        ModBlocks.registerVariants(name, ModBlockColors.VARYING_GRASS_BLOCK_COLOR, ModBlockColors.GRASS_ITEM_COLOR, variants);
    }

    public static void registerVariants(String name, @Nullable ModBlockColors.GBlockColor blockTint, @Nullable ModBlockColors.GItemColor itemTint, String ... variants) {
        for (String variant : variants) {
            ModBlocks.register(variant + "_" + name, blockTint, itemTint, () -> new class_2526(class_4970.class_2251.method_9630((class_4970)class_2246.field_10479)){});
        }
    }

    private static void register(String name, @Nullable ModBlockColors.GBlockColor blockTint, @Nullable ModBlockColors.GItemColor itemTint, Supplier<class_2248> blockSupplier) {
        class_6880<class_2248> holder = GreeneriesMod.register(name, class_7923.field_41175, blockSupplier);
        GreeneriesMod.register(name, class_7923.field_41178, () -> new class_1747((class_2248)holder.comp_349(), new class_1792.class_1793()));
        if (GreeneriesMod.platform.isClient()) {
            GreeneriesMod.platform.setRenderLayer(() -> holder.comp_349(), class_1921.method_23581());
        }
        if (blockTint != null && GreeneriesMod.platform.isClient()) {
            GreeneriesMod.platform.setBlockColor(() -> holder.comp_349(), blockTint);
        }
        if (itemTint != null && GreeneriesMod.platform.isClient()) {
            GreeneriesMod.platform.setItemColor(() -> holder.comp_349(), itemTint::getColor);
        }
        allGreeneriesBlocks.put(name, holder);
    }

    public static Collection<class_6880<class_2248>> getAllGreeneriesBlocks() {
        return allGreeneriesBlocks.values();
    }

    public static class_6880<class_2248> get(String name) {
        return allGreeneriesBlocks.get(name);
    }

    @ApiStatus.Internal
    public static void init() {
    }

    static {
        ModBlocks.registerVariants("grass", "very_short", "bushy", "medium");
        ModBlocks.registerVariants("red_fescue", "very_short", "short", "bushy", "medium");
        ModBlocks.registerVariants("common_bent", ModBlockColors.VARYING_GRASS_BLOCK_COLOR, null, "very_short", "short", "bushy");
        ModBlocks.registerVariants("blue_grass", "very_short", "short", "bushy");
        ModBlocks.register("medium_eagle_fern", ModBlockColors.VARYING_FERN_BLOCK_COLOR, ModBlockColors.GRASS_ITEM_COLOR, () -> new class_2526(class_4970.class_2251.method_9630((class_4970)class_2246.field_10112)){});
        ModBlocks.register("tall_eagle_fern", ModBlockColors.VARYING_FERN_BLOCK_COLOR, ModBlockColors.GRASS_ITEM_COLOR, () -> new class_2320(class_4970.class_2251.method_9630((class_4970)class_2246.field_10313)));
        ModBlocks.register("short_royal_fern", ModBlockColors.VARYING_FERN_BLOCK_COLOR, null, () -> new class_2526(class_4970.class_2251.method_9630((class_4970)class_2246.field_10112)){});
        ModBlocks.register("medium_royal_fern", ModBlockColors.VARYING_FERN_BLOCK_COLOR, null, () -> new class_2526(class_4970.class_2251.method_9630((class_4970)class_2246.field_10112)){});
        ModBlocks.register("tall_royal_fern", ModBlockColors.VARYING_FERN_BLOCK_COLOR, null, () -> new class_2320(class_4970.class_2251.method_9630((class_4970)class_2246.field_10313)){});
        ModBlocks.register("cattail", ModBlockColors.FOLIAGE_COLOR, null, () -> new ReedBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10238)));
        ModBlocks.register("reed", ModBlockColors.FOLIAGE_COLOR, null, () -> new ReedBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10238)));
    }
}

