/*
 * Decompiled with CFR 0.152.
 */
package net.sterbendes.greeneries.fabric;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.minecraft.class_1761;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_326;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.sterbendes.greeneries.GreeneriesMod;
import net.sterbendes.greeneries.GreeneriesPlatform;
import net.sterbendes.greeneries.blocks.ModBlockColors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public class ModFabric
implements ModInitializer {
    public void onInitialize() {
        GreeneriesMod.init(new GreeneriesFabricPlatform());
    }

    private static Map<class_6862<class_1959>, class_6862<class_6796>> getAddedFeaturesMap() {
        Map<String, String> strings = Map.of("c:is_hot/overworld", "greeneries:patches_hot", "c:is_jungle", "greeneries:patches_jungles", "c:is_temperate/overworld", "greeneries:patches_temperate", "c:is_cold/overworld", "greeneries:patches_cold", "greeneries:has_reeds", "greeneries:patches_water", "c:is_wet/overworld", "greeneries:patches_wet");
        HashMap<class_6862<class_1959>, class_6862<class_6796>> map = new HashMap<class_6862<class_1959>, class_6862<class_6796>>();
        strings.forEach((str, str2) -> map.put(class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60654((String)str)), class_6862.method_40092((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60654((String)str2))));
        return map;
    }

    @ApiStatus.Internal
    public static void doBiomeModifications(MinecraftServer server) {
        ModFabric.getAddedFeaturesMap().forEach((biomeTag, featureTagKey) -> {
            class_2378 placedFeatureRegistry = server.method_30611().method_30530(class_7924.field_41245);
            for (class_6880 featureHolder : placedFeatureRegistry.method_40286(featureTagKey)) {
                BiomeModifications.addFeature(biomeSelectionContext -> biomeSelectionContext.hasTag(biomeTag), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)((class_5321)featureHolder.method_40230().orElseThrow()));
            }
        });
    }

    private static class GreeneriesFabricPlatform
    implements GreeneriesPlatform {
        private GreeneriesFabricPlatform() {
        }

        @Override
        public void onServerStart(Consumer<MinecraftServer> consumer) {
            ServerLifecycleEvents.SERVER_STARTING.register(consumer::accept);
        }

        @Override
        public void onClientStart(Consumer<class_310> consumer) {
            if (this.isClient()) {
                ClientLifecycleEvents.CLIENT_STARTED.register(consumer::accept);
            }
        }

        @Override
        @Contract(value=" -> new", pure=true)
        public class_1761.class_7913 creativeTabBuilder() {
            return FabricItemGroup.builder();
        }

        @Override
        public void setRenderLayer(Supplier<class_2248> block, class_1921 renderType) {
            this.onClientStart(mc -> BlockRenderLayerMap.INSTANCE.putBlock((class_2248)block.get(), renderType));
        }

        @Override
        public void setBlockColor(Supplier<class_2248> block, ModBlockColors.GBlockColor color) {
            this.onClientStart(mc -> ColorProviderRegistry.BLOCK.register(color::getColor, (Object[])new class_2248[]{(class_2248)block.get()}));
        }

        @Override
        public void setItemColor(Supplier<class_1935> item, class_326 itemColor) {
            this.onClientStart(mc -> ColorProviderRegistry.ITEM.register((Object)itemColor, (Object[])new class_1935[]{(class_1935)item.get()}));
        }
    }
}

