/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.would.blocks;

import com.ordana.would.entities.FallingCoconutEntity;
import com.ordana.would.reg.ModBlocks;
import com.ordana.would.reg.ModTreeGrowers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoconutBlock
extends SaplingBlock
implements Fallable {
    protected static final VoxelShape GREEN_SHAPE;
    protected static final VoxelShape BROWN_SHAPE;
    public static final BooleanProperty HANGING;
    public static final BooleanProperty ENABLED;

    public CoconutBlock(BlockBehaviour.Properties properties) {
        super(ModTreeGrowers.COCONUT, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HANGING, (Comparable)Boolean.valueOf(false))).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(BlockTags.DIRT) || state.is(BlockTags.SAND);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)HANGING) != false ? GREEN_SHAPE : BROWN_SHAPE;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)HANGING)).booleanValue()) {
            if (((Boolean)state.getValue((Property)ENABLED)).booleanValue() && level.getMaxLocalRawBrightness(pos.above()) >= 9 && random.nextInt(7) == 0) {
                this.advanceTree(level, pos, state, random);
            }
        } else if (random.nextInt(10) == 7) {
            state.setValue((Property)HANGING, (Comparable)Boolean.valueOf(false));
            level.scheduleTick(pos, (Block)this, this.getFallDelay());
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getLevel().getBlockState(context.getClickedPos().above()).is(ModBlocks.PALM_LEAVES.get())) {
            return (BlockState)this.defaultBlockState().setValue((Property)HANGING, (Comparable)Boolean.valueOf(true));
        }
        return this.defaultBlockState();
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return ((Boolean)state.getValue((Property)HANGING)).booleanValue() ? level.getBlockState(pos.above()).is(ModBlocks.PALM_LEAVES.get()) || this.mayPlaceOn(level.getBlockState(pos.below()), (BlockGetter)level, pos) : super.canSurvive(state, level, pos);
    }

    public void onLand(Level level, BlockPos pos, BlockState state, BlockState replaceableState, FallingBlockEntity fallingBlock) {
        level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)HANGING, (Comparable)Boolean.valueOf(false))).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!((Boolean)state.getValue((Property)HANGING)).booleanValue()) {
            level.scheduleTick(pos, (Block)this, this.getFallDelay());
        } else if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, false);
        }
        return state;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (CoconutBlock.canFallThrough(level.getBlockState(pos.below())) && pos.getY() >= level.getMinBuildHeight()) {
            FallingBlockEntity entity = FallingCoconutEntity.fall((Level)level, (BlockPos)pos, (BlockState)((BlockState)state.setValue((Property)HANGING, (Comparable)Boolean.valueOf(false))));
            this.configureFallingBlockEntity(entity);
        }
    }

    protected void configureFallingBlockEntity(FallingBlockEntity entity) {
    }

    protected int getFallDelay() {
        return 2;
    }

    public static boolean canFallThrough(BlockState state) {
        return state.isAir() || state.is(BlockTags.FIRE) || state.canBeReplaced();
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)HANGING) == false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STAGE, HANGING, ENABLED});
    }

    static {
        HANGING = BlockStateProperties.HANGING;
        ENABLED = BlockStateProperties.ENABLED;
        BROWN_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
        GREEN_SHAPE = Block.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    }
}

