/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.would.blocks;

import com.ordana.would.blocks.CoconutBlock;
import com.ordana.would.reg.ModBlocks;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PalmLeavesBlock
extends LeavesBlock
implements BonemealableBlock {
    public PalmLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void updateIndirectNeighbourShapes(BlockState state, LevelAccessor level, BlockPos pos, int flags, int recursionLeft) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Direction dir : Direction.Plane.HORIZONTAL.shuffledCopy(level.getRandom())) {
            mutableBlockPos.move(dir);
            mutableBlockPos.move(dir.getClockWise());
            if (level.getBlockState((BlockPos)mutableBlockPos).is((Block)this)) {
                level.neighborShapeChanged(dir.getClockWise().getOpposite(), level.getBlockState((BlockPos)mutableBlockPos), (BlockPos)mutableBlockPos, pos, flags, recursionLeft);
            }
            mutableBlockPos.set((Vec3i)pos.relative(dir));
            mutableBlockPos.move(dir.getClockWise());
            mutableBlockPos.move(Direction.DOWN);
            if (level.getBlockState((BlockPos)mutableBlockPos).is((Block)this)) {
                level.neighborShapeChanged(Direction.UP, level.getBlockState((BlockPos)mutableBlockPos), (BlockPos)mutableBlockPos, pos, flags, recursionLeft);
            }
            mutableBlockPos.set((Vec3i)pos.relative(dir));
            mutableBlockPos.move(dir.getClockWise());
            mutableBlockPos.move(Direction.UP);
            if (level.getBlockState((BlockPos)mutableBlockPos).is((Block)this)) {
                level.neighborShapeChanged(Direction.DOWN, level.getBlockState((BlockPos)mutableBlockPos), (BlockPos)mutableBlockPos, pos, flags, recursionLeft);
            }
            mutableBlockPos.set((Vec3i)pos.relative(dir));
            mutableBlockPos.move(Direction.DOWN);
            if (level.getBlockState((BlockPos)mutableBlockPos).is((Block)this)) {
                level.neighborShapeChanged(Direction.UP, level.getBlockState((BlockPos)mutableBlockPos), (BlockPos)mutableBlockPos, pos, flags, recursionLeft);
            }
            mutableBlockPos.set((Vec3i)pos.relative(dir));
            mutableBlockPos.move(Direction.UP);
            if (level.getBlockState((BlockPos)mutableBlockPos).is((Block)this)) {
                level.neighborShapeChanged(Direction.DOWN, level.getBlockState((BlockPos)mutableBlockPos), (BlockPos)mutableBlockPos, pos, flags, recursionLeft);
            }
            mutableBlockPos.set((Vec3i)pos);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.setBlock(pos, PalmLeavesBlock.updateDistance(state, (LevelAccessor)level, pos), 3);
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor level, BlockPos pos) {
        int i = 7;
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        states.add(level.getBlockState(pos.above()));
        states.add(level.getBlockState(pos.below()));
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            states.add(level.getBlockState(pos.relative(dir)));
            states.add(level.getBlockState(pos.relative(dir.getClockWise())));
            states.add(level.getBlockState(pos.relative(dir).above()));
            states.add(level.getBlockState(pos.relative(dir.getClockWise()).above()));
            states.add(level.getBlockState(pos.relative(dir).below()));
            states.add(level.getBlockState(pos.relative(dir.getClockWise()).below()));
        }
        for (BlockState blockState : states) {
            if (blockState.is(BlockTags.LOGS)) {
                return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(1));
            }
            if (!(blockState.getBlock() instanceof PalmLeavesBlock) || (i = Math.min((Integer)blockState.getValue((Property)DISTANCE), i)) != 1) continue;
            return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(2));
        }
        if (states.isEmpty()) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                mutableBlockPos.setWithOffset((Vec3i)pos, direction);
                i = Math.min(i, PalmLeavesBlock.getDistanceAt(level.getBlockState((BlockPos)mutableBlockPos)) + 1);
                if (i == 1) break;
            }
        }
        return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(Math.min(i + 1, 7)));
    }

    private static int getDistanceAt(BlockState neighbor) {
        return PalmLeavesBlock.getOptionalDistanceAt((BlockState)neighbor).orElse(7);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return level.getBlockState(pos.below()).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.setBlock(pos.below(), (BlockState)((BlockState)ModBlocks.COCONUT.get().defaultBlockState().setValue((Property)CoconutBlock.HANGING, (Comparable)Boolean.valueOf(true))).setValue((Property)CoconutBlock.ENABLED, (Comparable)Boolean.valueOf(true)), 2);
    }
}

