/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.would.entities;

import com.ordana.would.reg.ModBlocks;
import com.ordana.would.reg.ModEntities;
import com.ordana.would.reg.ModItems;
import java.util.function.IntFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ModBoatEntity
extends Boat {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.defineId(ModBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ModBoatEntity(EntityType<? extends Boat> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ModBoatEntity(Level level, double pX, double pY, double pZ) {
        this(ModEntities.MOD_BOAT.get(), level);
        this.setPos(pX, pY, pZ);
        this.xo = pX;
        this.yo = pY;
        this.zo = pZ;
    }

    public Item getDropItem() {
        return switch (this.getModVariant().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ModItems.ASPEN_BOAT.get();
            case 1 -> ModItems.AZALEA_BOAT.get();
            case 2 -> ModItems.BAOBAB_BOAT.get();
            case 3 -> ModItems.BLUE_SPRUCE_BOAT.get();
            case 4 -> ModItems.CEDAR_BOAT.get();
            case 5 -> ModItems.EBONY_BOAT.get();
            case 6 -> ModItems.FIR_BOAT.get();
            case 7 -> ModItems.MAHOGANY_BOAT.get();
            case 8 -> ModItems.MAPLE_BOAT.get();
            case 9 -> ModItems.PALM_BOAT.get();
            case 10 -> ModItems.PINE_BOAT.get();
            case 11 -> ModItems.WALNUT_BOAT.get();
            case 12 -> ModItems.WILLOW_BOAT.get();
        };
    }

    public void setVariant(Type pVariant) {
        this.entityData.set(DATA_ID_TYPE, (Object)pVariant.ordinal());
    }

    public Type getModVariant() {
        return Type.byId((Integer)this.entityData.get(DATA_ID_TYPE));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE, (Object)Type.PINE.ordinal());
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.putString("Type", this.getModVariant().getSerializedName());
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
        if (pCompound.contains("Type", 8)) {
            this.setVariant(Type.byName(pCompound.getString("Type")));
        }
    }

    public static enum Type implements StringRepresentable
    {
        ASPEN(ModBlocks.ASPEN_PLANKS.get(), "aspen"),
        AZALEA(ModBlocks.AZALEA_PLANKS.get(), "azalea"),
        BAOBAB(ModBlocks.BAOBAB_PLANKS.get(), "baobab"),
        BLUE_SPRUCE(ModBlocks.BLUE_SPRUCE_PLANKS.get(), "blue_spruce"),
        CEDAR(ModBlocks.CEDAR_PLANKS.get(), "cedar"),
        EBONY(ModBlocks.EBONY_PLANKS.get(), "ebony"),
        FIR(ModBlocks.FIR_PLANKS.get(), "fir"),
        MAHOGANY(ModBlocks.MAHOGANY_PLANKS.get(), "mahogany"),
        MAPLE(ModBlocks.MAPLE_PLANKS.get(), "maple"),
        PALM(ModBlocks.PALM_PLANKS.get(), "palm"),
        PINE(ModBlocks.PINE_PLANKS.get(), "pine"),
        WALNUT(ModBlocks.WALNUT_PLANKS.get(), "walnut"),
        WILLOW(ModBlocks.WILLOW_PLANKS.get(), "willow");

        private final String name;
        private final Block planks;
        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;

        private Type(Block pPlanks, String pName) {
            this.name = pName;
            this.planks = pPlanks;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int pId) {
            return BY_ID.apply(pId);
        }

        public static Type byName(String pName) {
            return (Type)CODEC.byName(pName, (Enum)PINE);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

