/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.would.entities;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import com.ordana.would.Would;
import com.ordana.would.entities.ModBoatEntity;
import com.ordana.would.entities.ModChestBoatEntity;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class ModBoatRenderer
extends BoatRenderer {
    private final Map<ModBoatEntity.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(ModBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)Would.res(ModBoatRenderer.getTextureLocation(type, pChestBoat)), this.createBoatModel(pContext, (ModBoatEntity.Type)((Object)type), pChestBoat))));

    public ModBoatRenderer(EntityRendererProvider.Context pContext, boolean pChestBoat) {
        super(pContext, pChestBoat);
    }

    private static String getTextureLocation(ModBoatEntity.Type pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + pType.getName() + ".png" : "textures/entity/boat/" + pType.getName() + ".png";
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context pContext, ModBoatEntity.Type pType, boolean pChestBoat) {
        ModelLayerLocation modellayerlocation = pChestBoat ? ModBoatRenderer.createChestBoatModelName(pType) : ModBoatRenderer.createBoatModelName(pType);
        ModelPart modelpart = pContext.bakeLayer(modellayerlocation);
        return pChestBoat ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    public static ModelLayerLocation createBoatModelName(ModBoatEntity.Type pType) {
        return ModBoatRenderer.createLocation("boat/" + pType.getName(), "main");
    }

    public static ModelLayerLocation createChestBoatModelName(ModBoatEntity.Type pType) {
        return ModBoatRenderer.createLocation("chest_boat/" + pType.getName(), "main");
    }

    private static ModelLayerLocation createLocation(String pPath, String pModel) {
        return new ModelLayerLocation(Would.res(pPath), pModel);
    }

    @NotNull
    public ResourceLocation getTextureLocation(Boat boat) {
        if (boat instanceof ModBoatEntity) {
            ModBoatEntity modBoat = (ModBoatEntity)boat;
            return (ResourceLocation)this.boatResources.get((Object)modBoat.getModVariant()).getFirst();
        }
        if (boat instanceof ModChestBoatEntity) {
            ModChestBoatEntity modChestBoatEntity = (ModChestBoatEntity)boat;
            return (ResourceLocation)this.boatResources.get((Object)modChestBoatEntity.getModVariant()).getFirst();
        }
        return null;
    }

    public void render(Boat entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Object boatEntity;
        float h;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.375f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - entityYaw));
        float f = (float)entity.getHurtTime() - partialTicks;
        float g = entity.getDamage() - partialTicks;
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * g / 10.0f * (float)entity.getHurtDir()));
        }
        if (!Mth.equal((float)(h = entity.getBubbleAngle(partialTicks)), (float)0.0f)) {
            poseStack.mulPose(new Quaternionf().setAngleAxis(entity.getBubbleAngle(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ListModel<Boat>> pair = null;
        ResourceLocation resourceLocation = null;
        ListModel listModel = null;
        if (entity instanceof ModBoatEntity) {
            boatEntity = (ModBoatEntity)entity;
            pair = this.boatResources.get((Object)((ModBoatEntity)((Object)boatEntity)).getModVariant());
            resourceLocation = (ResourceLocation)pair.getFirst();
            listModel = (ListModel)pair.getSecond();
        }
        if (entity instanceof ModChestBoatEntity) {
            boatEntity = (ModChestBoatEntity)entity;
            pair = this.boatResources.get((Object)((ModChestBoatEntity)((Object)boatEntity)).getModVariant());
            resourceLocation = (ResourceLocation)pair.getFirst();
            listModel = (ListModel)pair.getSecond();
        }
        if (pair == null) {
            return;
        }
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        listModel.setupAnim((Entity)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = buffer.getBuffer(listModel.renderType(resourceLocation));
        listModel.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        if (!entity.isUnderWater()) {
            VertexConsumer vertexConsumer2 = buffer.getBuffer(RenderType.waterMask());
            if (listModel instanceof WaterPatchModel) {
                WaterPatchModel waterPatchModel = (WaterPatchModel)listModel;
                waterPatchModel.waterPatch().render(poseStack, vertexConsumer2, packedLight, OverlayTexture.NO_OVERLAY);
            }
        }
        poseStack.popPose();
        if (this.shouldShowName((Entity)entity)) {
            this.renderNameTag((Entity)entity, entity.getDisplayName(), poseStack, buffer, packedLight, partialTicks);
        }
    }
}

