/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.would.entities;

import com.ordana.would.entities.ModBoatEntity;
import com.ordana.would.reg.ModEntities;
import com.ordana.would.reg.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class ModChestBoatEntity
extends ChestBoat {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.defineId(ModChestBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ModChestBoatEntity(EntityType<? extends ChestBoat> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ModChestBoatEntity(Level pLevel, double pX, double pY, double pZ) {
        this(ModEntities.MOD_CHEST_BOAT.get(), pLevel);
        this.setPos(pX, pY, pZ);
        this.xo = pX;
        this.yo = pY;
        this.zo = pZ;
    }

    public Item getDropItem() {
        return switch (this.getModVariant()) {
            default -> throw new MatchException(null, null);
            case ModBoatEntity.Type.ASPEN -> ModItems.ASPEN_CHEST_BOAT.get();
            case ModBoatEntity.Type.AZALEA -> ModItems.AZALEA_CHEST_BOAT.get();
            case ModBoatEntity.Type.BAOBAB -> ModItems.BAOBAB_CHEST_BOAT.get();
            case ModBoatEntity.Type.BLUE_SPRUCE -> ModItems.BLUE_SPRUCE_CHEST_BOAT.get();
            case ModBoatEntity.Type.CEDAR -> ModItems.CEDAR_CHEST_BOAT.get();
            case ModBoatEntity.Type.EBONY -> ModItems.EBONY_CHEST_BOAT.get();
            case ModBoatEntity.Type.FIR -> ModItems.FIR_CHEST_BOAT.get();
            case ModBoatEntity.Type.MAHOGANY -> ModItems.MAHOGANY_CHEST_BOAT.get();
            case ModBoatEntity.Type.MAPLE -> ModItems.MAPLE_CHEST_BOAT.get();
            case ModBoatEntity.Type.PALM -> ModItems.PALM_CHEST_BOAT.get();
            case ModBoatEntity.Type.PINE -> ModItems.PINE_CHEST_BOAT.get();
            case ModBoatEntity.Type.WALNUT -> ModItems.WALNUT_CHEST_BOAT.get();
            case ModBoatEntity.Type.WILLOW -> ModItems.WILLOW_CHEST_BOAT.get();
        };
    }

    public void setVariant(ModBoatEntity.Type pVariant) {
        this.entityData.set(DATA_ID_TYPE, (Object)pVariant.ordinal());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE, (Object)ModBoatEntity.Type.PINE.ordinal());
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.putString("Type", this.getModVariant().getSerializedName());
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
        if (pCompound.contains("Type", 8)) {
            this.setVariant(ModBoatEntity.Type.byName(pCompound.getString("Type")));
        }
    }

    public ModBoatEntity.Type getModVariant() {
        return ModBoatEntity.Type.byId((Integer)this.entityData.get(DATA_ID_TYPE));
    }
}

