/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.would.entities;

import com.ordana.would.reg.ModEntities;
import com.ordana.would.reg.ModItems;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownWalnutEntity
extends ImprovedProjectileEntity {
    public ThrownWalnutEntity(EntityType<? extends ThrownWalnutEntity> type, Level world) {
        super(type, world);
    }

    public ThrownWalnutEntity(Level level, LivingEntity thrower, ItemStack item) {
        super(ModEntities.THROWN_WALNUT.get(), thrower, level);
        this.setItem(item);
    }

    public ThrownWalnutEntity(Level worldIn, double x, double y, double z) {
        super(ModEntities.THROWN_WALNUT.get(), x, y, z, worldIn);
    }

    protected Item getDefaultItem() {
        return ModItems.WALNUT.get();
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void updateRotation() {
    }

    protected void onHitEntity(EntityHitResult result) {
        Vec3 vec3;
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        double d = 0.0;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            d = Math.max(0.0, 1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
        }
        if ((vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(0.6 * d)).lengthSqr() > 0.0) {
            entity.push(vec3.x, 0.1, vec3.z);
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level.isClientSide) {
            this.level.broadcastEntityEvent((Entity)this, (byte)3);
            this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.BAMBOO_WOOD_BREAK, SoundSource.NEUTRAL, 0.75f, 2.5f + this.random.nextFloat() / 2.0f);
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, result.getLocation().x, result.getLocation().y + 0.5, result.getLocation().z, new ItemStack((ItemLike)this.getDefaultItem())));
            this.discard();
        }
    }
}

