/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.would.reg;

import com.ordana.would.reg.ModBlocks;
import com.ordana.would.reg.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class ModEvents {
    private static final List<InteractionEvent> EVENTS = new ArrayList<InteractionEvent>();

    public static InteractionResult onBlockCLicked(ItemStack stack, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.isEmpty()) {
            return InteractionResult.PASS;
        }
        Item i = stack.getItem();
        BlockPos pos = hitResult.getBlockPos();
        BlockState state = level.getBlockState(pos);
        for (InteractionEvent event : EVENTS) {
            InteractionResult result = event.run(i, stack, pos, state, player, level, hand, hitResult);
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult syrupBottling(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.GLASS_BOTTLE) && state.is(ModBlocks.MAPLE_LOG_SAPPY.get())) {
            level.playSound(player, pos, SoundEvents.HONEY_BLOCK_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            ParticleUtils.spawnParticlesOnBlockFaces((Level)level, (BlockPos)pos, (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.HONEY_BLOCK.defaultBlockState()), (IntProvider)UniformInt.of((int)3, (int)5));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ItemStack itemStack2 = ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)ModItems.SYRUP_BOTTLE.get().getDefaultInstance());
                player.setItemInHand(hand, itemStack2);
                level.setBlockAndUpdate(pos, ModBlocks.MAPLE_LOG.get().withPropertiesOf(state));
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, stack);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    static {
        EVENTS.add(ModEvents::syrupBottling);
    }

    @FunctionalInterface
    public static interface InteractionEvent {
        public InteractionResult run(Item var1, ItemStack var2, BlockPos var3, BlockState var4, Player var5, Level var6, InteractionHand var7, BlockHitResult var8);
    }
}

