/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.would.reg;

import com.google.common.collect.ImmutableMap;
import com.ordana.would.Would;
import com.ordana.would.reg.ModBlocks;
import java.util.HashSet;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;

public class ModWoodSetup {
    public static final WoodType ASPEN = new WoodType("aspen", BlockSetType.ACACIA);
    public static final WoodType AZALEA = new WoodType("azalea", BlockSetType.ACACIA);
    public static final WoodType BAOBAB = new WoodType("baobab", BlockSetType.ACACIA);
    public static final WoodType CEDAR = new WoodType("cedar", BlockSetType.ACACIA);
    public static final WoodType EBONY = new WoodType("ebony", BlockSetType.ACACIA);
    public static final WoodType FIR = new WoodType("fir", BlockSetType.ACACIA);
    public static final WoodType MAHOGANY = new WoodType("mahogany", BlockSetType.ACACIA);
    public static final WoodType MAPLE = new WoodType("maple", BlockSetType.ACACIA);
    public static final WoodType PALM = new WoodType("palm", BlockSetType.ACACIA);
    public static final WoodType PINE = new WoodType("pine", BlockSetType.ACACIA);
    public static final WoodType WALNUT = new WoodType("walnut", BlockSetType.ACACIA);
    public static final WoodType WILLOW = new WoodType("willow", BlockSetType.ACACIA);
    public static final WoodType BLUE_SPRUCE = new WoodType("blue_spruce", BlockSetType.ACACIA);

    private static void register(WoodType woodType) {
        WoodType.register((WoodType)woodType);
        if (PlatHelper.getPhysicalSide().isClient()) {
            Sheets.SIGN_MATERIALS.put(woodType, new Material(Sheets.SIGN_SHEET, Would.res("entity/signs/" + woodType.name())));
            Sheets.HANGING_SIGN_MATERIALS.put(woodType, new Material(Sheets.SIGN_SHEET, Would.res("entity/signs/hanging/" + woodType.name())));
        }
    }

    public static void init() {
        ModWoodSetup.register(ASPEN);
        ModWoodSetup.register(AZALEA);
        ModWoodSetup.register(BAOBAB);
        ModWoodSetup.register(CEDAR);
        ModWoodSetup.register(EBONY);
        ModWoodSetup.register(FIR);
        ModWoodSetup.register(MAHOGANY);
        ModWoodSetup.register(MAPLE);
        ModWoodSetup.register(PALM);
        ModWoodSetup.register(PINE);
        ModWoodSetup.register(WALNUT);
        ModWoodSetup.register(WILLOW);
        ModWoodSetup.register(BLUE_SPRUCE);
        HashSet<Block> validHangingSigns = new HashSet<Block>(BlockEntityType.HANGING_SIGN.validBlocks);
        validHangingSigns.add(ModBlocks.ASPEN_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.AZALEA_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.BAOBAB_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.CEDAR_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.EBONY_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.FIR_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.MAHOGANY_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.MAPLE_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.PALM_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.PINE_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.WALNUT_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.WILLOW_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.BLUE_SPRUCE_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.ASPEN_WALL_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.AZALEA_WALL_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.BAOBAB_WALL_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.CEDAR_WALL_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.EBONY_WALL_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.FIR_WALL_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.MAHOGANY_WALL_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.MAPLE_WALL_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.PALM_WALL_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.PINE_WALL_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.WALNUT_WALL_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.WILLOW_WALL_HANGING_SIGN.get());
        validHangingSigns.add(ModBlocks.BLUE_SPRUCE_WALL_HANGING_SIGN.get());
        BlockEntityType.HANGING_SIGN.validBlocks = validHangingSigns;
        HashSet<Block> validSigns = new HashSet<Block>(BlockEntityType.SIGN.validBlocks);
        validSigns.add(ModBlocks.ASPEN_SIGN.get());
        validSigns.add(ModBlocks.AZALEA_SIGN.get());
        validSigns.add(ModBlocks.BAOBAB_SIGN.get());
        validSigns.add(ModBlocks.CEDAR_SIGN.get());
        validSigns.add(ModBlocks.EBONY_SIGN.get());
        validSigns.add(ModBlocks.FIR_SIGN.get());
        validSigns.add(ModBlocks.MAHOGANY_SIGN.get());
        validSigns.add(ModBlocks.MAPLE_SIGN.get());
        validSigns.add(ModBlocks.PALM_SIGN.get());
        validSigns.add(ModBlocks.PINE_SIGN.get());
        validSigns.add(ModBlocks.WALNUT_SIGN.get());
        validSigns.add(ModBlocks.WILLOW_SIGN.get());
        validSigns.add(ModBlocks.BLUE_SPRUCE_SIGN.get());
        validSigns.add(ModBlocks.ASPEN_WALL_SIGN.get());
        validSigns.add(ModBlocks.AZALEA_WALL_SIGN.get());
        validSigns.add(ModBlocks.BAOBAB_WALL_SIGN.get());
        validSigns.add(ModBlocks.CEDAR_WALL_SIGN.get());
        validSigns.add(ModBlocks.EBONY_WALL_SIGN.get());
        validSigns.add(ModBlocks.FIR_WALL_SIGN.get());
        validSigns.add(ModBlocks.MAHOGANY_WALL_SIGN.get());
        validSigns.add(ModBlocks.MAPLE_WALL_SIGN.get());
        validSigns.add(ModBlocks.PALM_WALL_SIGN.get());
        validSigns.add(ModBlocks.PINE_WALL_SIGN.get());
        validSigns.add(ModBlocks.WALNUT_WALL_SIGN.get());
        validSigns.add(ModBlocks.WILLOW_WALL_SIGN.get());
        validSigns.add(ModBlocks.BLUE_SPRUCE_WALL_SIGN.get());
        BlockEntityType.SIGN.validBlocks = validSigns;
        ImmutableMap.Builder strippables = new ImmutableMap.Builder().putAll(AxeItem.STRIPPABLES);
        strippables.put((Object)ModBlocks.ASPEN_LOG.get(), (Object)ModBlocks.STRIPPED_ASPEN_LOG.get());
        strippables.put((Object)ModBlocks.ASPEN_LOG_GAZING.get(), (Object)ModBlocks.STRIPPED_ASPEN_LOG_GAZING.get());
        strippables.put((Object)ModBlocks.AZALEA_LOG.get(), (Object)ModBlocks.STRIPPED_AZALEA_LOG.get());
        strippables.put((Object)ModBlocks.BAOBAB_LOG.get(), (Object)ModBlocks.STRIPPED_BAOBAB_LOG.get());
        strippables.put((Object)ModBlocks.CEDAR_LOG.get(), (Object)ModBlocks.STRIPPED_CEDAR_LOG.get());
        strippables.put((Object)ModBlocks.EBONY_LOG.get(), (Object)ModBlocks.STRIPPED_EBONY_LOG.get());
        strippables.put((Object)ModBlocks.STRIPPED_EBONY_LOG.get(), (Object)ModBlocks.EBONY_HEARTWOOD_LOG.get());
        strippables.put((Object)ModBlocks.FIR_LOG.get(), (Object)ModBlocks.STRIPPED_FIR_LOG.get());
        strippables.put((Object)ModBlocks.MAHOGANY_LOG.get(), (Object)ModBlocks.STRIPPED_MAHOGANY_LOG.get());
        strippables.put((Object)ModBlocks.MAPLE_LOG.get(), (Object)ModBlocks.STRIPPED_MAPLE_LOG.get());
        strippables.put((Object)ModBlocks.PALM_LOG.get(), (Object)ModBlocks.STRIPPED_PALM_LOG.get());
        strippables.put((Object)ModBlocks.PINE_LOG.get(), (Object)ModBlocks.STRIPPED_PINE_LOG.get());
        strippables.put((Object)ModBlocks.WALNUT_LOG.get(), (Object)ModBlocks.STRIPPED_WALNUT_LOG.get());
        strippables.put((Object)ModBlocks.WILLOW_LOG.get(), (Object)ModBlocks.STRIPPED_WILLOW_LOG.get());
        strippables.put((Object)ModBlocks.BLUE_SPRUCE_LOG.get(), (Object)ModBlocks.STRIPPED_BLUE_SPRUCE_LOG.get());
        strippables.put((Object)ModBlocks.ASPEN_WOOD.get(), (Object)ModBlocks.STRIPPED_ASPEN_WOOD.get());
        strippables.put((Object)ModBlocks.ASPEN_WOOD_GAZING.get(), (Object)ModBlocks.STRIPPED_ASPEN_WOOD_GAZING.get());
        strippables.put((Object)ModBlocks.AZALEA_WOOD.get(), (Object)ModBlocks.STRIPPED_AZALEA_WOOD.get());
        strippables.put((Object)ModBlocks.BAOBAB_WOOD.get(), (Object)ModBlocks.STRIPPED_BAOBAB_WOOD.get());
        strippables.put((Object)ModBlocks.CEDAR_WOOD.get(), (Object)ModBlocks.STRIPPED_CEDAR_WOOD.get());
        strippables.put((Object)ModBlocks.EBONY_WOOD.get(), (Object)ModBlocks.STRIPPED_EBONY_WOOD.get());
        strippables.put((Object)ModBlocks.STRIPPED_EBONY_WOOD.get(), (Object)ModBlocks.EBONY_HEARTWOOD.get());
        strippables.put((Object)ModBlocks.FIR_WOOD.get(), (Object)ModBlocks.STRIPPED_FIR_WOOD.get());
        strippables.put((Object)ModBlocks.MAHOGANY_WOOD.get(), (Object)ModBlocks.STRIPPED_MAHOGANY_WOOD.get());
        strippables.put((Object)ModBlocks.MAPLE_WOOD.get(), (Object)ModBlocks.STRIPPED_MAPLE_WOOD.get());
        strippables.put((Object)ModBlocks.PALM_WOOD.get(), (Object)ModBlocks.STRIPPED_PALM_WOOD.get());
        strippables.put((Object)ModBlocks.PINE_WOOD.get(), (Object)ModBlocks.STRIPPED_PINE_WOOD.get());
        strippables.put((Object)ModBlocks.WALNUT_WOOD.get(), (Object)ModBlocks.STRIPPED_WALNUT_WOOD.get());
        strippables.put((Object)ModBlocks.WILLOW_WOOD.get(), (Object)ModBlocks.STRIPPED_WILLOW_WOOD.get());
        strippables.put((Object)ModBlocks.BLUE_SPRUCE_WOOD.get(), (Object)ModBlocks.STRIPPED_BLUE_SPRUCE_WOOD.get());
        AxeItem.STRIPPABLES = strippables.build();
    }
}

