/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.would.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.would.reg.ModTrees;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class AspenFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<AspenFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(foliagePlacerInstance -> AspenFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)foliagePlacerInstance).and((App)Codec.intRange((int)0, (int)12).fieldOf("height").forGetter(instance -> instance.height)).apply((Applicative)foliagePlacerInstance, AspenFoliagePlacer::new));
    private final int height;

    public AspenFoliagePlacer(IntProvider radius, IntProvider offset, int height) {
        super(radius, offset);
        this.height = height;
    }

    protected FoliagePlacerType<?> type() {
        return ModTrees.ASPEN_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        int k;
        boolean bl = attachment.doubleTrunk();
        BlockPos basePos = attachment.pos();
        BlockPos.MutableBlockPos pos = basePos.mutable();
        AspenFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
        pos.move(Direction.UP);
        AspenFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
        pos.move(Direction.UP);
        AspenFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
        pos.set((Vec3i)basePos);
        for (Direction dir : Direction.Plane.HORIZONTAL.shuffledCopy(random)) {
            pos.move(dir);
            AspenFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
            pos.move(dir.getOpposite());
        }
        for (k = 0; k <= foliageHeight; ++k) {
            this.placeLeavesRow(level, blockSetter, random, config, (BlockPos)pos, foliageRadius, -1, bl);
            pos.move(Direction.DOWN);
        }
        pos.move(Direction.UP);
        for (k = 0; k <= foliageHeight + 1; ++k) {
            this.placeLeavesRow(level, blockSetter, random, config, (BlockPos)pos, foliageRadius + 1, -2, bl);
            pos.move(Direction.DOWN);
        }
        pos.move(Direction.UP);
        this.placeLeavesRow(level, blockSetter, random, config, (BlockPos)pos, foliageRadius, -1, bl);
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return this.height;
    }

    protected boolean shouldSkipLocation(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        if (localY == -1) {
            return random.nextInt(3) == 1 && localX > 0 && localZ > 0;
        }
        if (localY == -2) {
            return random.nextInt(3) == 1 && (localX > 1 || localZ > 1);
        }
        return false;
    }
}

