/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.would.worldgen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.would.reg.ModTrees;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;

public class BaobabTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<BaobabTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(objectInstance -> BaobabTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)objectInstance).apply((Applicative)objectInstance, BaobabTrunkPlacer::new));

    public BaobabTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @NotNull
    protected TrunkPlacerType<?> type() {
        return ModTrees.BAOBAB_TRUNK_PLACER.get();
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        BlockPos blockPos = pos.below();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        ArrayList list = Lists.newArrayList();
        int j = freeTreeHeight / 2;
        if (random.nextBoolean()) {
            int q;
            int p;
            for (int i = 0; i < freeTreeHeight; ++i) {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 0, i, 0);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, 0);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, 1);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 0, i, 1);
            }
            int x = random.nextInt(0, 2);
            int z = random.nextInt(0, 2);
            for (int i = freeTreeHeight; i < freeTreeHeight + 4; ++i) {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, x, i, z);
            }
            list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(pos.getX() + x, pos.getY() + freeTreeHeight + 4, pos.getZ() + z), 0, false));
            if (random.nextBoolean()) {
                p = random.nextInt(0, 2);
                q = random.nextInt(0, 2);
                this.buildBranch(level, blockSetter, random, mutableBlockPos, config, pos, 0, -1, 0, -2, 0, -3, freeTreeHeight, p, q);
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(pos.getX() + 0, pos.getY() + freeTreeHeight + p + q, pos.getZ() + -3), 0, false));
            } else {
                p = random.nextInt(0, 2);
                q = random.nextInt(0, 2);
                this.buildBranch(level, blockSetter, random, mutableBlockPos, config, pos, 1, -1, 1, -2, 1, -3, freeTreeHeight, p, q);
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(pos.getX() + 1, pos.getY() + freeTreeHeight + p + q, pos.getZ() + -3), 0, false));
            }
            if (random.nextBoolean()) {
                p = random.nextInt(0, 2);
                q = random.nextInt(0, 2);
                this.buildBranch(level, blockSetter, random, mutableBlockPos, config, pos, -1, 0, -2, 0, -3, 0, freeTreeHeight, p, q);
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(pos.getX() + -3, pos.getY() + freeTreeHeight + p + q, pos.getZ() + 0), 0, false));
            } else {
                p = random.nextInt(0, 2);
                q = random.nextInt(0, 2);
                this.buildBranch(level, blockSetter, random, mutableBlockPos, config, pos, -1, 1, -2, 1, -3, 1, freeTreeHeight, p, q);
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(pos.getX() + -3, pos.getY() + freeTreeHeight + p + q, pos.getZ() + 1), 0, false));
            }
            if (random.nextBoolean()) {
                p = random.nextInt(0, 2);
                q = random.nextInt(0, 2);
                this.buildBranch(level, blockSetter, random, mutableBlockPos, config, pos, 2, 0, 3, 0, 4, 0, freeTreeHeight, p, q);
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(pos.getX() + 4, pos.getY() + freeTreeHeight + p + q, pos.getZ() + 0), 0, false));
            } else {
                p = random.nextInt(0, 2);
                q = random.nextInt(0, 2);
                this.buildBranch(level, blockSetter, random, mutableBlockPos, config, pos, 2, 1, 3, 1, 4, 1, freeTreeHeight, p, q);
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(pos.getX() + 4, pos.getY() + freeTreeHeight + p + q, pos.getZ() + 1), 0, false));
            }
            if (random.nextBoolean()) {
                p = random.nextInt(0, 2);
                q = random.nextInt(0, 2);
                this.buildBranch(level, blockSetter, random, mutableBlockPos, config, pos, 0, 2, 0, 3, 0, 4, freeTreeHeight, p, q);
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(pos.getX() + 0, pos.getY() + freeTreeHeight + p + q, pos.getZ() + 4), 0, false));
            } else {
                p = random.nextInt(0, 2);
                q = random.nextInt(0, 2);
                this.buildBranch(level, blockSetter, random, mutableBlockPos, config, pos, 1, 2, 1, 3, 1, 4, freeTreeHeight, p, q);
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(pos.getX() + 1, pos.getY() + freeTreeHeight + p + q, pos.getZ() + 4), 0, false));
            }
        } else {
            int q;
            int p;
            int i;
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos, (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.south(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.south().south(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.south().south().south(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.east(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.east().south(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.east().south().south(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.east().south().south().south(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.east().south().south().south().south(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.east().east(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.east().east().south(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.east().east().south().south(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.east().east().south().south().south(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.east().east().south().south().south().south(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.east().east().east(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.east().east().east().south(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.east().east().east().south().south(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.east().east().east().south().south().south(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.east().east().east().east().south(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.east().east().east().east().south().south(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.east().north(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.east().east().north(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.south().west(), (TreeConfiguration)config);
            BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos.south().south().west(), (TreeConfiguration)config);
            for (i = -1; i < j; ++i) {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, 0);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 2, i, 0);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 0, i, 1);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 0, i, 2);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 3, i, 1);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, 3);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 3, i, 2);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 2, i, 3);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, 1);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, 2);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 2, i, 1);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 2, i, 2);
            }
            for (i = 0; i < 3 + random.nextInt(4); ++i) {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 0, i, 0);
            }
            for (i = 0; i < 3 + random.nextInt(4); ++i) {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 3, i, 0);
            }
            for (i = 0; i < 3 + random.nextInt(4); ++i) {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 0, i, 3);
            }
            for (i = 0; i < 3 + random.nextInt(4); ++i) {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 3, i, 3);
            }
            this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, 0, -1);
            this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 2, 0, -1);
            if (random.nextBoolean()) {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, 1, -1);
            } else {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 2, 1, -1);
            }
            this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, -1, 0, 1);
            this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, -1, 0, 2);
            if (random.nextBoolean()) {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, -1, 1, 1);
            } else {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, -1, 1, 2);
            }
            this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 4, 0, 1);
            this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 4, 0, 2);
            if (random.nextBoolean()) {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 4, 1, 1);
            } else {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 4, 1, 2);
            }
            this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, 0, 4);
            this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 2, 0, 4);
            if (random.nextBoolean()) {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, 1, 4);
            } else {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 2, 1, 4);
            }
            int x = random.nextInt(1, 3);
            int z = random.nextInt(1, 3);
            for (int i2 = j; i2 < j + 4; ++i2) {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, x, i2, z);
            }
            list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(pos.getX() + x, pos.getY() + j + 4, pos.getZ() + z), 0, false));
            if (random.nextBoolean()) {
                p = random.nextInt(0, 2);
                q = random.nextInt(0, 2);
                this.buildBranch(level, blockSetter, random, mutableBlockPos, config, pos, 1, 0, 1, -1, 1, -2, j, p, q);
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(pos.getX() + 1, pos.getY() + j + p + q, pos.getZ() + -2), 0, false));
            } else {
                p = random.nextInt(0, 2);
                q = random.nextInt(0, 2);
                this.buildBranch(level, blockSetter, random, mutableBlockPos, config, pos, 2, 0, 2, -1, 2, -2, j, p, q);
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(pos.getX() + 2, pos.getY() + j + p + q, pos.getZ() + -2), 0, false));
            }
            if (random.nextBoolean()) {
                p = random.nextInt(0, 2);
                q = random.nextInt(0, 2);
                this.buildBranch(level, blockSetter, random, mutableBlockPos, config, pos, 0, 1, -1, 1, -2, 1, j, p, q);
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(pos.getX() + -2, pos.getY() + j + p + q, pos.getZ() + 1), 0, false));
            } else {
                p = random.nextInt(0, 2);
                q = random.nextInt(0, 2);
                this.buildBranch(level, blockSetter, random, mutableBlockPos, config, pos, 0, 2, -1, 2, -2, 2, j, p, q);
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(pos.getX() + -2, pos.getY() + j + p + q, pos.getZ() + 2), 0, false));
            }
            if (random.nextBoolean()) {
                p = random.nextInt(0, 2);
                q = random.nextInt(0, 2);
                this.buildBranch(level, blockSetter, random, mutableBlockPos, config, pos, 3, 1, 4, 1, 5, 1, j, p, q);
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(pos.getX() + 5, pos.getY() + j + p + q, pos.getZ() + 1), 0, false));
            } else {
                p = random.nextInt(0, 2);
                q = random.nextInt(0, 2);
                this.buildBranch(level, blockSetter, random, mutableBlockPos, config, pos, 3, 2, 4, 2, 5, 2, j, p, q);
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(pos.getX() + 5, pos.getY() + j + p + q, pos.getZ() + 2), 0, false));
            }
            if (random.nextBoolean()) {
                p = random.nextInt(0, 2);
                q = random.nextInt(0, 2);
                this.buildBranch(level, blockSetter, random, mutableBlockPos, config, pos, 1, 3, 1, 4, 1, 5, j, p, q);
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(pos.getX() + 1, pos.getY() + j + p + q, pos.getZ() + 5), 0, false));
            } else {
                p = random.nextInt(0, 2);
                q = random.nextInt(0, 2);
                this.buildBranch(level, blockSetter, random, mutableBlockPos, config, pos, 2, 3, 2, 4, 2, 5, j, p, q);
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(pos.getX() + 2, pos.getY() + j + p + q, pos.getZ() + 5), 0, false));
            }
        }
        return list;
    }

    private void placeLogIfFreeWithOffset(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos.MutableBlockPos pos, TreeConfiguration config, BlockPos offsetPos, int offsetX, int offsetY, int offsetZ) {
        pos.setWithOffset((Vec3i)offsetPos, offsetX, offsetY, offsetZ);
        this.placeLogIfFree(level, blockSetter, random, pos, config);
    }

    private void buildBranch(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos.MutableBlockPos mutableBlockPos, TreeConfiguration config, BlockPos pos, int x, int z, int x2, int z2, int x3, int z3, int j, int p, int q) {
        this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, x, j, z);
        this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, x2, j + p, z2);
        this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, x3, j + p + q, z3);
    }
}

