/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.would.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.would.reg.ModTrees;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class CedarFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<CedarFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(foliagePlacerInstance -> CedarFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)foliagePlacerInstance).and((App)Codec.intRange((int)0, (int)12).fieldOf("height").forGetter(instance -> instance.height)).apply((Applicative)foliagePlacerInstance, CedarFoliagePlacer::new));
    private final int height;

    public CedarFoliagePlacer(IntProvider radius, IntProvider offset, int height) {
        super(radius, offset);
        this.height = height;
    }

    protected FoliagePlacerType<?> type() {
        return ModTrees.CEDAR_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        boolean bl = attachment.doubleTrunk();
        BlockPos basePos = attachment.pos();
        BlockPos.MutableBlockPos pos = basePos.mutable();
        if (random.nextBoolean()) {
            CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
            pos.move(Direction.UP);
            CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
            pos.move(Direction.UP);
            CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
            pos.set((Vec3i)basePos);
            for (Direction dir : Direction.Plane.HORIZONTAL.shuffledCopy(random)) {
                pos.move(dir);
                CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.move(dir.getOpposite());
            }
            pos.move(Direction.DOWN);
            this.placeLeavesRow(level, blockSetter, random, config, (BlockPos)pos, 1, 0, bl);
            pos.move(Direction.DOWN);
            this.placeLeavesRow(level, blockSetter, random, config, (BlockPos)pos, 1, 0, bl);
            pos.move(Direction.DOWN);
            for (Direction dir : Direction.Plane.HORIZONTAL.shuffledCopy(random)) {
                pos.move(dir);
                CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.move(dir.getOpposite());
            }
        } else {
            CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
            pos.move(Direction.UP);
            CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
            pos.move(Direction.UP);
            CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
            pos.move(Direction.UP);
            CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
            pos.set((Vec3i)basePos);
            for (Direction dir : Direction.Plane.HORIZONTAL.shuffledCopy(random)) {
                pos.move(dir);
                CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.move(dir.getOpposite());
            }
            pos.move(Direction.DOWN);
            for (Direction dir : Direction.Plane.HORIZONTAL.shuffledCopy(random)) {
                pos.move(dir);
                CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.move(dir.getOpposite());
            }
            pos.move(Direction.DOWN);
            this.placeLeavesRow(level, blockSetter, random, config, (BlockPos)pos, 1, 0, bl);
            pos.move(Direction.DOWN);
            this.placeLeavesRow(level, blockSetter, random, config, (BlockPos)pos, 1, 0, bl);
            for (Direction dir : Direction.Plane.HORIZONTAL.shuffledCopy(random)) {
                pos.move(dir);
                pos.move(dir);
                CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.move(dir.getOpposite());
                pos.move(dir.getOpposite());
            }
            pos.move(Direction.DOWN);
            this.placeLeavesRow(level, blockSetter, random, config, (BlockPos)pos, 1, 0, bl);
            pos.move(Direction.DOWN);
            for (Direction dir : Direction.Plane.HORIZONTAL.shuffledCopy(random)) {
                pos.move(dir);
                CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.move(dir.getOpposite());
            }
        }
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return this.height;
    }

    protected boolean shouldSkipLocation(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return false;
    }
}

