/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.would.worldgen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.would.reg.ModTrees;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;

public class MapleTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<MapleTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(objectInstance -> MapleTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)objectInstance).apply((Applicative)objectInstance, MapleTrunkPlacer::new));

    public MapleTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @NotNull
    protected TrunkPlacerType<?> type() {
        return ModTrees.MAPLE_TRUNK_PLACER.get();
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos blockPos, TreeConfiguration config) {
        BlockPos.MutableBlockPos pos = blockPos.mutable();
        ArrayList list = Lists.newArrayList();
        this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
        for (int k = 0; k < (random.nextBoolean() ? this.heightRandA : this.heightRandB) + this.baseHeight; ++k) {
            if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
                this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
            }
            pos.move(Direction.UP);
        }
        if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
            this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
        }
        if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos.above())) {
            this.placeLog(level, blockSetter, random, pos.above(), config);
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            for (int k = 0; k < this.baseHeight; ++k) {
                pos.move(dir);
                if (!TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) continue;
                this.placeLog(level, blockSetter, random, (BlockPos)pos, config, blockState -> (BlockState)blockState.trySetValue((Property)RotatedPillarBlock.AXIS, (Comparable)this.getLogAxis(blockPos.relative(dir.getOpposite()), (BlockPos)pos)));
            }
            pos.move(dir.getOpposite(), this.baseHeight);
        }
        list.add(new FoliagePlacer.FoliageAttachment((BlockPos)pos.move(Direction.UP, this.baseHeight), 0, false));
        return list;
    }

    private Direction.Axis getLogAxis(BlockPos pos, BlockPos otherPos) {
        int j;
        Direction.Axis axis = Direction.Axis.Y;
        int i = Math.abs(otherPos.getX() - pos.getX());
        int k = Math.max(i, j = Math.abs(otherPos.getZ() - pos.getZ()));
        if (k > 0) {
            axis = i == k ? Direction.Axis.X : Direction.Axis.Z;
        }
        return axis;
    }
}

