/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.would.worldgen;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.would.reg.ModTrees;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class PalmFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<PalmFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(foliagePlacerInstance -> PalmFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)foliagePlacerInstance).apply((Applicative)foliagePlacerInstance, PalmFoliagePlacer::new));

    public PalmFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    protected FoliagePlacerType<?> type() {
        return ModTrees.PALM_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        BlockPos basePos = attachment.pos();
        BlockPos.MutableBlockPos pos = basePos.mutable();
        this.placeLeavesRow(level, blockSetter, random, config, basePos, 1, -1, attachment.doubleTrunk());
        PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)basePos);
        if (random.nextBoolean()) {
            for (Direction dir : Direction.Plane.HORIZONTAL.shuffledCopy(random)) {
                pos.move(dir);
                PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.move(dir);
                pos.move(Direction.UP);
                PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.move(dir);
                PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.move(dir);
                pos.move(Direction.DOWN);
                PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.set((Vec3i)basePos);
            }
            for (Direction dir : Direction.Plane.HORIZONTAL.shuffledCopy(random)) {
                pos.move(Direction.DOWN);
                pos.move(dir);
                pos.move(dir);
                PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.move(Direction.DOWN);
                pos.move(dir);
                PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.move(Direction.DOWN);
                pos.move(dir);
                PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.move(Direction.DOWN);
                PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.set((Vec3i)basePos);
                pos.move(Direction.DOWN);
                pos.move(dir);
                pos.move(dir);
                pos.move(dir.getClockWise(Direction.Axis.Y));
                pos.move(dir.getClockWise(Direction.Axis.Y));
                PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.move(Direction.DOWN);
                pos.move(dir);
                pos.move(dir.getClockWise(Direction.Axis.Y));
                PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.set((Vec3i)basePos);
            }
        } else {
            for (Direction dir : Direction.Plane.HORIZONTAL.shuffledCopy(random)) {
                pos.move(dir);
                PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.move(dir);
                pos.move(Direction.UP);
                PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.move(dir);
                PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.set((Vec3i)basePos);
            }
            for (Direction dir : Direction.Plane.HORIZONTAL.shuffledCopy(random)) {
                pos.move(Direction.DOWN);
                pos.move(dir);
                pos.move(dir);
                PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.move(Direction.DOWN);
                pos.move(dir);
                PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.move(Direction.DOWN);
                PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.set((Vec3i)basePos);
                pos.move(Direction.DOWN);
                pos.move(dir);
                pos.move(dir);
                pos.move(dir.getClockWise(Direction.Axis.Y));
                pos.move(dir.getClockWise(Direction.Axis.Y));
                PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)pos);
                pos.set((Vec3i)basePos);
            }
        }
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return 1;
    }

    protected boolean shouldSkipLocation(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return false;
    }
}

