/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.would.worldgen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.would.reg.ModTrees;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;

public class PalmTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<PalmTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(objectInstance -> PalmTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)objectInstance).apply((Applicative)objectInstance, PalmTrunkPlacer::new));

    public PalmTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @NotNull
    protected TrunkPlacerType<?> type() {
        return ModTrees.PALM_TRUNK_PLACER.get();
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos blockPos, TreeConfiguration config) {
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        BlockPos.MutableBlockPos pos = blockPos.mutable();
        ArrayList list = Lists.newArrayList();
        int bottomHeight = this.heightRandA + random.nextInt(2);
        int middleHeight = this.heightRandB + random.nextInt(2);
        this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
        if (random.nextBoolean()) {
            int k;
            for (k = 0; k <= bottomHeight; ++k) {
                if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
                    this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
                }
                pos.move(Direction.UP);
            }
            pos.move(direction);
            for (k = 0; k <= middleHeight; ++k) {
                if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
                    this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
                }
                pos.move(Direction.UP);
            }
            pos.move(direction);
            for (k = 0; k <= 2; ++k) {
                if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
                    this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
                }
                pos.move(Direction.UP);
            }
        } else {
            for (int k = 0; k <= (this.baseHeight + random.nextInt(2)) / 2; ++k) {
                for (int h = 0; h <= k; ++h) {
                    if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
                        this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
                    }
                    pos.move(Direction.UP);
                }
                pos.move(direction);
            }
            pos.move(direction.getOpposite());
        }
        list.add(new FoliagePlacer.FoliageAttachment(pos.immutable(), 0, false));
        return list;
    }
}

