/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.would.worldgen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.would.reg.ModTrees;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class WillowTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<WillowTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(objectInstance -> WillowTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)objectInstance).apply((Applicative)objectInstance, WillowTrunkPlacer::new));

    public WillowTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    protected TrunkPlacerType<?> type() {
        return ModTrees.WILLOW_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos blockPos, TreeConfiguration config) {
        Direction finalClockDir;
        int h;
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        Direction clockDir = direction.getClockWise();
        if (random.nextBoolean()) {
            clockDir = clockDir.getOpposite();
        }
        BlockPos.MutableBlockPos pos = blockPos.mutable();
        ArrayList list = Lists.newArrayList();
        for (Direction dir : Direction.Plane.HORIZONTAL.shuffledCopy(random)) {
            pos.move(dir);
            pos.move(Direction.DOWN);
            this.forceLog(blockSetter, random, (BlockPos)pos, config);
            if (random.nextBoolean()) {
                pos.move(Direction.UP);
                this.forceLog(blockSetter, random, (BlockPos)pos, config);
                if (random.nextBoolean()) {
                    pos.move(Direction.UP);
                    this.forceLog(blockSetter, random, (BlockPos)pos, config);
                }
            }
            pos.set((Vec3i)blockPos);
        }
        this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
        for (h = 0; h < freeTreeHeight; ++h) {
            if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
                this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
            }
            pos.move(Direction.UP);
        }
        pos.move(direction);
        for (h = 0; h < 2; ++h) {
            if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
                this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
            }
            pos.move(Direction.UP);
        }
        if (random.nextBoolean()) {
            pos.move(clockDir);
            pos.move(Direction.DOWN);
            for (h = 0; h < 2; ++h) {
                if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
                    finalClockDir = clockDir;
                    this.placeLog(level, blockSetter, random, (BlockPos)pos, config, blockState -> (BlockState)blockState.trySetValue((Property)RotatedPillarBlock.AXIS, (Comparable)this.getLogAxis(blockPos.relative(finalClockDir.getOpposite()), (BlockPos)pos)));
                }
                pos.move(clockDir);
            }
            pos.move(Direction.DOWN);
            if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
                this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
            }
            list.add(new FoliagePlacer.FoliageAttachment(pos.immutable(), 0, false));
            pos.move(Direction.UP);
            pos.move(Direction.UP);
            pos.move(clockDir.getOpposite());
            pos.move(clockDir.getOpposite());
            pos.move(clockDir.getOpposite());
        }
        pos.move(direction);
        if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
            this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
        }
        pos.move(Direction.UP);
        if (random.nextBoolean()) {
            clockDir = clockDir.getOpposite();
            pos.move(clockDir);
            pos.move(Direction.DOWN);
            for (h = 0; h < 2; ++h) {
                if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
                    finalClockDir = clockDir;
                    this.placeLog(level, blockSetter, random, (BlockPos)pos, config, blockState -> (BlockState)blockState.trySetValue((Property)RotatedPillarBlock.AXIS, (Comparable)this.getLogAxis(blockPos.relative(finalClockDir.getOpposite()).relative(finalClockDir.getOpposite()).relative(finalClockDir.getOpposite()), (BlockPos)pos)));
                }
                pos.move(clockDir);
            }
            pos.move(Direction.DOWN);
            if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
                this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
            }
            list.add(new FoliagePlacer.FoliageAttachment(pos.immutable(), 0, false));
            pos.move(Direction.UP);
            pos.move(Direction.UP);
            pos.move(clockDir.getOpposite());
            pos.move(clockDir.getOpposite());
            pos.move(clockDir.getOpposite());
        }
        if (random.nextBoolean()) {
            pos.move(direction.getOpposite());
            if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
                this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
            }
            pos.move(Direction.UP);
            if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
                this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
            }
            pos.move(Direction.UP);
            pos.move(direction.getOpposite());
            if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
                this.placeLog(level, blockSetter, random, (BlockPos)pos, config);
            }
            list.add(new FoliagePlacer.FoliageAttachment(pos.immutable(), 0, false));
            pos.move(Direction.DOWN);
            pos.move(Direction.DOWN);
            pos.move(direction);
            pos.move(direction);
        }
        pos.move(direction);
        for (h = 0; h < this.heightRandA; ++h) {
            this.placeLog(level, blockSetter, random, (BlockPos)pos, config, blockState -> (BlockState)blockState.trySetValue((Property)RotatedPillarBlock.AXIS, (Comparable)this.getLogAxis(blockPos, (BlockPos)pos)));
            pos.move(direction);
        }
        pos.move(Direction.DOWN);
        this.placeLog(level, blockSetter, random, (BlockPos)pos, config, blockState -> (BlockState)blockState.trySetValue((Property)RotatedPillarBlock.AXIS, (Comparable)this.getLogAxis(blockPos, (BlockPos)pos)));
        pos.move(Direction.UP);
        list.add(new FoliagePlacer.FoliageAttachment(pos.immutable(), 0, false));
        return list;
    }

    protected void forceLog(BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config) {
        this.forceLog(blockSetter, random, pos, config, Function.identity());
    }

    protected void forceLog(BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config, Function<BlockState, BlockState> propertySetter) {
        blockSetter.accept(pos, propertySetter.apply(config.trunkProvider.getState(random, pos)));
    }

    private Direction.Axis getLogAxis(BlockPos pos, BlockPos otherPos) {
        int j;
        Direction.Axis axis = Direction.Axis.Y;
        int i = Math.abs(otherPos.getX() - pos.getX());
        int k = Math.max(i, j = Math.abs(otherPos.getZ() - pos.getZ()));
        if (k > 0) {
            axis = i == k ? Direction.Axis.X : Direction.Axis.Z;
        }
        return axis;
    }
}

