/*
 * Decompiled with CFR 0.152.
 */
package com.example.animaltransfer;

import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTContainer;
import de.tr7zw.nbtapi.NBTEntity;
import de.tr7zw.nbtapi.NBTItem;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AnimalTransfer
extends JavaPlugin
implements Listener {
    private List<EntityType> blacklistedEntities = new ArrayList<EntityType>();
    private Material itemMaterial;
    private boolean playSounds;
    private boolean showParticles;
    private boolean allowBlacklist;
    private String lang;
    private FileConfiguration config;

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadConfiguration();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("AnimalTransfer plugin has been enabled!");
    }

    private void reloadConfiguration() {
        this.reloadConfig();
        this.config = this.getConfig();
        this.lang = this.config.getString("language", "ru");
        this.allowBlacklist = this.config.getBoolean("settings.allow_blacklist", false);
        this.playSounds = this.config.getBoolean("settings.play_sounds", true);
        this.showParticles = this.config.getBoolean("settings.show_particles", true);
        String materialName = this.config.getString("settings.item_material", "HEART_OF_THE_SEA");
        try {
            this.itemMaterial = Material.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warning("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430: " + materialName + ". \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f HEART_OF_THE_SEA \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e.");
            this.itemMaterial = Material.HEART_OF_THE_SEA;
        }
        this.blacklistedEntities.clear();
        if (!this.allowBlacklist) {
            List blacklist = this.config.getStringList("blacklist");
            for (String entityName : blacklist) {
                try {
                    EntityType type = EntityType.valueOf((String)entityName.toUpperCase());
                    this.blacklistedEntities.add(type);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 \u0432 blacklist: " + entityName);
                }
            }
        }
        this.getLogger().info("\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e " + this.blacklistedEntities.size() + " \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0435\u0439 \u0432 blacklist.");
    }

    public void onDisable() {
        this.getLogger().info("AnimalTransfer plugin has been disabled!");
    }

    private String getMessage(String key, String animalName) {
        String path = "messages." + this.lang + "." + key;
        String msg = this.config.getString(path, "");
        if (animalName != null) {
            msg = msg.replace("{animal}", animalName);
        }
        return msg;
    }

    private String getMessage(String key, String animalName, String type) {
        String msg = this.getMessage(key, animalName);
        if (type != null) {
            msg = msg.replace("{type}", type);
        }
        return msg;
    }

    @EventHandler
    public void onEntityRightClick(PlayerInteractEntityEvent event) {
        boolean canBypass;
        Entity entity = event.getRightClicked();
        Player player = event.getPlayer();
        if (!player.hasPermission("animaltransfer.use") || !player.hasPermission("animaltransfer.pickup")) {
            player.sendMessage((Component)Component.text((String)this.getMessage("no_permission_pickup", null), (TextColor)NamedTextColor.RED));
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            player.sendMessage((Component)Component.text((String)this.getMessage("entity_not_living", null), (TextColor)NamedTextColor.RED));
            return;
        }
        boolean bl = canBypass = player.hasPermission("animaltransfer.bypass.blacklist") || player.hasPermission("animaltransfer.admin");
        if (!canBypass && this.blacklistedEntities.contains(entity.getType())) {
            player.sendMessage((Component)Component.text((String)this.getMessage("blacklisted_entity", null), (TextColor)NamedTextColor.RED));
            return;
        }
        if (player.getInventory().getItemInMainHand().getType() == Material.NAME_TAG || player.getInventory().getItemInOffHand().getType() == Material.NAME_TAG) {
            return;
        }
        event.setCancelled(true);
        String animalName = this.getEntityName(entity);
        ItemStack transferItem = new ItemStack(this.itemMaterial);
        ItemMeta meta = transferItem.getItemMeta();
        if (meta != null) {
            meta.displayName((Component)Component.text((String)this.getMessage("item_name", animalName), (TextColor)NamedTextColor.GOLD));
            meta.lore(List.of(Component.text((String)this.getMessage("item_lore", animalName), (TextColor)NamedTextColor.GRAY)));
            transferItem.setItemMeta(meta);
        }
        try {
            NBTEntity nbtEntity = new NBTEntity(entity);
            NBTItem nbtItem = new NBTItem(transferItem);
            nbtItem.setString("animal_nbt", nbtEntity.asNBTString());
            nbtItem.setString("animal_type", entity.getType().name());
            transferItem = nbtItem.getItem();
        }
        catch (Exception e) {
            player.sendMessage((Component)Component.text((String)this.getMessage("error_invalid_item", null), (TextColor)NamedTextColor.RED));
            this.getLogger().warning("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 NBT \u0434\u0430\u043d\u043d\u044b\u0445: " + e.getMessage());
            return;
        }
        if (player.getInventory().firstEmpty() == -1) {
            player.sendMessage((Component)Component.text((String)this.getMessage("inventory_full", null), (TextColor)NamedTextColor.RED));
            return;
        }
        player.getInventory().addItem(new ItemStack[]{transferItem});
        entity.remove();
        if (this.playSounds) {
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, SoundCategory.PLAYERS, 1.0f, 1.0f);
            player.getWorld().playSound(entity.getLocation(), Sound.ENTITY_ITEM_PICKUP, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
        if (this.showParticles) {
            player.getWorld().spawnParticle(Particle.CLOUD, entity.getLocation(), 20, 0.5, 0.5, 0.5, 0.1);
            player.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, entity.getLocation(), 10, 0.5, 0.5, 0.5, 0.1);
        }
        player.sendActionBar((Component)Component.text((String)this.getMessage("animal_taken", animalName), (TextColor)NamedTextColor.GREEN));
    }

    @EventHandler
    public void onPlayerUseEgg(PlayerInteractEvent event) {
        Entity spawned;
        EntityType type;
        NBTItem nbtItem;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        if (!player.hasPermission("animaltransfer.use") || !player.hasPermission("animaltransfer.useitem")) {
            player.sendMessage((Component)Component.text((String)this.getMessage("no_permission_use", null), (TextColor)NamedTextColor.RED));
            event.setCancelled(true);
            return;
        }
        try {
            nbtItem = new NBTItem(item);
        }
        catch (Exception e) {
            return;
        }
        if (!nbtItem.hasKey("animal_nbt").booleanValue()) {
            return;
        }
        String nbtString = nbtItem.getString("animal_nbt");
        String entityTypeName = nbtItem.getString("animal_type");
        if (nbtString == null || entityTypeName == null) {
            player.sendMessage((Component)Component.text((String)this.getMessage("error_invalid_type", null), (TextColor)NamedTextColor.RED));
            event.setCancelled(true);
            return;
        }
        try {
            type = EntityType.valueOf((String)entityTypeName);
        }
        catch (Exception e) {
            player.sendMessage((Component)Component.text((String)this.getMessage("error_unknown_type", null, entityTypeName), (TextColor)NamedTextColor.RED));
            event.setCancelled(true);
            return;
        }
        Location loc = event.getClickedBlock().getRelative(event.getBlockFace()).getLocation().add(0.5, 1.0, 0.5);
        try {
            spawned = player.getWorld().spawnEntity(loc, type);
        }
        catch (Exception e) {
            player.sendMessage((Component)Component.text((String)this.getMessage("error_spawn", null), (TextColor)NamedTextColor.RED));
            event.setCancelled(true);
            return;
        }
        try {
            NBTContainer container = new NBTContainer(nbtString);
            container.removeKey("Pos");
            container.removeKey("Motion");
            container.removeKey("Rotation");
            NBTEntity nbtEntity = new NBTEntity(spawned);
            nbtEntity.mergeCompound((NBTCompound)container);
        }
        catch (Exception e) {
            spawned.remove();
            player.sendMessage((Component)Component.text((String)this.getMessage("error_restore", null), (TextColor)NamedTextColor.RED));
            event.setCancelled(true);
            return;
        }
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        } else {
            player.getInventory().removeItem(new ItemStack[]{item});
        }
        if (this.playSounds) {
            player.playSound(loc, Sound.ENTITY_ITEM_PICKUP, SoundCategory.PLAYERS, 1.0f, 1.2f);
            player.getWorld().playSound(loc, Sound.ENTITY_CHICKEN_EGG, SoundCategory.NEUTRAL, 0.5f, 1.0f);
        }
        if (this.showParticles) {
            player.getWorld().spawnParticle(Particle.CLOUD, loc, 30, 0.5, 0.5, 0.5, 0.1);
            player.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, loc, 15, 0.5, 0.5, 0.5, 0.1);
            Location heartLoc = loc.clone().add(0.0, 1.0, 0.0);
            player.getWorld().spawnParticle(Particle.HEART, heartLoc, 5, 0.3, 0.3, 0.3, 0.1);
        }
        String animalName = this.getEntityName(spawned);
        player.sendActionBar((Component)Component.text((String)this.getMessage("animal_spawned", animalName), (TextColor)NamedTextColor.GREEN));
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        event.getPlayer().sendActionBar((Component)Component.text((String)"AnimalTransfer: \u041f\u043b\u0430\u0433\u0438\u043d \u0441\u043e\u0437\u0434\u0430\u043d \u0431\u043b\u0430\u0433\u043e\u0434\u0430\u0440\u044f ZDev", (TextColor)NamedTextColor.GREEN));
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        ItemStack[] matrix;
        CraftingInventory inventory = event.getInventory();
        for (ItemStack item : matrix = inventory.getMatrix()) {
            if (item == null || item.getType() == Material.AIR) continue;
            try {
                NBTItem nbtItem = new NBTItem(item);
                if (!nbtItem.hasKey("animal_nbt").booleanValue()) continue;
                inventory.setResult(null);
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        ItemStack[] matrix;
        CraftingInventory inventory = event.getInventory();
        for (ItemStack item : matrix = inventory.getMatrix()) {
            if (item == null || item.getType() == Material.AIR) continue;
            try {
                NBTItem nbtItem = new NBTItem(item);
                if (!nbtItem.hasKey("animal_nbt").booleanValue()) continue;
                event.setCancelled(true);
                if (event.getWhoClicked() instanceof Player) {
                    Player player = (Player)event.getWhoClicked();
                    player.sendMessage((Component)Component.text((String)this.getMessage("craft_blocked", null), (TextColor)NamedTextColor.RED));
                }
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private String getEntityName(Entity entity) {
        String name = entity.getType().name().toLowerCase();
        String[] words = name.split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }
}

