/*
 * Decompiled with CFR 0.152.
 */
package com.hro_basti.timberella;

import com.hro_basti.timberella.commands.TimberellaCommand;
import com.hro_basti.timberella.commands.TimberellaTabCompleter;
import com.hro_basti.timberella.listeners.TreeChopListener;
import com.hro_basti.timberella.listeners.UpdateNotifyListener;
import com.hro_basti.timberella.metrics.Metrics;
import com.hro_basti.timberella.update.UpdateChecker;
import com.hro_basti.timberella.util.MessageService;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class TimberellaPlugin
extends JavaPlugin {
    private static final int BSTATS_PLUGIN_ID = 28062;
    private MessageService messages;
    private UpdateChecker updateChecker;
    private TreeChopListener treeChopListener;
    private Metrics metrics;
    private volatile long lastConfigModified = 0L;
    private volatile boolean configWatchEnabledFlag = true;
    private BukkitTask configWatcherTask;
    private BukkitTask periodicUpdateTask;
    private volatile UpdateChecker.UpdateInfo pendingUpdateInfo;
    private final Set<UUID> disabledPlayers = Collections.synchronizedSet(new HashSet());

    public void onEnable() {
        this.saveDefaultConfig();
        this.ensureResourceExists("leaf_mappings.yml");
        this.messages = new MessageService(this);
        String lang = this.getConfig().getString("language", "en_US");
        this.messages.load(lang);
        PluginCommand timberellaCommand = this.getCommand("timberella");
        if (timberellaCommand == null) {
            this.getLogger().severe("Command 'timberella' is missing from plugin.yml. Disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        TimberellaCommand executor = new TimberellaCommand(this);
        timberellaCommand.setExecutor((CommandExecutor)executor);
        timberellaCommand.setTabCompleter((TabCompleter)new TimberellaTabCompleter(this));
        this.mergeMissingConfigKeys();
        this.updateConfigModifiedTimestamp();
        this.refreshConfigWatchFlag();
        PluginManager pm = Bukkit.getPluginManager();
        this.treeChopListener = new TreeChopListener(this);
        pm.registerEvents((Listener)this.treeChopListener, (Plugin)this);
        pm.registerEvents((Listener)new UpdateNotifyListener(this), (Plugin)this);
        this.configureUpdateChecker();
        this.startConfigWatcher();
        this.loadToggles();
        this.setupMetrics();
        this.getLogger().info("Timberella enabled.");
    }

    public void onDisable() {
        this.shutdownMetrics();
        this.cancelScheduledUpdateChecks();
        this.stopConfigWatcher();
        this.getLogger().info("Timberella disabled.");
    }

    public MessageService messages() {
        return this.messages;
    }

    public void reloadAndMergeConfig() {
        this.reloadConfig();
        String lang = this.getConfig().getString("language", "en_US");
        this.messages.load(lang);
        if (this.treeChopListener != null) {
            this.treeChopListener.refresh();
        }
        this.updateConfigModifiedTimestamp();
        this.refreshConfigWatchFlag();
        this.setupMetrics();
        this.configureUpdateChecker();
    }

    private void mergeMissingConfigKeys() {
        InputStream in = this.getResource("config.yml");
        if (in == null) {
            return;
        }
        YamlConfiguration defaults = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        FileConfiguration current = this.getConfig();
        this.mergeSections((ConfigurationSection)current, (ConfigurationSection)defaults);
        this.saveConfig();
    }

    private void startConfigWatcher() {
        this.stopConfigWatcher();
        this.configWatcherTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            if (!this.configWatchEnabledFlag) {
                return;
            }
            try {
                File file = new File(this.getDataFolder(), "config.yml");
                if (!file.exists()) {
                    return;
                }
                long lm = file.lastModified();
                if (lm > this.lastConfigModified) {
                    this.lastConfigModified = lm;
                    Bukkit.getScheduler().runTask((Plugin)this, this::reloadAndMergeConfig);
                }
            }
            catch (Exception e) {
                this.getLogger().fine("Config watcher error: " + e.getMessage());
            }
        }, 100L, 100L);
    }

    private void updateConfigModifiedTimestamp() {
        File file = new File(this.getDataFolder(), "config.yml");
        if (file.exists()) {
            this.lastConfigModified = file.lastModified();
        }
    }

    private void refreshConfigWatchFlag() {
        this.configWatchEnabledFlag = this.getConfig().getBoolean("config_watch_enabled", true);
    }

    private void stopConfigWatcher() {
        if (this.configWatcherTask != null) {
            this.configWatcherTask.cancel();
            this.configWatcherTask = null;
        }
    }

    public boolean isEnabledFor(UUID uuid) {
        return !this.disabledPlayers.contains(uuid);
    }

    public void setEnabledFor(UUID uuid, boolean enabled) {
        if (enabled) {
            this.disabledPlayers.remove(uuid);
        } else {
            this.disabledPlayers.add(uuid);
        }
        this.saveToggles();
    }

    public boolean toggleEnabled(UUID uuid) {
        boolean now = !this.disabledPlayers.contains(uuid);
        this.setEnabledFor(uuid, !now);
        return !now;
    }

    private File togglesFile() {
        return new File(this.getDataFolder(), "toggles.yml");
    }

    private void loadToggles() {
        try {
            File f = this.togglesFile();
            if (!f.exists()) {
                return;
            }
            YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)f);
            List list = cfg.getStringList("disabled");
            this.disabledPlayers.clear();
            for (String s : list) {
                try {
                    this.disabledPlayers.add(UUID.fromString(s));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            this.getLogger().fine("Failed to load toggles.yml: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToggles() {
        try {
            File f = this.togglesFile();
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            YamlConfiguration cfg = new YamlConfiguration();
            ArrayList<String> list = new ArrayList<String>();
            Set<UUID> set = this.disabledPlayers;
            synchronized (set) {
                for (UUID u : this.disabledPlayers) {
                    list.add(u.toString());
                }
            }
            cfg.set("disabled", list);
            cfg.save(f);
        }
        catch (Exception e) {
            this.getLogger().fine("Failed to save toggles.yml: " + e.getMessage());
        }
    }

    private void mergeSections(ConfigurationSection target, ConfigurationSection defaults) {
        for (String key : defaults.getKeys(false)) {
            Object defVal = defaults.get(key);
            if (!target.contains(key)) {
                target.set(key, defVal);
                continue;
            }
            if (!(defVal instanceof ConfigurationSection)) continue;
            ConfigurationSection defChild = defaults.getConfigurationSection(key);
            ConfigurationSection tgtChild = target.getConfigurationSection(key);
            if (defChild == null || tgtChild == null) continue;
            this.mergeSections(tgtChild, defChild);
        }
    }

    private void setupMetrics() {
        boolean enabled = this.getConfig().getBoolean("metrics_enabled", true);
        if (!enabled) {
            this.shutdownMetrics();
            return;
        }
        if (this.metrics != null) {
            return;
        }
        this.metrics = new Metrics((Plugin)this, 28062);
        this.registerMetricsCharts(this.metrics);
    }

    private void shutdownMetrics() {
        if (this.metrics != null) {
            this.metrics.shutdown();
            this.metrics = null;
        }
    }

    private void registerMetricsCharts(Metrics metricsInstance) {
        metricsInstance.addCustomChart(new Metrics.SimplePie("language", () -> this.getConfig().getString("language", "en_US")));
        metricsInstance.addCustomChart(new Metrics.SimplePie("sneak_mode", () -> switch (this.getConfig().getInt("sneak_mode", 0)) {
            case 1 -> "not_sneaking";
            case 2 -> "always";
            default -> "sneak_only";
        }));
        metricsInstance.addCustomChart(new Metrics.SimplePie("durability_mode", () -> this.getConfig().getString("tools.durability_mode", "first")));
        metricsInstance.addCustomChart(new Metrics.SimplePie("update_provider", () -> switch (this.getConfig().getInt("update_provider", 0)) {
            case 1 -> "modrinth_only";
            case 2 -> "hangar_only";
            default -> "modrinth_hangar";
        }));
        metricsInstance.addCustomChart(new Metrics.AdvancedPie("enabled_modules", () -> {
            HashMap<String, Integer> values = new HashMap<String, Integer>();
            if (this.getConfig().getBoolean("enable_timber", true)) {
                values.put("timber", 1);
            }
            if (this.getConfig().getBoolean("enable_replant", true)) {
                values.put("replant_listener", 1);
            }
            if (this.getConfig().getBoolean("enable_leaves_decay", true)) {
                values.put("leaves_decay", 1);
            }
            if (this.getConfig().getBoolean("replant.enabled", true)) {
                values.put("sapling_replant", 1);
            }
            return values;
        }));
        metricsInstance.addCustomChart(new Metrics.SimplePie("config_watch", () -> this.getConfig().getBoolean("config_watch_enabled", true) ? "enabled" : "disabled"));
        metricsInstance.addCustomChart(new Metrics.SingleLineChart("max_blocks_limit", () -> this.getConfig().getInt("max_blocks", 1024)));
        metricsInstance.addCustomChart(new Metrics.SimplePie("player_toggle_usage", () -> {
            Set<UUID> set = this.disabledPlayers;
            synchronized (set) {
                return this.disabledPlayers.isEmpty() ? "all_enabled" : "some_disabled";
            }
        }));
    }

    private void configureUpdateChecker() {
        this.cancelScheduledUpdateChecks();
        this.pendingUpdateInfo = null;
        if (!this.getConfig().getBoolean("check_updates", true)) {
            this.updateChecker = null;
            return;
        }
        int provider = this.getConfig().getInt("update_provider", 0);
        boolean includePrereleases = this.getConfig().getBoolean("update_include_prereleases", false);
        this.updateChecker = new UpdateChecker(this, provider, includePrereleases);
        this.scheduleUpdateChecks();
    }

    private void scheduleUpdateChecks() {
        if (this.updateChecker == null) {
            return;
        }
        long hours = Math.max(1L, this.getConfig().getLong("update_check_interval_hours", 24L));
        long ticks = hours * 60L * 60L * 20L;
        this.triggerUpdateCheck();
        this.periodicUpdateTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, this::triggerUpdateCheck, ticks, ticks);
    }

    private void cancelScheduledUpdateChecks() {
        if (this.periodicUpdateTask != null) {
            this.periodicUpdateTask.cancel();
            this.periodicUpdateTask = null;
        }
    }

    private void triggerUpdateCheck() {
        if (this.updateChecker == null) {
            return;
        }
        this.updateChecker.checkAsync().thenAccept(this::handleUpdateInfo);
    }

    private void handleUpdateInfo(UpdateChecker.UpdateInfo info) {
        if (info == null) {
            this.pendingUpdateInfo = null;
            return;
        }
        boolean alreadyAnnounced = this.pendingUpdateInfo != null && this.pendingUpdateInfo.latestVersion().equals(info.latestVersion());
        this.pendingUpdateInfo = info;
        if (alreadyAnnounced) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("latest_ver", info.latestVersion());
            placeholders.put("current_ver", info.currentVersion());
            this.getServer().getConsoleSender().sendMessage(this.messages.format("update_available", placeholders));
        });
    }

    public UpdateChecker.UpdateInfo getPendingUpdateInfo() {
        return this.pendingUpdateInfo;
    }

    private void ensureResourceExists(String relativePath) {
        File out = new File(this.getDataFolder(), relativePath);
        File parent = out.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        if (!out.exists()) {
            this.saveResource(relativePath, false);
        }
    }
}

