/*
 * Decompiled with CFR 0.152.
 */
package com.hro_basti.timberella.commands;

import com.hro_basti.timberella.TimberellaPlugin;
import java.util.HashMap;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class TimberellaCommand
implements CommandExecutor {
    private final TimberellaPlugin plugin;

    public TimberellaCommand(TimberellaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            sender.sendMessage(this.plugin.messages().component("usage_admin"));
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("timberella.admin")) {
                    sender.sendMessage(this.plugin.messages().component("no_permission"));
                    return true;
                }
                this.plugin.reloadAndMergeConfig();
                sender.sendMessage(this.plugin.messages().component("reloaded"));
                return true;
            }
            case "toggle": {
                if (args.length >= 2) {
                    if (!sender.hasPermission("timberella.admin")) {
                        sender.sendMessage(this.plugin.messages().component("no_permission"));
                        return true;
                    }
                    String targetName = args[1];
                    Player target = this.plugin.getServer().getPlayer(targetName);
                    if (target == null) {
                        sender.sendMessage(this.plugin.messages().component("player_not_found"));
                        return true;
                    }
                    boolean enabledNow = this.plugin.toggleEnabled(target.getUniqueId());
                    HashMap<String, String> rep = new HashMap<String, String>();
                    rep.put("player", target.getName());
                    sender.sendMessage(this.plugin.messages().format(enabledNow ? "toggled_other_on" : "toggled_other_off", rep));
                    target.sendMessage(this.plugin.messages().component(enabledNow ? "toggled_on" : "toggled_off"));
                    return true;
                }
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.plugin.messages().component("player_only"));
                    return true;
                }
                if (!sender.hasPermission("timberella.toggle")) {
                    sender.sendMessage(this.plugin.messages().component("no_permission"));
                    return true;
                }
                Player p = (Player)sender;
                boolean targetState = this.plugin.toggleEnabled(p.getUniqueId());
                sender.sendMessage(this.plugin.messages().component(targetState ? "toggled_on" : "toggled_off"));
                return true;
            }
            case "version": {
                HashMap<String, String> rep = new HashMap<String, String>();
                rep.put("current_ver", this.plugin.getPluginMeta().getVersion());
                sender.sendMessage(this.plugin.messages().format("version", rep));
                return true;
            }
        }
        sender.sendMessage(this.plugin.messages().component("usage_admin"));
        return true;
    }
}

