/*
 * Decompiled with CFR 0.152.
 */
package com.hro_basti.timberella.listeners;

import com.hro_basti.timberella.TimberellaPlugin;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;

public class TreeChopListener
implements Listener {
    private final TimberellaPlugin plugin;
    private static final Set<String> AXE_MATERIALS = new HashSet<String>(Arrays.asList("WOODEN_AXE", "STONE_AXE", "IRON_AXE", "GOLDEN_AXE", "DIAMOND_AXE", "NETHERITE_AXE"));
    private static final Set<Material> OVERWORLD_SOILS = EnumSet.of(Material.DIRT, new Material[]{Material.GRASS_BLOCK, Material.PODZOL, Material.COARSE_DIRT, Material.ROOTED_DIRT, Material.MYCELIUM, Material.MOSS_BLOCK, Material.FARMLAND, Material.MUD, Material.MUDDY_MANGROVE_ROOTS});
    private static final Set<Material> MANGROVE_SOILS = EnumSet.of(Material.MUD, new Material[]{Material.MUDDY_MANGROVE_ROOTS, Material.ROOTED_DIRT, Material.DIRT, Material.GRASS_BLOCK, Material.PODZOL});
    private static final Set<Material> FUNGUS_SOILS = EnumSet.of(Material.CRIMSON_NYLIUM, Material.WARPED_NYLIUM, Material.NETHERRACK);
    private final Set<Material> normalLogs = new HashSet<Material>();
    private final Set<Material> strippedLogs = new HashSet<Material>();
    private final Set<Material> woods = new HashSet<Material>();
    private final Set<Material> strippedWoods = new HashSet<Material>();
    private final Set<Material> fences = new HashSet<Material>();
    private final Set<Material> allowedAxes = new HashSet<Material>();
    private final Map<Material, Material> saplingMappings = new EnumMap<Material, Material>(Material.class);
    private final Set<Material> allowedSaplings = EnumSet.noneOf(Material.class);
    private final Map<Material, Set<Material>> leafMappings = new EnumMap<Material, Set<Material>>(Material.class);
    private boolean timberEnabled = true;
    private boolean leavesDecayEnabled = true;
    private long leavesDecayIntervalTicks = 2L;
    private int leavesDecayRadius = 5;
    private int leavesDecayBatchSize = 20;
    private int leavesDecayMaxDistance = 4;
    private int leavesDecayMaxDistanceSquared = 16;
    private boolean replantEnabled = false;
    private boolean includeDiagonals = true;
    private int maxBlocks = 1024;
    private int sneakMode = 0;
    private int minRemainingDurability = 10;
    private boolean durabilityModeAll = false;
    private double durabilityMultiplier = 0.5;
    private long breakIntervalTicks = 2L;

    public TreeChopListener(TimberellaPlugin plugin) {
        this.plugin = plugin;
        this.loadCategoryMaps();
    }

    public void refresh() {
        this.loadCategoryMaps();
    }

    private void loadCategoryMaps() {
        this.normalLogs.clear();
        this.strippedLogs.clear();
        this.woods.clear();
        this.strippedWoods.clear();
        this.fences.clear();
        this.allowedAxes.clear();
        this.saplingMappings.clear();
        this.initializeSaplingMappings();
        this.allowedSaplings.clear();
        List saplingNames = this.plugin.getConfig().getStringList("replant.saplings");
        for (String name : saplingNames) {
            Material m = Material.matchMaterial((String)name.toUpperCase(Locale.ROOT));
            if (m != null) {
                this.allowedSaplings.add(m);
                continue;
            }
            this.plugin.getLogger().fine("Ignoring unknown sapling in replant.saplings: " + name);
        }
        this.loadMap("categories.logs", this.normalLogs);
        this.loadMap("categories.stripped_logs", this.strippedLogs);
        this.loadMap("categories.woods", this.woods);
        this.loadMap("categories.stripped_woods", this.strippedWoods);
        this.loadMap("categories.fences", this.fences);
        this.loadLeafMappings();
        this.timberEnabled = this.plugin.getConfig().getBoolean("enable_timber", true);
        this.leavesDecayEnabled = this.plugin.getConfig().getBoolean("enable_leaves_decay", true);
        this.leavesDecayRadius = Math.max(0, this.plugin.getConfig().getInt("leaves_decay.decay_radius", 5));
        this.leavesDecayIntervalTicks = Math.max(1L, this.plugin.getConfig().getLong("leaves_decay.batch_interval_ticks", 2L));
        this.leavesDecayBatchSize = Math.max(1, this.plugin.getConfig().getInt("leaves_decay.batch_size", 20));
        int configuredMaxDistance = this.plugin.getConfig().getInt("leaves_decay.max_distance", 4);
        this.leavesDecayMaxDistance = Math.max(1, configuredMaxDistance);
        this.leavesDecayMaxDistanceSquared = this.leavesDecayMaxDistance * this.leavesDecayMaxDistance;
        boolean replantGlobal = this.plugin.getConfig().getBoolean("enable_replant", true);
        boolean replantSection = this.plugin.getConfig().getBoolean("replant.enabled", true);
        this.replantEnabled = replantGlobal && replantSection;
        this.maxBlocks = Math.max(1, this.plugin.getConfig().getInt("max_blocks", 1024));
        this.sneakMode = this.plugin.getConfig().getInt("sneak_mode", 0);
        this.includeDiagonals = this.plugin.getConfig().getBoolean("include_diagonals", this.plugin.getConfig().getInt("adjacency_faces", 26) > 6);
        List axes = this.plugin.getConfig().getStringList("tools.allowed_axes");
        for (String name : axes) {
            Material m = Material.matchMaterial((String)name.toUpperCase(Locale.ROOT));
            if (m == null) continue;
            this.allowedAxes.add(m);
        }
        this.minRemainingDurability = Math.max(0, this.plugin.getConfig().getInt("tools.min_remaining_durability", 10));
        String mode = this.plugin.getConfig().getString("tools.durability_mode", "first");
        this.durabilityModeAll = mode != null && mode.equalsIgnoreCase("all");
        this.durabilityMultiplier = this.plugin.getConfig().getDouble("tools.durability_multiplier", 0.5);
        this.breakIntervalTicks = Math.max(1L, this.plugin.getConfig().getLong("break_interval_ticks", 2L));
    }

    private void loadMap(String path, Set<Material> target) {
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection(path);
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            boolean enabled = section.getBoolean(key, true);
            if (!enabled) continue;
            Material m = Material.matchMaterial((String)key.toUpperCase(Locale.ROOT));
            if (m != null) {
                target.add(m);
                continue;
            }
            this.plugin.getLogger().fine("Ignoring unknown material in section " + path + ": " + key);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block start = event.getBlock();
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (!this.plugin.isEnabledFor(player.getUniqueId())) {
            return;
        }
        if (!this.isTreeMaterial(start.getType())) {
            return;
        }
        if (!this.isAxe(tool)) {
            return;
        }
        if (!this.hasMinDurability(tool)) {
            return;
        }
        if (!this.sneakModeAllows(player.isSneaking())) {
            return;
        }
        boolean hasTimberPermission = player.hasPermission("timberella.use");
        if (hasTimberPermission && this.timberEnabled) {
            List<Block> sequence = this.collectConnectedLogs(start, this.maxBlocks, this.includeDiagonals);
            if (sequence.isEmpty()) {
                sequence = Collections.singletonList(start);
            }
            try {
                Location loc = start.getLocation().add(0.5, 0.5, 0.5);
                start.getWorld().spawnParticle(Particle.SWEEP_ATTACK, loc, 1, 0.0, 0.0, 0.0, 0.0);
            }
            catch (Throwable loc) {
                // empty catch block
            }
            if (sequence.size() <= 1) {
                this.applyDurabilityCost(player, tool, sequence.size());
                this.handlePostActions(player, tool, sequence, false);
                return;
            }
            final ArrayList<Block> allLogs = new ArrayList<Block>(sequence);
            final ArrayList<Block> toBreak = new ArrayList<Block>(sequence.subList(1, sequence.size()));
            final ItemStack usedTool = tool;
            final Player p = player;
            long interval = this.breakIntervalTicks;
            new BukkitRunnable(){
                int idx = 0;

                public void run() {
                    Block b;
                    if (this.idx >= toBreak.size()) {
                        TreeChopListener.this.applyDurabilityCost(p, usedTool, allLogs.size());
                        TreeChopListener.this.handlePostActions(p, usedTool, allLogs, true);
                        this.cancel();
                        return;
                    }
                    if (TreeChopListener.this.isTreeMaterial((b = (Block)toBreak.get(this.idx++)).getType())) {
                        b.breakNaturally(usedTool, true);
                    }
                }
            }.runTaskTimer((Plugin)this.plugin, interval, interval);
            return;
        }
        ArrayList<Block> single = new ArrayList<Block>(Collections.singletonList(start));
        this.handlePostActions(player, tool, single, false);
    }

    private boolean sneakModeAllows(boolean sneaking) {
        switch (this.sneakMode) {
            case 0: {
                return sneaking;
            }
            case 1: {
                return !sneaking;
            }
            case 2: {
                return true;
            }
        }
        return sneaking;
    }

    private boolean isAxe(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Material type = stack.getType();
        if (!this.allowedAxes.isEmpty()) {
            return this.allowedAxes.contains(type);
        }
        return AXE_MATERIALS.contains(type.name());
    }

    private boolean hasMinDurability(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Material type = stack.getType();
        short max = type.getMaxDurability();
        if (max <= 0) {
            return true;
        }
        ItemMeta meta = stack.getItemMeta();
        if (!(meta instanceof Damageable)) {
            return true;
        }
        int damage = ((Damageable)meta).getDamage();
        int remaining = max - damage;
        return remaining >= this.minRemainingDurability;
    }

    private boolean isTreeMaterial(Material m) {
        if (m == null) {
            return false;
        }
        if (this.normalLogs.contains(m)) {
            return true;
        }
        if (this.strippedLogs.contains(m)) {
            return true;
        }
        if (this.woods.contains(m)) {
            return true;
        }
        if (this.strippedWoods.contains(m)) {
            return true;
        }
        return this.fences.contains(m);
    }

    private List<Block> collectConnectedLogs(Block start, int maxBlocks, boolean includeDiagonals) {
        ArrayDeque<Block> queue = new ArrayDeque<Block>();
        HashSet<Long> visited = new HashSet<Long>();
        ArrayList<Block> result = new ArrayList<Block>();
        queue.add(start);
        visited.add(this.key(start));
        while (!queue.isEmpty() && result.size() < maxBlocks) {
            Block b = (Block)queue.poll();
            if (!this.isTreeMaterial(b.getType())) continue;
            result.add(b);
            if (!includeDiagonals) {
                int[][] dirs;
                for (int[] d : dirs = new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}, {0, 0, 1}, {0, 0, -1}}) {
                    long k;
                    Block n = b.getRelative(d[0], d[1], d[2]);
                    if (!this.isTreeMaterial(n.getType()) || !visited.add(k = this.key(n))) continue;
                    queue.add(n);
                }
                continue;
            }
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        long k;
                        Block n;
                        if (dx == 0 && dy == 0 && dz == 0 || !this.isTreeMaterial((n = b.getRelative(dx, dy, dz)).getType()) || !visited.add(k = this.key(n))) continue;
                        queue.add(n);
                    }
                }
            }
        }
        return result;
    }

    private void handlePostActions(Player player, ItemStack tool, List<Block> logs, boolean performedTimber) {
        if (logs == null || logs.isEmpty()) {
            return;
        }
        if (this.leavesDecayEnabled) {
            Block origin = logs.get(0);
            this.scheduleLeavesDecay(player, logs, origin);
        }
        if (performedTimber && this.replantEnabled) {
            this.tryReplant(logs);
        }
    }

    private void scheduleLeavesDecay(Player player, List<Block> logs, Block origin) {
        if (!this.leavesDecayEnabled) {
            return;
        }
        if (logs.isEmpty()) {
            return;
        }
        if (this.leavesDecayRadius <= 0) {
            return;
        }
        final Set<Material> allowedLeaves = this.computeAllowedLeaves(logs, origin);
        final ArrayDeque<LeafEntry> queue = new ArrayDeque<LeafEntry>();
        final HashSet<Long> visited = new HashSet<Long>();
        final int maxDepth = this.leavesDecayRadius;
        for (Block log : logs) {
            this.seedLeafNeighbors(log, queue, visited, maxDepth, allowedLeaves, log);
        }
        if (queue.isEmpty()) {
            return;
        }
        final int batchSize = this.leavesDecayBatchSize;
        long interval = this.leavesDecayIntervalTicks;
        final Player sourcePlayer = player;
        final PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        new BukkitRunnable(){

            public void run() {
                LeafEntry entry;
                int processed = 0;
                while (!queue.isEmpty() && processed < batchSize && (entry = (LeafEntry)queue.poll()) != null) {
                    Block b = entry.block();
                    int depth = entry.depth();
                    Block originBlock = entry.origin();
                    if (!TreeChopListener.this.isLeafMaterial(b.getType()) || !TreeChopListener.this.isAllowedLeaf(b.getType(), allowedLeaves)) continue;
                    boolean allowDrops = true;
                    if (sourcePlayer != null) {
                        BlockBreakEvent leafEvent = new BlockBreakEvent(b, sourcePlayer);
                        pluginManager.callEvent((Event)leafEvent);
                        if (leafEvent.isCancelled()) continue;
                        allowDrops = leafEvent.isDropItems();
                    }
                    if (allowDrops) {
                        b.breakNaturally();
                    } else {
                        b.setType(Material.AIR);
                    }
                    int nextDepth = depth + 1;
                    if (nextDepth <= maxDepth) {
                        if (TreeChopListener.this.includeDiagonals) {
                            for (int dx = -1; dx <= 1; ++dx) {
                                for (int dy = -1; dy <= 1; ++dy) {
                                    for (int dz = -1; dz <= 1; ++dz) {
                                        if (dx == 0 && dy == 0 && dz == 0) continue;
                                        Block n = b.getRelative(dx, dy, dz);
                                        TreeChopListener.this.enqueueLeaf(n, nextDepth, maxDepth, queue, visited, allowedLeaves, originBlock);
                                    }
                                }
                            }
                        } else {
                            int[][] dirs;
                            for (int[] d : dirs = new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}, {0, 0, 1}, {0, 0, -1}}) {
                                Block n = b.getRelative(d[0], d[1], d[2]);
                                TreeChopListener.this.enqueueLeaf(n, nextDepth, maxDepth, queue, visited, allowedLeaves, originBlock);
                            }
                        }
                    }
                    ++processed;
                }
                if (queue.isEmpty()) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, interval);
    }

    private void seedLeafNeighbors(Block log, Deque<LeafEntry> queue, Set<Long> visited, int maxDepth, Set<Material> allowedLeaves, Block origin) {
        if (log == null || maxDepth <= 0) {
            return;
        }
        if (this.includeDiagonals) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        if (dx == 0 && dy == 0 && dz == 0) continue;
                        Block candidate = log.getRelative(dx, dy, dz);
                        this.enqueueLeaf(candidate, 0, maxDepth, queue, visited, allowedLeaves, origin);
                    }
                }
            }
        } else {
            int[][] dirs;
            for (int[] d : dirs = new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}, {0, 0, 1}, {0, 0, -1}}) {
                Block candidate = log.getRelative(d[0], d[1], d[2]);
                this.enqueueLeaf(candidate, 0, maxDepth, queue, visited, allowedLeaves, origin);
            }
        }
    }

    private void enqueueLeaf(Block block, int depth, int maxDepth, Deque<LeafEntry> queue, Set<Long> visited, Set<Material> allowedLeaves, Block origin) {
        if (block == null) {
            return;
        }
        if (depth > maxDepth) {
            return;
        }
        if (!this.isLeafMaterial(block.getType())) {
            return;
        }
        if (!this.isAllowedLeaf(block.getType(), allowedLeaves)) {
            return;
        }
        if (!this.isWithinLeafDistance(origin, block)) {
            return;
        }
        long key = this.key(block);
        if (visited.add(key)) {
            queue.add(new LeafEntry(block, depth, origin));
        }
    }

    private boolean isAllowedLeaf(Material material, Set<Material> allowedLeaves) {
        return allowedLeaves == null || allowedLeaves.contains(material);
    }

    private boolean isLeafMaterial(Material material) {
        if (material == null) {
            return false;
        }
        String name = material.name();
        return name.endsWith("_LEAVES") || name.endsWith("_LEAF");
    }

    private boolean isWithinLeafDistance(Block origin, Block candidate) {
        int dz;
        int dy;
        if (origin == null || candidate == null) {
            return true;
        }
        int dx = origin.getX() - candidate.getX();
        return dx * dx + (dy = origin.getY() - candidate.getY()) * dy + (dz = origin.getZ() - candidate.getZ()) * dz <= this.leavesDecayMaxDistanceSquared;
    }

    private void tryReplant(List<Block> logs) {
        if (!this.replantEnabled) {
            return;
        }
        if (logs == null || logs.isEmpty()) {
            return;
        }
        Block best = null;
        Material sapling = null;
        for (Block log : logs) {
            Block soil;
            Material mapped = this.saplingMappings.get(log.getType());
            if (mapped == null || !this.allowedSaplings.isEmpty() && !this.allowedSaplings.contains(mapped) || !this.isSuitableSoil((soil = log.getRelative(0, -1, 0)).getType(), mapped) || best != null && log.getY() >= best.getY()) continue;
            best = log;
            sapling = mapped;
        }
        if (best == null || sapling == null) {
            return;
        }
        Location targetLoc = best.getLocation();
        Material finalSapling = sapling;
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            BlockData data;
            boolean targetIsWater;
            Block target = targetLoc.getBlock();
            Block soil = target.getRelative(0, -1, 0);
            if (!this.isSuitableSoil(soil.getType(), finalSapling)) {
                return;
            }
            Material current = target.getType();
            boolean bl = targetIsWater = current == Material.WATER;
            if (!(current.isAir() || targetIsWater || target.isPassable())) {
                return;
            }
            target.setType(finalSapling);
            if (finalSapling == Material.MANGROVE_PROPAGULE && (data = target.getBlockData()) instanceof Waterlogged) {
                Waterlogged waterlogged = (Waterlogged)data;
                waterlogged.setWaterlogged(targetIsWater);
                target.setBlockData((BlockData)waterlogged);
            }
        }, 2L);
    }

    private boolean isSuitableSoil(Material soil, Material sapling) {
        if (soil == null || sapling == null) {
            return false;
        }
        if (sapling == Material.CRIMSON_FUNGUS || sapling == Material.WARPED_FUNGUS) {
            return FUNGUS_SOILS.contains(soil);
        }
        if (sapling == Material.MANGROVE_PROPAGULE) {
            return MANGROVE_SOILS.contains(soil);
        }
        return OVERWORLD_SOILS.contains(soil);
    }

    private void initializeSaplingMappings() {
        this.mapSapling(Material.OAK_LOG, Material.OAK_SAPLING);
        this.mapSapling(Material.STRIPPED_OAK_LOG, Material.OAK_SAPLING);
        this.mapSapling(Material.OAK_WOOD, Material.OAK_SAPLING);
        this.mapSapling(Material.STRIPPED_OAK_WOOD, Material.OAK_SAPLING);
        this.mapSapling(Material.SPRUCE_LOG, Material.SPRUCE_SAPLING);
        this.mapSapling(Material.STRIPPED_SPRUCE_LOG, Material.SPRUCE_SAPLING);
        this.mapSapling(Material.SPRUCE_WOOD, Material.SPRUCE_SAPLING);
        this.mapSapling(Material.STRIPPED_SPRUCE_WOOD, Material.SPRUCE_SAPLING);
        this.mapSapling(Material.BIRCH_LOG, Material.BIRCH_SAPLING);
        this.mapSapling(Material.STRIPPED_BIRCH_LOG, Material.BIRCH_SAPLING);
        this.mapSapling(Material.BIRCH_WOOD, Material.BIRCH_SAPLING);
        this.mapSapling(Material.STRIPPED_BIRCH_WOOD, Material.BIRCH_SAPLING);
        this.mapSapling(Material.JUNGLE_LOG, Material.JUNGLE_SAPLING);
        this.mapSapling(Material.STRIPPED_JUNGLE_LOG, Material.JUNGLE_SAPLING);
        this.mapSapling(Material.JUNGLE_WOOD, Material.JUNGLE_SAPLING);
        this.mapSapling(Material.STRIPPED_JUNGLE_WOOD, Material.JUNGLE_SAPLING);
        this.mapSapling(Material.ACACIA_LOG, Material.ACACIA_SAPLING);
        this.mapSapling(Material.STRIPPED_ACACIA_LOG, Material.ACACIA_SAPLING);
        this.mapSapling(Material.ACACIA_WOOD, Material.ACACIA_SAPLING);
        this.mapSapling(Material.STRIPPED_ACACIA_WOOD, Material.ACACIA_SAPLING);
        this.mapSapling(Material.DARK_OAK_LOG, Material.DARK_OAK_SAPLING);
        this.mapSapling(Material.STRIPPED_DARK_OAK_LOG, Material.DARK_OAK_SAPLING);
        this.mapSapling(Material.DARK_OAK_WOOD, Material.DARK_OAK_SAPLING);
        this.mapSapling(Material.STRIPPED_DARK_OAK_WOOD, Material.DARK_OAK_SAPLING);
        this.mapSapling(Material.CHERRY_LOG, Material.CHERRY_SAPLING);
        this.mapSapling(Material.STRIPPED_CHERRY_LOG, Material.CHERRY_SAPLING);
        this.mapSapling(Material.CHERRY_WOOD, Material.CHERRY_SAPLING);
        this.mapSapling(Material.STRIPPED_CHERRY_WOOD, Material.CHERRY_SAPLING);
        this.mapSapling(Material.MANGROVE_LOG, Material.MANGROVE_PROPAGULE);
        this.mapSapling(Material.STRIPPED_MANGROVE_LOG, Material.MANGROVE_PROPAGULE);
        this.mapSapling(Material.MANGROVE_WOOD, Material.MANGROVE_PROPAGULE);
        this.mapSapling(Material.STRIPPED_MANGROVE_WOOD, Material.MANGROVE_PROPAGULE);
        this.mapSapling(Material.CRIMSON_STEM, Material.CRIMSON_FUNGUS);
        this.mapSapling(Material.STRIPPED_CRIMSON_STEM, Material.CRIMSON_FUNGUS);
        this.mapSapling(Material.CRIMSON_HYPHAE, Material.CRIMSON_FUNGUS);
        this.mapSapling(Material.STRIPPED_CRIMSON_HYPHAE, Material.CRIMSON_FUNGUS);
        this.mapSapling(Material.WARPED_STEM, Material.WARPED_FUNGUS);
        this.mapSapling(Material.STRIPPED_WARPED_STEM, Material.WARPED_FUNGUS);
        this.mapSapling(Material.WARPED_HYPHAE, Material.WARPED_FUNGUS);
        this.mapSapling(Material.STRIPPED_WARPED_HYPHAE, Material.WARPED_FUNGUS);
    }

    private void mapSapling(Material source, Material sapling) {
        if (source == null || sapling == null) {
            return;
        }
        this.saplingMappings.put(source, sapling);
    }

    private void loadLeafMappings() {
        YamlConfiguration yaml;
        ConfigurationSection section;
        this.leafMappings.clear();
        File file = new File(this.plugin.getDataFolder(), "leaf_mappings.yml");
        if (!file.exists()) {
            this.plugin.saveResource("leaf_mappings.yml", false);
        }
        if ((section = (yaml = YamlConfiguration.loadConfiguration((File)file)).getConfigurationSection("log_to_leaves")) == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            Material log = Material.matchMaterial((String)key.toUpperCase(Locale.ROOT));
            if (log == null) {
                this.plugin.getLogger().fine("Unknown log material in leaf_mappings.yml: " + key);
                continue;
            }
            List leaves = section.getStringList(key);
            if (leaves.isEmpty()) continue;
            Set mapped = this.leafMappings.computeIfAbsent(log, m -> EnumSet.noneOf(Material.class));
            for (String leafName : leaves) {
                Material leaf = Material.matchMaterial((String)leafName.toUpperCase(Locale.ROOT));
                if (leaf != null) {
                    mapped.add(leaf);
                    continue;
                }
                this.plugin.getLogger().fine("Unknown leaf material in leaf_mappings.yml: " + leafName);
            }
        }
    }

    private Set<Material> computeAllowedLeaves(List<Block> logs, Block origin) {
        Set<Material> originLeaves;
        if (logs == null || logs.isEmpty()) {
            return null;
        }
        Material originType = origin != null ? origin.getType() : null;
        Set<Material> set = originLeaves = originType != null ? this.leafMappings.get(originType) : null;
        if (originLeaves == null || originLeaves.isEmpty()) {
            return null;
        }
        EnumSet<Material> allowed = EnumSet.copyOf(originLeaves);
        for (Block log : logs) {
            Set<Material> mapped;
            if (log == null || (mapped = this.leafMappings.get(log.getType())) == null || !mapped.equals(originLeaves)) continue;
            allowed.addAll(mapped);
        }
        return allowed;
    }

    private void applyDurabilityCost(Player player, ItemStack tool, int brokenBlocks) {
        int vanillaApplied;
        if (!this.durabilityModeAll) {
            return;
        }
        if (tool == null) {
            return;
        }
        Material type = tool.getType();
        short max = type.getMaxDurability();
        if (max <= 0) {
            return;
        }
        ItemMeta meta = tool.getItemMeta();
        if (!(meta instanceof Damageable)) {
            return;
        }
        Damageable dmg = (Damageable)meta;
        int currentDamage = dmg.getDamage();
        int targetTotal = (int)Math.round((double)Math.max(0, brokenBlocks) * Math.max(0.0, this.durabilityMultiplier));
        int extra = Math.max(0, targetTotal - (vanillaApplied = brokenBlocks > 0 ? 1 : 0));
        if (extra <= 0) {
            return;
        }
        int remaining = max - currentDamage;
        int cappedExtra = Math.max(0, Math.min(extra, remaining - 1));
        if (cappedExtra <= 0) {
            return;
        }
        dmg.setDamage(currentDamage + cappedExtra);
        tool.setItemMeta((ItemMeta)dmg);
        player.getInventory().setItemInMainHand(tool);
    }

    private long key(Block b) {
        long x = b.getX();
        long y = b.getY();
        long z = b.getZ();
        long worldHash = (b.getWorld().getUID().getMostSignificantBits() ^ b.getWorld().getUID().getLeastSignificantBits()) & 0xFFFFL;
        long coordPack = (x & 0x3FFFFFFL) << 38 | (z & 0x3FFFFFFL) << 12 | y & 0xFFFL;
        return worldHash << 48 ^ coordPack;
    }

    private record LeafEntry(Block block, int depth, Block origin) {
    }
}

