/*
 * Decompiled with CFR 0.152.
 */
package com.hro_basti.timberella.update;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hro_basti.timberella.TimberellaPlugin;
import com.hro_basti.timberella.util.VersionComparator;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;

public class UpdateChecker {
    private final TimberellaPlugin plugin;
    private final int providerMode;
    private final boolean includePrereleases;
    private static final String MODRINTH_SLUG = "timberella";
    private static final String HANGAR_NAMESPACE = "hro_basti/timberella";

    public UpdateChecker(TimberellaPlugin plugin, int providerMode, boolean includePrereleases) {
        this.plugin = plugin;
        this.providerMode = providerMode;
        this.includePrereleases = includePrereleases;
    }

    public CompletableFuture<UpdateInfo> checkAsync() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String current = this.plugin.getPluginMeta().getVersion();
                String latest = null;
                if (this.providerMode == 0 || this.providerMode == 1) {
                    latest = this.latestFromModrinth();
                }
                if (!(latest != null && !latest.isEmpty() || this.providerMode != 0 && this.providerMode != 2)) {
                    latest = this.latestFromHangar();
                }
                if (latest != null && !latest.isEmpty() && VersionComparator.isGreater(latest, current)) {
                    return new UpdateInfo(latest, current);
                }
            }
            catch (Throwable t) {
                this.plugin.getLogger().fine("Update check failed: " + t.getMessage());
            }
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String latestFromModrinth() {
        try {
            URL url = URI.create("https://api.modrinth.com/v2/project/timberella/version").toURL();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(4000);
            conn.setReadTimeout(4000);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", "Timberella-UpdateChecker");
            if (conn.getResponseCode() != 200) {
                return null;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                JsonObject version;
                block12: {
                    String line;
                    StringBuilder sb = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    JsonElement el = JsonParser.parseString(sb.toString());
                    if (!el.isJsonArray()) return null;
                    JsonArray arr = el.getAsJsonArray();
                    Iterator<JsonElement> iterator = arr.iterator();
                    while (iterator.hasNext()) {
                        JsonElement entry = iterator.next();
                        if (!entry.isJsonObject()) continue;
                        version = entry.getAsJsonObject();
                        if (!this.includePrereleases && this.isModrinthPrerelease(version) || !version.has("version_number")) {
                            continue;
                        }
                        break block12;
                    }
                    return null;
                }
                String string = version.get("version_number").getAsString();
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String latestFromHangar() {
        try {
            URL url = URI.create("https://hangar.papermc.io/api/v1/projects/hro_basti/timberella/versions").toURL();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(4000);
            conn.setReadTimeout(4000);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", "Timberella-UpdateChecker");
            if (conn.getResponseCode() != 200) {
                return null;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                JsonObject version;
                block17: {
                    String line;
                    StringBuilder sb = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    JsonElement el = JsonParser.parseString(sb.toString());
                    if (el.isJsonArray()) {
                        JsonObject version2;
                        block16: {
                            JsonArray arr = el.getAsJsonArray();
                            Iterator<JsonElement> iterator = arr.iterator();
                            while (iterator.hasNext()) {
                                JsonElement entry = iterator.next();
                                if (!entry.isJsonObject()) continue;
                                version2 = entry.getAsJsonObject();
                                if (!this.includePrereleases && this.isHangarPrerelease(version2) || !version2.has("name")) {
                                    continue;
                                }
                                break block16;
                            }
                            return null;
                        }
                        String string = version2.get("name").getAsString();
                        return string;
                    }
                    if (!el.isJsonObject()) return null;
                    JsonObject obj = el.getAsJsonObject();
                    if (!obj.has("result")) return null;
                    JsonElement res = obj.get("result");
                    if (!res.isJsonArray()) return null;
                    JsonArray arr = res.getAsJsonArray();
                    Iterator<JsonElement> iterator = arr.iterator();
                    while (iterator.hasNext()) {
                        JsonElement entry = iterator.next();
                        if (!entry.isJsonObject()) continue;
                        version = entry.getAsJsonObject();
                        if (!this.includePrereleases && this.isHangarPrerelease(version) || !version.has("name")) {
                            continue;
                        }
                        break block17;
                    }
                    return null;
                }
                String string = version.get("name").getAsString();
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean isModrinthPrerelease(JsonObject version) {
        if (version.has("prerelease") && version.get("prerelease").isJsonPrimitive()) {
            try {
                if (version.get("prerelease").getAsBoolean()) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (version.has("version_type") && version.get("version_type").isJsonPrimitive()) {
            String type = version.get("version_type").getAsString();
            return !"release".equalsIgnoreCase(type);
        }
        return false;
    }

    private boolean isHangarPrerelease(JsonObject version) {
        if (version.has("channel")) {
            JsonElement channelEl = version.get("channel");
            String channelName = null;
            if (channelEl.isJsonObject()) {
                JsonObject channelObj = channelEl.getAsJsonObject();
                if (channelObj.has("name")) {
                    channelName = channelObj.get("name").getAsString();
                }
            } else if (channelEl.isJsonPrimitive()) {
                channelName = channelEl.getAsString();
            }
            if (channelName != null) {
                return !"release".equalsIgnoreCase(channelName);
            }
        }
        if (version.has("visibility") && version.get("visibility").isJsonPrimitive()) {
            return false;
        }
        return false;
    }

    public record UpdateInfo(String latestVersion, String currentVersion) {
    }
}

