/*
 * Decompiled with CFR 0.152.
 */
package com.hro_basti.timberella.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageService {
    private static final MiniMessage MINI = MiniMessage.miniMessage();
    private static final String DEFAULT_LOCALE = "en_US";
    private static final String[] BUNDLED_LOCALES = new String[]{"en_US", "de_DE", "ar_SA", "es_ES", "fr_FR", "it_IT", "ja_JP", "ko_KR", "nl_NL", "pl_PL", "pt_PT", "tr_TR", "uk_UA", "zh_CN"};
    private final JavaPlugin plugin;
    private final Map<String, String> messages = new HashMap<String, String>();
    private String prefixRaw = "<gold>[Timberella]</gold>";

    public MessageService(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void load(String locale) {
        this.messages.clear();
        this.ensureBundledLocales();
        File langFile = new File(this.plugin.getDataFolder(), "lang" + File.separator + locale + ".yml");
        if (!langFile.exists()) {
            locale = DEFAULT_LOCALE;
            langFile = new File(this.plugin.getDataFolder(), "lang" + File.separator + "en_US.yml");
        }
        this.mergeMissingLangKeys(langFile, locale);
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)langFile);
        for (String key : cfg.getKeys(false)) {
            this.messages.put(key, cfg.getString(key, key));
        }
        this.prefixRaw = this.messages.getOrDefault("prefix", "<gold>[Timberella]</gold>");
    }

    private void ensureBundledLocales() {
        for (String locale : BUNDLED_LOCALES) {
            this.saveLangIfAbsent(locale + ".yml");
        }
    }

    private void saveLangIfAbsent(String name) {
        File out = new File(this.plugin.getDataFolder(), "lang" + File.separator + name);
        if (!out.getParentFile().exists()) {
            out.getParentFile().mkdirs();
        }
        if (!out.exists()) {
            this.plugin.saveResource("lang/" + name, false);
        }
    }

    private void mergeMissingLangKeys(File langFile, String locale) {
        YamlConfiguration target = YamlConfiguration.loadConfiguration((File)langFile);
        YamlConfiguration defaults = this.loadDefaultLang(locale);
        if (defaults == null) {
            return;
        }
        boolean changed = this.mergeSections((ConfigurationSection)target, (ConfigurationSection)defaults);
        if (changed) {
            try {
                target.save(langFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().fine("Failed to merge lang keys for " + langFile.getName() + ": " + e.getMessage());
            }
        }
    }

    private YamlConfiguration loadDefaultLang(String locale) {
        YamlConfiguration defaults = this.loadLocaleResource(locale);
        if (defaults == null && !DEFAULT_LOCALE.equals(locale)) {
            defaults = this.loadLocaleResource(DEFAULT_LOCALE);
        }
        return defaults;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private YamlConfiguration loadLocaleResource(String locale) {
        try (InputStream in = this.plugin.getResource("lang/" + locale + ".yml");){
            if (in == null) {
                YamlConfiguration yamlConfiguration2 = null;
                return yamlConfiguration2;
            }
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
            return yamlConfiguration;
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean mergeSections(ConfigurationSection target, ConfigurationSection defaults) {
        boolean changed = false;
        for (String key : defaults.getKeys(false)) {
            Object defVal = defaults.get(key);
            if (defVal instanceof ConfigurationSection) {
                ConfigurationSection targetSection;
                ConfigurationSection defSection = (ConfigurationSection)defVal;
                if (target.isConfigurationSection(key)) {
                    targetSection = target.getConfigurationSection(key);
                } else {
                    if (target.contains(key)) continue;
                    targetSection = target.createSection(key);
                }
                changed |= this.mergeSections(targetSection, defSection);
                continue;
            }
            if (target.contains(key)) continue;
            target.set(key, defVal);
            changed = true;
        }
        return changed;
    }

    public Component component(String key) {
        String raw = this.messages.getOrDefault(key, key);
        TagResolver resolver = TagResolver.resolver(Placeholder.parsed("prefix", this.prefixRaw));
        return MINI.deserialize(raw, resolver);
    }

    public Component format(String key, Map<String, String> replacements) {
        String raw = this.messages.getOrDefault(key, key);
        TagResolver.Builder builder = TagResolver.builder();
        builder.resolver(Placeholder.parsed("prefix", this.prefixRaw));
        for (Map.Entry<String, String> e : replacements.entrySet()) {
            builder.resolver(Placeholder.unparsed(e.getKey(), e.getValue()));
        }
        return MINI.deserialize(raw, builder.build());
    }
}

