/*
 * Decompiled with CFR 0.152.
 */
package com.hro_basti.timberella;

import com.hro_basti.timberella.commands.TimberellaCommand;
import com.hro_basti.timberella.commands.TimberellaTabCompleter;
import com.hro_basti.timberella.listeners.TreeChopListener;
import com.hro_basti.timberella.listeners.UpdateNotifyListener;
import com.hro_basti.timberella.metrics.Metrics;
import com.hro_basti.timberella.update.UpdateChecker;
import com.hro_basti.timberella.util.MessageService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class TimberellaPlugin
extends JavaPlugin {
    private static final int BSTATS_PLUGIN_ID = 28062;
    private static final String REQUIRED_SERVER_BRAND = "Paper";
    private static final Set<String> SUPPORTED_MC_VERSIONS = Collections.unmodifiableSet(new LinkedHashSet<String>(List.of("1.21", "1.21.1", "1.21.2", "1.21.3", "1.21.4", "1.21.5", "1.21.6", "1.21.7", "1.21.8", "1.21.9", "1.21.10")));
    private static final MiniMessage MINI = MiniMessage.miniMessage();
    private static final String[] STARTUP_BANNER_LINES = new String[]{"##########################################", " _____ _       _                 _ _      ", "|_   _(_)_ __ | |__  ___ _ _ ___| | |__ _ ", "  | | | | '  \\| '_ \\/ -_) '_/ -_) | / _` |", "  |_| |_|_|_|_|_.__/\\___|_| \\___|_|_\\__,_|", "                                          ", "##########################################"};
    private MessageService messages;
    private UpdateChecker updateChecker;
    private TreeChopListener treeChopListener;
    private Metrics metrics;
    private volatile long lastConfigModified = 0L;
    private volatile long lastConfigSize = -1L;
    private volatile int lastConfigHash = 0;
    private volatile boolean configWatchEnabledFlag = true;
    private BukkitTask configWatcherTask;
    private BukkitTask periodicUpdateTask;
    private volatile UpdateChecker.UpdateInfo pendingUpdateInfo;
    private volatile boolean announceNextUpdateSummary = true;
    private final Set<UUID> disabledPlayers = Collections.synchronizedSet(new HashSet());
    private Map<String, String> lastConfigSnapshot = new LinkedHashMap<String, String>();
    private Map<String, String> lastLeafSnapshot = new LinkedHashMap<String, String>();
    private Map<String, Integer> lastLocaleHashes = new LinkedHashMap<String, Integer>();
    private boolean changeTrackingInitialized = false;

    public void onEnable() {
        this.logStartupBanner();
        this.saveDefaultConfig();
        this.ensureResourceExists("leaf_mappings.yml");
        this.messages = new MessageService(this);
        String lang = this.getConfig().getString("language", "en_US");
        this.messages.load(lang);
        this.syncAllYamlDefaults(lang);
        PluginCommand timberellaCommand = this.getCommand("timberella");
        if (timberellaCommand == null) {
            this.getLogger().severe("Command 'timberella' is missing from plugin.yml. Disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        TimberellaCommand executor = new TimberellaCommand(this);
        timberellaCommand.setExecutor((CommandExecutor)executor);
        timberellaCommand.setTabCompleter((TabCompleter)new TimberellaTabCompleter(this));
        this.updateConfigModifiedTimestamp();
        this.refreshConfigWatchFlag();
        PluginManager pm = Bukkit.getPluginManager();
        this.treeChopListener = new TreeChopListener(this);
        pm.registerEvents((Listener)this.treeChopListener, (Plugin)this);
        pm.registerEvents((Listener)new UpdateNotifyListener(this), (Plugin)this);
        this.announceNextUpdateSummary = true;
        this.configureUpdateChecker();
        this.startConfigWatcher();
        this.loadToggles();
        this.setupMetrics();
        this.warnIfUnsupportedEnvironment();
        this.logModuleStates();
        this.updateChangeTrackingSnapshots(this.flattenConfiguration((ConfigurationSection)this.getConfig()), this.loadLeafMappingsSnapshot(), this.computeLocaleFingerprints());
        this.getLogger().info("Timberella enabled.");
    }

    public void onDisable() {
        this.shutdownMetrics();
        this.cancelScheduledUpdateChecks();
        this.stopConfigWatcher();
        this.getLogger().info("Timberella disabled.");
    }

    public MessageService messages() {
        return this.messages;
    }

    public void reloadAndMergeConfig() {
        LinkedHashMap<String, String> previousConfigSnapshot = new LinkedHashMap<String, String>(this.lastConfigSnapshot);
        LinkedHashMap<String, String> previousLeafSnapshot = new LinkedHashMap<String, String>(this.lastLeafSnapshot);
        LinkedHashMap<String, Integer> previousLocaleHashes = new LinkedHashMap<String, Integer>(this.lastLocaleHashes);
        boolean baselineReady = this.changeTrackingInitialized;
        this.reloadConfig();
        String lang = this.getConfig().getString("language", "en_US");
        this.messages.load(lang);
        this.syncAllYamlDefaults(lang);
        if (this.treeChopListener != null) {
            this.treeChopListener.refresh();
        }
        this.updateConfigModifiedTimestamp();
        this.refreshConfigWatchFlag();
        this.setupMetrics();
        this.warnIfUnsupportedEnvironment();
        this.announceNextUpdateSummary = true;
        this.configureUpdateChecker();
        this.logModuleStates();
        Map<String, String> currentConfigSnapshot = this.flattenConfiguration((ConfigurationSection)this.getConfig());
        Map<String, String> currentLeafSnapshot = this.loadLeafMappingsSnapshot();
        Map<String, Integer> currentLocaleFingerprints = this.computeLocaleFingerprints();
        if (baselineReady) {
            this.logFileChangeSummary(previousConfigSnapshot, currentConfigSnapshot, previousLeafSnapshot, currentLeafSnapshot, previousLocaleHashes, currentLocaleFingerprints);
        }
        this.updateChangeTrackingSnapshots(currentConfigSnapshot, currentLeafSnapshot, currentLocaleFingerprints);
    }

    private MergeResult mergeMissingConfigKeys() {
        InputStream in = this.getResource("config.yml");
        if (in == null) {
            return new MergeResult("config.yml", Collections.emptyList());
        }
        YamlConfiguration defaults = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        FileConfiguration current = this.getConfig();
        ArrayList<String> addedKeys = new ArrayList<String>();
        this.mergeSections((ConfigurationSection)current, (ConfigurationSection)defaults, "", addedKeys);
        if (!addedKeys.isEmpty()) {
            this.saveConfig();
        }
        return new MergeResult("config.yml", addedKeys);
    }

    private MergeResult mergeYamlResource(String relativePath) {
        this.ensureResourceExists(relativePath);
        InputStream in = this.getResource(relativePath);
        if (in == null) {
            return new MergeResult(relativePath, Collections.emptyList());
        }
        YamlConfiguration defaults = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        File targetFile = new File(this.getDataFolder(), relativePath);
        YamlConfiguration current = YamlConfiguration.loadConfiguration((File)targetFile);
        ArrayList<String> addedKeys = new ArrayList<String>();
        this.mergeSections((ConfigurationSection)current, (ConfigurationSection)defaults, "", addedKeys);
        if (!addedKeys.isEmpty()) {
            try {
                current.save(targetFile);
            }
            catch (IOException e) {
                this.getLogger().fine("Could not save " + relativePath + ": " + e.getMessage());
            }
        }
        return new MergeResult(relativePath, addedKeys);
    }

    private void syncAllYamlDefaults(String primaryLocale) {
        this.logMergeReport(this.mergeMissingConfigKeys());
        this.logMergeReport(this.mergeYamlResource("leaf_mappings.yml"));
        if (this.messages == null) {
            return;
        }
        LinkedHashSet<String> locales = new LinkedHashSet<String>(MessageService.getBundledLocales());
        if (primaryLocale != null && !primaryLocale.isBlank()) {
            locales.add(primaryLocale);
        }
        for (String locale : locales) {
            List<String> added = this.messages.syncLocaleFile(locale);
            this.logMergeReport(new MergeResult("lang/" + locale + ".yml", added));
        }
    }

    private void startConfigWatcher() {
        this.stopConfigWatcher();
        this.configWatcherTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            if (!this.configWatchEnabledFlag) {
                return;
            }
            try {
                File file = new File(this.getDataFolder(), "config.yml");
                if (!file.exists()) {
                    return;
                }
                long lm = file.lastModified();
                long size = file.length();
                boolean changed = lm != this.lastConfigModified || size != this.lastConfigSize;
                int hash = this.lastConfigHash;
                if (!changed) {
                    hash = this.computeFileHash(file);
                    changed = hash != this.lastConfigHash;
                } else {
                    hash = this.computeFileHash(file);
                }
                if (changed) {
                    this.rememberConfigFingerprint(lm, size, hash);
                    Bukkit.getScheduler().runTask((Plugin)this, this::reloadAndMergeConfig);
                }
            }
            catch (Exception e) {
                this.getLogger().fine("Config watcher error: " + e.getMessage());
            }
        }, 100L, 100L);
    }

    private void updateConfigModifiedTimestamp() {
        File file = new File(this.getDataFolder(), "config.yml");
        if (!file.exists()) {
            this.rememberConfigFingerprint(0L, -1L, 0);
            return;
        }
        this.rememberConfigFingerprint(file.lastModified(), file.length(), this.computeFileHash(file));
    }

    private void rememberConfigFingerprint(long modified, long size, int hash) {
        this.lastConfigModified = modified;
        this.lastConfigSize = size;
        this.lastConfigHash = hash;
    }

    private int computeFileHash(File file) {
        int n;
        block9: {
            CRC32 crc = new CRC32();
            InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                int read;
                byte[] buffer = new byte[1024];
                while ((read = in.read(buffer)) != -1) {
                    crc.update(buffer, 0, read);
                }
                n = (int)crc.getValue();
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return -1;
                }
            }
            in.close();
        }
        return n;
    }

    private void refreshConfigWatchFlag() {
        this.configWatchEnabledFlag = this.getConfig().getBoolean("config_watch_enabled", true);
    }

    private void stopConfigWatcher() {
        if (this.configWatcherTask != null) {
            this.configWatcherTask.cancel();
            this.configWatcherTask = null;
        }
    }

    public boolean isEnabledFor(UUID uuid) {
        return !this.disabledPlayers.contains(uuid);
    }

    public void setEnabledFor(UUID uuid, boolean enabled) {
        if (enabled) {
            this.disabledPlayers.remove(uuid);
        } else {
            this.disabledPlayers.add(uuid);
        }
        this.saveToggles();
    }

    public boolean toggleEnabled(UUID uuid) {
        boolean now = !this.disabledPlayers.contains(uuid);
        this.setEnabledFor(uuid, !now);
        return !now;
    }

    private File togglesFile() {
        return new File(this.getDataFolder(), "toggles.yml");
    }

    private void loadToggles() {
        try {
            File f = this.togglesFile();
            if (!f.exists()) {
                return;
            }
            YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)f);
            List list = cfg.getStringList("disabled");
            this.disabledPlayers.clear();
            for (String s : list) {
                try {
                    this.disabledPlayers.add(UUID.fromString(s));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            this.getLogger().fine("Failed to load toggles.yml: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToggles() {
        try {
            File f = this.togglesFile();
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            YamlConfiguration cfg = new YamlConfiguration();
            ArrayList<String> list = new ArrayList<String>();
            Set<UUID> set = this.disabledPlayers;
            synchronized (set) {
                for (UUID u : this.disabledPlayers) {
                    list.add(u.toString());
                }
            }
            cfg.set("disabled", list);
            cfg.save(f);
        }
        catch (Exception e) {
            this.getLogger().fine("Failed to save toggles.yml: " + e.getMessage());
        }
    }

    private void mergeSections(ConfigurationSection target, ConfigurationSection defaults, String pathPrefix, List<String> addedKeys) {
        for (String key : defaults.getKeys(false)) {
            String fullKey;
            Object defVal = defaults.get(key);
            String string = fullKey = pathPrefix == null || pathPrefix.isEmpty() ? key : pathPrefix + "." + key;
            if (!target.contains(key)) {
                target.set(key, defVal);
                if (addedKeys == null) continue;
                addedKeys.add(fullKey);
                continue;
            }
            if (!(defVal instanceof ConfigurationSection)) continue;
            ConfigurationSection defChild = defaults.getConfigurationSection(key);
            ConfigurationSection tgtChild = target.getConfigurationSection(key);
            if (defChild == null || tgtChild == null) continue;
            this.mergeSections(tgtChild, defChild, fullKey, addedKeys);
        }
    }

    private void logMergeReport(MergeResult result) {
        if (result == null) {
            return;
        }
        if (result.addedKeys().isEmpty()) {
            return;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("file", result.fileName());
        placeholders.put("count", Integer.toString(result.addedKeys().size()));
        placeholders.put("keys", String.join((CharSequence)", ", result.addedKeys()));
        this.logLocalized(Level.INFO, "Defaults updated ({file}): {count} new keys -> {keys}", "log_defaults_updated", placeholders);
    }

    private void logModuleStates() {
        boolean timber = this.getConfig().getBoolean("enable_timber", true);
        boolean leaves = this.getConfig().getBoolean("enable_leaves_decay", true);
        boolean replantEnabled = this.getConfig().getBoolean("enable_replant", true);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("timber", this.stateLabel(timber));
        placeholders.put("replant", this.stateLabel(replantEnabled));
        placeholders.put("leaves", this.stateLabel(leaves));
        this.logLocalized(Level.INFO, "Module status -> Timber: {timber}, Replant: {replant}, Leaves: {leaves}", "log_modules_summary", placeholders);
    }

    private void logStartupBanner() {
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        if (console == null) {
            return;
        }
        for (String line : STARTUP_BANNER_LINES) {
            console.sendMessage(MINI.deserialize("<light_purple>" + line + "</light_purple>"));
        }
    }

    private String stateLabel(boolean flag) {
        if (this.messages != null) {
            return flag ? this.messages.plain("log_modules_state_active") : this.messages.plain("log_modules_state_inactive");
        }
        return flag ? "enabled" : "disabled";
    }

    private void setupMetrics() {
        boolean enabled = this.getConfig().getBoolean("metrics_enabled", true);
        if (!enabled) {
            this.shutdownMetrics();
            return;
        }
        if (this.metrics != null) {
            return;
        }
        this.metrics = new Metrics((Plugin)this, 28062);
        this.registerMetricsCharts(this.metrics);
    }

    private void shutdownMetrics() {
        if (this.metrics != null) {
            this.metrics.shutdown();
            this.metrics = null;
        }
    }

    private void registerMetricsCharts(Metrics metricsInstance) {
        metricsInstance.addCustomChart(new Metrics.SimplePie("language", () -> this.getConfig().getString("language", "en_US")));
        metricsInstance.addCustomChart(new Metrics.SimplePie("sneak_mode", () -> switch (this.getConfig().getInt("sneak_mode", 0)) {
            case 1 -> "not_sneaking";
            case 2 -> "always";
            default -> "sneak_only";
        }));
        metricsInstance.addCustomChart(new Metrics.SimplePie("durability_mode", () -> this.getConfig().getString("tools.durability_mode", "first")));
        metricsInstance.addCustomChart(new Metrics.SimplePie("update_provider", () -> switch (this.getConfig().getInt("update_provider", 0)) {
            case 1 -> "modrinth_only";
            case 2 -> "hangar_only";
            default -> "modrinth_hangar";
        }));
        metricsInstance.addCustomChart(new Metrics.AdvancedPie("enabled_modules", () -> {
            HashMap<String, Integer> values = new HashMap<String, Integer>();
            if (this.getConfig().getBoolean("enable_timber", true)) {
                values.put("timber", 1);
            }
            if (this.getConfig().getBoolean("enable_replant", true)) {
                values.put("replant_listener", 1);
            }
            if (this.getConfig().getBoolean("enable_leaves_decay", true)) {
                values.put("leaves_decay", 1);
            }
            return values;
        }));
        metricsInstance.addCustomChart(new Metrics.SimplePie("config_watch", () -> this.getConfig().getBoolean("config_watch_enabled", true) ? "enabled" : "disabled"));
        metricsInstance.addCustomChart(new Metrics.SingleLineChart("max_blocks_limit", () -> this.getConfig().getInt("max_blocks", 1024)));
        metricsInstance.addCustomChart(new Metrics.SimplePie("player_toggle_usage", () -> {
            Set<UUID> set = this.disabledPlayers;
            synchronized (set) {
                return this.disabledPlayers.isEmpty() ? "all_enabled" : "some_disabled";
            }
        }));
    }

    private void configureUpdateChecker() {
        this.cancelScheduledUpdateChecks();
        this.pendingUpdateInfo = null;
        if (!this.getConfig().getBoolean("check_updates", true)) {
            this.updateChecker = null;
            return;
        }
        int provider = this.getConfig().getInt("update_provider", 0);
        boolean includePrereleases = this.getConfig().getBoolean("update_include_prereleases", false);
        this.updateChecker = new UpdateChecker(this, provider, includePrereleases);
        this.scheduleUpdateChecks();
    }

    private void scheduleUpdateChecks() {
        if (this.updateChecker == null) {
            return;
        }
        long hours = Math.max(1L, this.getConfig().getLong("update_check_interval_hours", 24L));
        long ticks = hours * 60L * 60L * 20L;
        this.triggerUpdateCheck();
        this.periodicUpdateTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, this::triggerUpdateCheck, ticks, ticks);
    }

    private void cancelScheduledUpdateChecks() {
        if (this.periodicUpdateTask != null) {
            this.periodicUpdateTask.cancel();
            this.periodicUpdateTask = null;
        }
    }

    private void triggerUpdateCheck() {
        if (this.updateChecker == null) {
            return;
        }
        this.updateChecker.checkAsync().thenAccept(this::handleUpdateInfo);
    }

    private void handleUpdateInfo(UpdateChecker.UpdateInfo info) {
        boolean shouldLog;
        if (info == null) {
            return;
        }
        boolean bl = shouldLog = this.announceNextUpdateSummary || info.hasUpdate();
        if (shouldLog) {
            this.logUpdateSummary(info);
            this.announceNextUpdateSummary = false;
        }
        if (!info.hasUpdate()) {
            this.pendingUpdateInfo = null;
            return;
        }
        boolean alreadyAnnounced = this.pendingUpdateInfo != null && this.pendingUpdateInfo.latestVersion().equals(info.latestVersion());
        this.pendingUpdateInfo = info;
        if (alreadyAnnounced) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("latest_ver", info.latestVersion());
            placeholders.put("current_ver", info.currentVersion());
            this.getServer().getConsoleSender().sendMessage(this.messages.format("update_available", placeholders));
        });
    }

    public UpdateChecker.UpdateInfo getPendingUpdateInfo() {
        return this.pendingUpdateInfo;
    }

    private void logUpdateSummary(UpdateChecker.UpdateInfo info) {
        boolean shouldBracketLog;
        if (info == null) {
            return;
        }
        List<Object> providers = info.providers() == null ? Collections.emptyList() : info.providers();
        boolean hasProviderDetails = !providers.isEmpty();
        boolean bl = shouldBracketLog = info.hasUpdate() || hasProviderDetails;
        if (shouldBracketLog) {
            this.logDivider();
        }
        if (info.hasUpdate()) {
            this.logLocalized(Level.INFO, "Update found. Current version: {current}", "log_update_found", Map.of("current", info.currentVersion()));
        } else {
            this.logLocalized(Level.INFO, "No update found.", "log_update_none", Collections.emptyMap());
        }
        if (hasProviderDetails) {
            for (UpdateChecker.ProviderResult providerResult : providers) {
                this.logProviderResult(providerResult);
            }
        }
        if (shouldBracketLog) {
            this.logDivider();
        }
    }

    private void logDivider() {
        this.getLogger().info("=======================");
    }

    private void logProviderResult(UpdateChecker.ProviderResult result) {
        if (result == null) {
            return;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("provider", result.provider().displayName());
        if (!result.success()) {
            this.logLocalized(Level.INFO, "- {provider}: Failed to fetch.", "log_update_provider_error", placeholders);
            return;
        }
        placeholders.put("version", result.latestVersion());
        placeholders.put("url", result.url());
        this.logLocalized(Level.INFO, "- {provider}: Version {version} [{url}]", "log_update_provider_ok", placeholders);
    }

    private void warnIfUnsupportedEnvironment() {
        boolean versionOk;
        if (this.messages == null) {
            return;
        }
        String serverName = this.getServer().getName();
        String mcVersion = this.getServer().getMinecraftVersion();
        boolean serverOk = serverName != null && serverName.toLowerCase(Locale.ROOT).contains(REQUIRED_SERVER_BRAND.toLowerCase(Locale.ROOT));
        boolean bl = versionOk = mcVersion != null && SUPPORTED_MC_VERSIONS.contains(mcVersion);
        if (serverOk && versionOk) {
            return;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("server_name", serverName != null ? serverName : "unknown");
        placeholders.put("mc_version", mcVersion != null ? mcVersion : "unknown");
        placeholders.put("supported_versions", String.join((CharSequence)", ", SUPPORTED_MC_VERSIONS));
        placeholders.put("required_server", REQUIRED_SERVER_BRAND);
        ConsoleCommandSender console = this.getServer().getConsoleSender();
        if (console != null) {
            console.sendMessage(this.messages.format("warn_unsupported_environment", placeholders));
        }
        String warningText = this.messages != null ? this.messages.plain("warn_unsupported_environment", placeholders) : "Warning: Timberella might be running in an unsupported environment.";
        this.getLogger().warning(warningText);
    }

    private void updateChangeTrackingSnapshots(Map<String, String> configSnapshot, Map<String, String> leafSnapshot, Map<String, Integer> localeSnapshot) {
        this.lastConfigSnapshot = new LinkedHashMap<String, String>(configSnapshot == null ? Collections.emptyMap() : configSnapshot);
        this.lastLeafSnapshot = new LinkedHashMap<String, String>(leafSnapshot == null ? Collections.emptyMap() : leafSnapshot);
        this.lastLocaleHashes = new LinkedHashMap<String, Integer>(localeSnapshot == null ? Collections.emptyMap() : localeSnapshot);
        this.changeTrackingInitialized = true;
    }

    private Map<String, String> flattenConfiguration(ConfigurationSection section) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (section == null) {
            return result;
        }
        this.flattenSection(section, "", result);
        return result;
    }

    private void flattenSection(ConfigurationSection section, String prefix, Map<String, String> out) {
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            String fullKey;
            String string = fullKey = prefix == null || prefix.isEmpty() ? key : prefix + "." + key;
            if (section.isConfigurationSection(key)) {
                this.flattenSection(section.getConfigurationSection(key), fullKey, out);
                continue;
            }
            Object value = section.get(key);
            out.put(fullKey, this.formatValue(value));
        }
    }

    private String formatValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof List) {
            return ((List)value).stream().map(String::valueOf).collect(Collectors.joining(", "));
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            ArrayList<String> parts = new ArrayList<String>(length);
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(value, i);
                parts.add(String.valueOf(element));
            }
            return String.join((CharSequence)", ", parts);
        }
        return String.valueOf(value);
    }

    private Map<String, String> loadLeafMappingsSnapshot() {
        File file = new File(this.getDataFolder(), "leaf_mappings.yml");
        if (!file.exists()) {
            return Collections.emptyMap();
        }
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
        return this.flattenConfiguration((ConfigurationSection)yaml);
    }

    private Map<String, Integer> computeLocaleFingerprints() {
        LinkedHashMap<String, Integer> hashes = new LinkedHashMap<String, Integer>();
        File langDir = new File(this.getDataFolder(), "lang");
        if (!langDir.exists()) {
            return hashes;
        }
        File[] files = langDir.listFiles((dir, name) -> name.toLowerCase(Locale.ROOT).endsWith(".yml"));
        if (files == null) {
            return hashes;
        }
        for (File file : files) {
            hashes.put(file.getName(), this.computeFileHash(file));
        }
        return hashes;
    }

    private void logFileChangeSummary(Map<String, String> previousConfig, Map<String, String> currentConfig, Map<String, String> previousLeaf, Map<String, String> currentLeaf, Map<String, Integer> previousLocales, Map<String, Integer> currentLocales) {
        List<String> configChanges = this.describeChanges(previousConfig, currentConfig);
        List<String> leafChanges = this.describeChanges(previousLeaf, currentLeaf);
        List<String> localeChanges = this.detectLocaleChanges(previousLocales, currentLocales);
        if (configChanges.isEmpty() && leafChanges.isEmpty() && localeChanges.isEmpty()) {
            this.logLocalized(Level.INFO, "No configuration changes detected.", "log_reload_changes_none", Collections.emptyMap());
            return;
        }
        this.logLocalized(Level.INFO, "Detected file changes:", "log_reload_changes_header", Collections.emptyMap());
        this.logChangeLine("config.yml", configChanges);
        this.logChangeLine("leaf_mappings.yml", leafChanges);
        for (String localeFile : localeChanges) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("file", localeFile);
            this.logLocalized(Level.INFO, "{file}", "log_reload_changes_locale_line", placeholders);
        }
    }

    private void logChangeLine(String fileName, List<String> changes) {
        if (changes == null || changes.isEmpty()) {
            return;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("file", fileName);
        placeholders.put("changes", String.join((CharSequence)", ", changes));
        this.logLocalized(Level.INFO, "{file} ({changes})", "log_reload_changes_line", placeholders);
    }

    private List<String> describeChanges(Map<String, String> previous, Map<String, String> current) {
        Map<Object, Object> safePrevious = previous == null ? Collections.emptyMap() : previous;
        Map<Object, Object> safeCurrent = current == null ? Collections.emptyMap() : current;
        TreeSet<Object> keys = new TreeSet<Object>();
        keys.addAll(safePrevious.keySet());
        keys.addAll(safeCurrent.keySet());
        ArrayList<String> changes = new ArrayList<String>();
        for (String string : keys) {
            String newVal;
            String oldVal = (String)safePrevious.get(string);
            if (Objects.equals(oldVal, newVal = (String)safeCurrent.get(string))) continue;
            if (newVal == null) {
                changes.add(string + "=<removed>");
                continue;
            }
            changes.add(string + "=" + newVal);
        }
        return changes;
    }

    private List<String> detectLocaleChanges(Map<String, Integer> previous, Map<String, Integer> current) {
        Map<Object, Object> safePrevious = previous == null ? Collections.emptyMap() : previous;
        Map<Object, Object> safeCurrent = current == null ? Collections.emptyMap() : current;
        TreeSet<Object> files = new TreeSet<Object>();
        files.addAll(safePrevious.keySet());
        files.addAll(safeCurrent.keySet());
        ArrayList<String> changes = new ArrayList<String>();
        for (String string : files) {
            Integer newHash;
            Integer oldHash = (Integer)safePrevious.get(string);
            if (Objects.equals(oldHash, newHash = (Integer)safeCurrent.get(string))) continue;
            changes.add("lang/" + string);
        }
        return changes;
    }

    private void ensureResourceExists(String relativePath) {
        File out = new File(this.getDataFolder(), relativePath);
        File parent = out.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        if (!out.exists()) {
            this.saveResource(relativePath, false);
            this.getLogger().info("Created default file: " + relativePath);
        }
    }

    private void logLocalized(Level level, String fallback, String messageKey, Map<String, String> placeholders) {
        Map<Object, Object> safePlaceholders;
        Map<Object, Object> map = safePlaceholders = placeholders == null ? Collections.emptyMap() : placeholders;
        if (this.messages != null && messageKey != null) {
            String text = safePlaceholders.isEmpty() ? this.messages.plain(messageKey) : this.messages.plain(messageKey, safePlaceholders);
            this.getLogger().log(level, text);
            return;
        }
        this.getLogger().log(level, this.replacePlaceholders(fallback, safePlaceholders));
    }

    private String replacePlaceholders(String template, Map<String, String> placeholders) {
        if (template == null) {
            return "";
        }
        String result = template;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            result = result.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return result;
    }

    private record MergeResult(String fileName, List<String> addedKeys) {
    }
}

