/*
 * Decompiled with CFR 0.152.
 */
package com.hro_basti.timberella.update;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hro_basti.timberella.TimberellaPlugin;
import com.hro_basti.timberella.util.VersionComparator;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class UpdateChecker {
    private final TimberellaPlugin plugin;
    private final int providerMode;
    private final boolean includePrereleases;
    private static final String MODRINTH_SLUG = "timberella";
    private static final String HANGAR_NAMESPACE = "hro_basti/timberella";

    public UpdateChecker(TimberellaPlugin plugin, int providerMode, boolean includePrereleases) {
        this.plugin = plugin;
        this.providerMode = providerMode;
        this.includePrereleases = includePrereleases;
    }

    public CompletableFuture<UpdateInfo> checkAsync() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String current = this.plugin.getPluginMeta().getVersion();
                ArrayList<ProviderResult> providers = new ArrayList<ProviderResult>();
                if (this.providerMode == 0 || this.providerMode == 1) {
                    providers.add(this.fetchModrinthStatus());
                }
                if (this.providerMode == 0 || this.providerMode == 2) {
                    providers.add(this.fetchHangarStatus());
                }
                String latest = this.findNewestAvailableVersion(current, providers);
                return new UpdateInfo(current, latest, providers);
            }
            catch (Throwable t) {
                this.plugin.getLogger().fine("Update check failed: " + t.getMessage());
                return new UpdateInfo(this.plugin.getPluginMeta().getVersion(), null, Collections.emptyList());
            }
        });
    }

    private ProviderResult fetchModrinthStatus() {
        try {
            String version = this.latestFromModrinth();
            if (version == null || version.isBlank()) {
                return this.errorResult(Provider.MODRINTH, "Fehler beim Abruf");
            }
            return new ProviderResult(Provider.MODRINTH, version, Provider.MODRINTH.url(), null);
        }
        catch (Exception ex) {
            this.plugin.getLogger().fine("Modrinth update check failed: " + ex.getMessage());
            return this.errorResult(Provider.MODRINTH, "Fehler beim Abruf");
        }
    }

    private ProviderResult fetchHangarStatus() {
        try {
            String version = this.latestFromHangar();
            if (version == null || version.isBlank()) {
                return this.errorResult(Provider.HANGAR, "Fehler beim Abruf");
            }
            return new ProviderResult(Provider.HANGAR, version, Provider.HANGAR.url(), null);
        }
        catch (Exception ex) {
            this.plugin.getLogger().fine("Hangar update check failed: " + ex.getMessage());
            return this.errorResult(Provider.HANGAR, "Fehler beim Abruf");
        }
    }

    private ProviderResult errorResult(Provider provider, String message) {
        return new ProviderResult(provider, null, provider.url(), message);
    }

    private String findNewestAvailableVersion(String current, List<ProviderResult> providers) {
        String latest = null;
        for (ProviderResult result : providers) {
            String candidate = result.latestVersion();
            if (candidate == null || !VersionComparator.isGreater(candidate, current) || latest != null && !VersionComparator.isGreater(candidate, latest)) continue;
            latest = candidate;
        }
        return latest;
    }

    private String latestFromModrinth() throws Exception {
        block9: {
            URL url = URI.create("https://api.modrinth.com/v2/project/timberella/version").toURL();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(4000);
            conn.setReadTimeout(4000);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", "Timberella-UpdateChecker");
            if (conn.getResponseCode() != 200) {
                throw new IllegalStateException("HTTP " + conn.getResponseCode());
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                JsonElement el = JsonParser.parseString(sb.toString());
                if (!el.isJsonArray()) break block9;
                JsonArray arr = el.getAsJsonArray();
                for (JsonElement entry : arr) {
                    if (!entry.isJsonObject()) continue;
                    JsonObject version = entry.getAsJsonObject();
                    if (!this.includePrereleases && this.isModrinthPrerelease(version)) continue;
                    if (!version.has("version_number")) continue;
                    String string = version.get("version_number").getAsString();
                    return string;
                }
            }
        }
        throw new IllegalStateException("No versions found");
    }

    private String latestFromHangar() throws Exception {
        block12: {
            URL url = URI.create("https://hangar.papermc.io/api/v1/projects/hro_basti/timberella/versions").toURL();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(4000);
            conn.setReadTimeout(4000);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", "Timberella-UpdateChecker");
            if (conn.getResponseCode() != 200) {
                throw new IllegalStateException("HTTP " + conn.getResponseCode());
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                JsonElement res;
                JsonObject obj;
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                JsonElement el = JsonParser.parseString(sb.toString());
                if (el.isJsonArray()) {
                    JsonArray arr = el.getAsJsonArray();
                    for (JsonElement entry : arr) {
                        if (!entry.isJsonObject()) continue;
                        JsonObject version = entry.getAsJsonObject();
                        if (!this.includePrereleases && this.isHangarPrerelease(version)) continue;
                        if (!version.has("name")) continue;
                        String string = version.get("name").getAsString();
                        return string;
                    }
                    break block12;
                }
                if (!el.isJsonObject() || !(obj = el.getAsJsonObject()).has("result") || !(res = obj.get("result")).isJsonArray()) break block12;
                JsonArray arr = res.getAsJsonArray();
                for (JsonElement entry : arr) {
                    if (!entry.isJsonObject()) continue;
                    JsonObject version = entry.getAsJsonObject();
                    if (!this.includePrereleases && this.isHangarPrerelease(version)) continue;
                    if (!version.has("name")) continue;
                    String string = version.get("name").getAsString();
                    return string;
                }
            }
        }
        throw new IllegalStateException("No versions found");
    }

    private boolean isModrinthPrerelease(JsonObject version) {
        if (version.has("prerelease") && version.get("prerelease").isJsonPrimitive()) {
            try {
                if (version.get("prerelease").getAsBoolean()) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (version.has("version_type") && version.get("version_type").isJsonPrimitive()) {
            String type = version.get("version_type").getAsString();
            return !"release".equalsIgnoreCase(type);
        }
        return false;
    }

    private boolean isHangarPrerelease(JsonObject version) {
        if (version.has("channel")) {
            JsonElement channelEl = version.get("channel");
            String channelName = null;
            if (channelEl.isJsonObject()) {
                JsonObject channelObj = channelEl.getAsJsonObject();
                if (channelObj.has("name")) {
                    channelName = channelObj.get("name").getAsString();
                }
            } else if (channelEl.isJsonPrimitive()) {
                channelName = channelEl.getAsString();
            }
            if (channelName != null) {
                return !"release".equalsIgnoreCase(channelName);
            }
        }
        if (version.has("visibility") && version.get("visibility").isJsonPrimitive()) {
            return false;
        }
        return false;
    }

    public static enum Provider {
        MODRINTH("Modrinth", "https://modrinth.com/plugin/timberella"),
        HANGAR("Hangar", "https://hangar.papermc.io/hro_basti/timberella");

        private final String displayName;
        private final String url;

        private Provider(String displayName, String url) {
            this.displayName = displayName;
            this.url = url;
        }

        public String displayName() {
            return this.displayName;
        }

        public String url() {
            return this.url;
        }
    }

    public record ProviderResult(Provider provider, String latestVersion, String url, String errorMessage) {
        public boolean success() {
            return this.errorMessage == null;
        }
    }

    public record UpdateInfo(String currentVersion, String latestVersion, List<ProviderResult> providers) {
        public boolean hasUpdate() {
            return this.latestVersion != null && !this.latestVersion.isBlank();
        }
    }
}

