/*
 * Decompiled with CFR 0.152.
 */
package com.hro_basti.timberella.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageService {
    private static final MiniMessage MINI = MiniMessage.miniMessage();
    private static final PlainTextComponentSerializer PLAIN = PlainTextComponentSerializer.plainText();
    private static final String DEFAULT_LOCALE = "en_US";
    private static final String[] BUNDLED_LOCALES = new String[]{"en_US", "de_DE", "ar_SA", "es_ES", "fr_FR", "it_IT", "ja_JP", "ko_KR", "nl_NL", "pl_PL", "pt_PT", "tr_TR", "uk_UA", "zh_CN"};
    private final JavaPlugin plugin;
    private final Map<String, String> messages = new HashMap<String, String>();
    private String prefixRaw = "<light_purple>[Timberella]</light_purple>";

    public MessageService(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public static List<String> getBundledLocales() {
        return List.of(BUNDLED_LOCALES);
    }

    public void load(String locale) {
        this.messages.clear();
        this.ensureBundledLocales();
        File langFile = new File(this.plugin.getDataFolder(), "lang" + File.separator + locale + ".yml");
        if (!langFile.exists()) {
            locale = DEFAULT_LOCALE;
            langFile = new File(this.plugin.getDataFolder(), "lang" + File.separator + "en_US.yml");
        }
        this.syncLocaleFile(locale);
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)langFile);
        for (String key : cfg.getKeys(false)) {
            this.messages.put(key, cfg.getString(key, key));
        }
        this.prefixRaw = this.messages.getOrDefault("prefix", "<light_purple>[Timberella]</light_purple>");
    }

    private void ensureBundledLocales() {
        for (String locale : BUNDLED_LOCALES) {
            this.saveLangIfAbsent(locale + ".yml");
        }
    }

    private File saveLangIfAbsent(String name) {
        File out = new File(this.plugin.getDataFolder(), "lang" + File.separator + name);
        if (!out.getParentFile().exists()) {
            out.getParentFile().mkdirs();
        }
        if (!out.exists()) {
            try {
                this.plugin.saveResource("lang/" + name, false);
            }
            catch (IllegalArgumentException ex) {
                try {
                    if (!out.createNewFile()) {
                        this.plugin.getLogger().fine("Could not create " + name + " (already exists?).");
                    }
                }
                catch (IOException ioException) {
                    this.plugin.getLogger().fine("Could not create language file " + name + ": " + ioException.getMessage());
                }
            }
        }
        return out;
    }

    public List<String> syncLocaleFile(String locale) {
        if (locale == null || locale.isBlank()) {
            return Collections.emptyList();
        }
        if (locale.endsWith(".yml")) {
            locale = locale.substring(0, locale.length() - 4);
        }
        File langFile = this.saveLangIfAbsent(locale + ".yml");
        return this.mergeMissingLangKeys(langFile, locale);
    }

    private List<String> mergeMissingLangKeys(File langFile, String locale) {
        YamlConfiguration target = YamlConfiguration.loadConfiguration((File)langFile);
        YamlConfiguration defaults = this.loadDefaultLang(locale);
        if (defaults == null) {
            return Collections.emptyList();
        }
        ArrayList<String> addedKeys = new ArrayList<String>();
        boolean changed = this.mergeSections((ConfigurationSection)target, (ConfigurationSection)defaults, "", addedKeys);
        if (changed) {
            try {
                target.save(langFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().fine("Failed to merge lang keys for " + langFile.getName() + ": " + e.getMessage());
            }
        }
        return addedKeys;
    }

    private YamlConfiguration loadDefaultLang(String locale) {
        YamlConfiguration defaults = this.loadLocaleResource(locale);
        if (defaults == null && !DEFAULT_LOCALE.equals(locale)) {
            defaults = this.loadLocaleResource(DEFAULT_LOCALE);
        }
        return defaults;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private YamlConfiguration loadLocaleResource(String locale) {
        try (InputStream in = this.plugin.getResource("lang/" + locale + ".yml");){
            if (in == null) {
                YamlConfiguration yamlConfiguration2 = null;
                return yamlConfiguration2;
            }
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
            return yamlConfiguration;
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean mergeSections(ConfigurationSection target, ConfigurationSection defaults, String pathPrefix, List<String> addedKeys) {
        boolean changed = false;
        for (String key : defaults.getKeys(false)) {
            Object defVal = defaults.get(key);
            if (defVal instanceof ConfigurationSection) {
                ConfigurationSection targetSection;
                ConfigurationSection defSection = (ConfigurationSection)defVal;
                if (target.isConfigurationSection(key)) {
                    targetSection = target.getConfigurationSection(key);
                } else {
                    if (target.contains(key)) continue;
                    targetSection = target.createSection(key);
                }
                String fullKey = pathPrefix == null || pathPrefix.isEmpty() ? key : pathPrefix + "." + key;
                changed |= this.mergeSections(targetSection, defSection, fullKey, addedKeys);
                continue;
            }
            if (target.contains(key)) continue;
            target.set(key, defVal);
            if (addedKeys != null) {
                String fullKey = pathPrefix == null || pathPrefix.isEmpty() ? key : pathPrefix + "." + key;
                addedKeys.add(fullKey);
            }
            changed = true;
        }
        return changed;
    }

    public Component component(String key) {
        String raw = this.messages.getOrDefault(key, key);
        TagResolver resolver = TagResolver.resolver(Placeholder.parsed("prefix", this.prefixRaw));
        return MINI.deserialize(raw, resolver);
    }

    public Component format(String key, Map<String, String> replacements) {
        String raw = this.messages.getOrDefault(key, key);
        TagResolver.Builder builder = TagResolver.builder();
        builder.resolver(Placeholder.parsed("prefix", this.prefixRaw));
        for (Map.Entry<String, String> e : replacements.entrySet()) {
            builder.resolver(Placeholder.unparsed(e.getKey(), e.getValue()));
        }
        return MINI.deserialize(raw, builder.build());
    }

    public String plain(String key) {
        return PLAIN.serialize(this.component(key));
    }

    public String plain(String key, Map<String, String> replacements) {
        if (replacements == null || replacements.isEmpty()) {
            return this.plain(key);
        }
        return PLAIN.serialize(this.format(key, replacements));
    }
}

