/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sheepvariety.client.renderer.entity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.sheepvariety.client.model.geom.ModModelLayers;
import fuzs.sheepvariety.client.renderer.entity.layers.SheepVariantWoolLayer;
import fuzs.sheepvariety.client.renderer.entity.layers.SheepVariantWoolUndercoatLayer;
import fuzs.sheepvariety.client.renderer.entity.state.SheepVariantRenderState;
import fuzs.sheepvariety.init.ModRegistry;
import fuzs.sheepvariety.world.entity.animal.sheep.SheepVariant;
import java.util.Map;
import net.minecraft.client.model.AdultAndBabyModelPair;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SheepFurModel;
import net.minecraft.client.model.SheepModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.SheepRenderer;
import net.minecraft.client.renderer.entity.layers.SheepWoolLayer;
import net.minecraft.client.renderer.entity.layers.SheepWoolUndercoatLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.SheepRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.sheep.Sheep;

public class SheepVariantRenderer
extends SheepRenderer {
    private final Map<SheepVariant.ModelType, AdultAndBabyModelPair<SheepModel>> models;

    public SheepVariantRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.models = SheepVariantRenderer.bakeModels(context);
        this.layers.removeIf(renderLayer -> renderLayer instanceof SheepWoolLayer || renderLayer instanceof SheepWoolUndercoatLayer);
        this.addLayer(new SheepVariantWoolUndercoatLayer((RenderLayerParent<SheepRenderState, SheepModel>)this, context));
        this.addLayer(new SheepVariantWoolLayer((RenderLayerParent<SheepRenderState, SheepModel>)this, context));
    }

    private static Map<SheepVariant.ModelType, AdultAndBabyModelPair<SheepModel>> bakeModels(EntityRendererProvider.Context context) {
        return Maps.newEnumMap(Map.of(SheepVariant.ModelType.NORMAL, new AdultAndBabyModelPair((Model)new SheepModel(context.bakeLayer(ModelLayers.SHEEP)), (Model)new SheepModel(context.bakeLayer(ModelLayers.SHEEP_BABY))), SheepVariant.ModelType.WARM, new AdultAndBabyModelPair((Model)new SheepModel(context.bakeLayer(ModModelLayers.WARM_SHEEP)), (Model)new SheepModel(context.bakeLayer(ModModelLayers.WARM_SHEEP_BABY))), SheepVariant.ModelType.COLD, new AdultAndBabyModelPair((Model)new SheepModel(context.bakeLayer(ModModelLayers.COLD_SHEEP)), (Model)new SheepModel(context.bakeLayer(ModModelLayers.COLD_SHEEP_BABY)))));
    }

    public static LayerDefinition createWarmBodyLayer() {
        MeshDefinition meshDefinition = SheepModel.createBodyLayer().mesh;
        PartDefinition partDefinition = meshDefinition.getRoot().getChild("head");
        partDefinition.addOrReplaceChild("left_horn", CubeListBuilder.create().texOffs(0, 32).addBox(1.0f, -6.0f, -4.0f, 4.0f, 5.0f, 5.0f).texOffs(0, 42).addBox(4.0f, -3.0f, -6.0f, 1.0f, 2.0f, 2.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("right_horn", CubeListBuilder.create().texOffs(0, 32).mirror().addBox(-5.0f, -6.0f, -4.0f, 4.0f, 5.0f, 5.0f).texOffs(0, 42).mirror().addBox(-5.0f, -3.0f, -6.0f, 1.0f, 2.0f, 2.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static LayerDefinition createColdFurLayer() {
        MeshDefinition meshDefinition = SheepFurModel.createFurLayer().mesh;
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.getChild("head").addOrReplaceChild("facial_hair", CubeListBuilder.create().texOffs(0, 32).addBox(-3.0f, -4.0f, -6.4f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.6f)), PartPose.ZERO);
        partDefinition.getChild("body").addOrReplaceChild("long_wool", CubeListBuilder.create().texOffs(28, 40).addBox(-4.0f, -10.0f, -10.15f, 8.0f, 16.0f, 6.0f, new CubeDeformation(1.75f)), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public ResourceLocation getTextureLocation(SheepRenderState sheepRenderState) {
        return ((SheepVariantRenderState)sheepRenderState).variant == null ? MissingTextureAtlasSprite.getLocation() : ((SheepVariantRenderState)sheepRenderState).variant.assetInfo().asset().texturePath();
    }

    public SheepRenderState createRenderState() {
        return new SheepVariantRenderState();
    }

    public void extractRenderState(Sheep sheep, SheepRenderState sheepRenderState, float partialTick) {
        super.extractRenderState(sheep, sheepRenderState, partialTick);
        ((SheepVariantRenderState)sheepRenderState).variant = (SheepVariant)((Holder)ModRegistry.SHEEP_VARIANT_ATTACHMENT_TYPE.get((Object)sheep)).value();
    }

    public void submit(SheepRenderState sheepRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (((SheepVariantRenderState)sheepRenderState).variant != null) {
            AdultAndBabyModelPair<SheepModel> adultAndBabyModelPair = this.models.get((Object)((SheepVariantRenderState)sheepRenderState).variant.assetInfo().model());
            this.adultModel = (EntityModel)adultAndBabyModelPair.getModel(false);
            this.babyModel = (EntityModel)adultAndBabyModelPair.getModel(true);
            super.submit((LivingEntityRenderState)sheepRenderState, poseStack, submitNodeCollector, cameraRenderState);
        }
    }
}

