/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sheepvariety.client.renderer.entity.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.sheepvariety.client.model.geom.ModModelLayers;
import fuzs.sheepvariety.client.renderer.entity.state.SheepVariantRenderState;
import fuzs.sheepvariety.world.entity.animal.sheep.SheepVariant;
import java.util.Map;
import net.minecraft.client.model.AdultAndBabyModelPair;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SheepFurModel;
import net.minecraft.client.model.SheepModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.SheepRenderState;
import net.minecraft.resources.ResourceLocation;

public class SheepVariantWoolLayer
extends RenderLayer<SheepRenderState, SheepModel> {
    private final Map<SheepVariant.ModelType, AdultAndBabyModelPair<SheepFurModel>> models;

    public SheepVariantWoolLayer(RenderLayerParent<SheepRenderState, SheepModel> renderer, EntityRendererProvider.Context context) {
        super(renderer);
        this.models = SheepVariantWoolLayer.bakeModels(context);
    }

    private static Map<SheepVariant.ModelType, AdultAndBabyModelPair<SheepFurModel>> bakeModels(EntityRendererProvider.Context context) {
        return Maps.newEnumMap(Map.of(SheepVariant.ModelType.NORMAL, new AdultAndBabyModelPair((Model)new SheepFurModel(context.bakeLayer(ModelLayers.SHEEP_WOOL)), (Model)new SheepFurModel(context.bakeLayer(ModelLayers.SHEEP_BABY_WOOL))), SheepVariant.ModelType.WARM, new AdultAndBabyModelPair((Model)new SheepFurModel(context.bakeLayer(ModModelLayers.WARM_SHEEP_WOOL)), (Model)new SheepFurModel(context.bakeLayer(ModModelLayers.WARM_SHEEP_BABY_WOOL))), SheepVariant.ModelType.COLD, new AdultAndBabyModelPair((Model)new SheepFurModel(context.bakeLayer(ModModelLayers.COLD_SHEEP_WOOL)), (Model)new SheepFurModel(context.bakeLayer(ModModelLayers.COLD_SHEEP_BABY_WOOL)))));
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int packedLight, SheepRenderState sheepRenderState, float yRot, float xRot) {
        if (!sheepRenderState.isSheared) {
            EntityModel entityModel = (EntityModel)this.models.get((Object)((SheepVariantRenderState)sheepRenderState).variant.assetInfo().model()).getModel(sheepRenderState.isBaby);
            if (sheepRenderState.isInvisible) {
                if (sheepRenderState.appearsGlowing()) {
                    RenderType renderType = RenderType.outline((ResourceLocation)((SheepVariantRenderState)sheepRenderState).variant.assetInfo().wool().texturePath());
                    submitNodeCollector.submitModel((Model)entityModel, (Object)sheepRenderState, poseStack, renderType, packedLight, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)sheepRenderState, (float)0.0f), -16777216, null, sheepRenderState.outlineColor, null);
                }
            } else {
                SheepVariantWoolLayer.coloredCutoutModelCopyLayerRender((Model)entityModel, (ResourceLocation)((SheepVariantRenderState)sheepRenderState).variant.assetInfo().wool().texturePath(), (PoseStack)poseStack, (SubmitNodeCollector)submitNodeCollector, (int)packedLight, (LivingEntityRenderState)sheepRenderState, (int)sheepRenderState.getWoolColor(), (int)1);
            }
        }
    }
}

