/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sheepvariety.handler;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.data.MutableValue;
import fuzs.puzzleslib.api.util.v1.EntityHelper;
import fuzs.sheepvariety.init.ModRegistry;
import fuzs.sheepvariety.world.entity.animal.sheep.SheepVariants;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class SheepSpawnVariantHandler {
    public static EventResult onEntitySpawn(Entity entity, ServerLevel serverLevel, boolean isNewlySpawned) {
        Sheep sheep;
        if (isNewlySpawned && entity instanceof Sheep && EntityHelper.getMobSpawnReason((Entity)(sheep = (Sheep)entity)) != null) {
            SheepVariants.selectVariantToSpawn(serverLevel.random, serverLevel.registryAccess(), SpawnContext.create((ServerLevelAccessor)serverLevel, (BlockPos)entity.blockPosition())).ifPresent(holder -> ModRegistry.SHEEP_VARIANT_ATTACHMENT_TYPE.set((Object)entity, holder));
        }
        return EventResult.PASS;
    }

    public static EventResult onBabyEntitySpawn(Mob partnerMob, Mob otherPartnerMob, MutableValue<AgeableMob> childMob) {
        Object object = childMob.get();
        if (object instanceof Sheep) {
            Sheep sheep = (Sheep)object;
            Holder holder = sheep.getRandom().nextBoolean() ? (Holder)ModRegistry.SHEEP_VARIANT_ATTACHMENT_TYPE.get((Object)partnerMob) : (Holder)ModRegistry.SHEEP_VARIANT_ATTACHMENT_TYPE.get((Object)otherPartnerMob);
            if (holder == null) {
                holder = sheep.registryAccess().lookupOrThrow(ModRegistry.SHEEP_VARIANT_REGISTRY_KEY).getOrThrow(SheepVariants.DEFAULT);
            }
            ModRegistry.SHEEP_VARIANT_ATTACHMENT_TYPE.set((Object)sheep, (Object)holder);
        }
        return EventResult.PASS;
    }

    public static EventResultHolder<InteractionResult> onUseEntity(Player player, Level level, InteractionHand interactionHand, Entity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof Sheep) {
                SpawnEggItem item;
                Optional optional;
                Sheep sheep = (Sheep)entity;
                ItemStack itemInHand = player.getItemInHand(interactionHand);
                Item item2 = itemInHand.getItem();
                if (item2 instanceof SpawnEggItem && (optional = (item = (SpawnEggItem)item2).spawnOffspringFromSpawnEgg(player, (Mob)sheep, item.getType(itemInHand), serverLevel, sheep.position(), itemInHand)).isPresent()) {
                    Holder holder = (Holder)ModRegistry.SHEEP_VARIANT_ATTACHMENT_TYPE.get((Object)sheep);
                    if (holder != null) {
                        ModRegistry.SHEEP_VARIANT_ATTACHMENT_TYPE.set((Object)((Entity)optional.get()), (Object)holder);
                    }
                    return EventResultHolder.interrupt((Object)InteractionResult.SUCCESS_SERVER);
                }
            }
        }
        return EventResultHolder.pass();
    }
}

