/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sheepvariety.world.entity.animal.sheep;

import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.sheepvariety.SheepVariety;
import fuzs.sheepvariety.init.ModRegistry;
import fuzs.sheepvariety.world.entity.animal.sheep.SheepVariant;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.animal.TemperatureVariants;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.PriorityProvider;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.level.biome.Biome;

public class SheepVariants {
    public static final ResourceKey<SheepVariant> TEMPERATE = SheepVariants.createKey(TemperatureVariants.TEMPERATE);
    public static final ResourceKey<SheepVariant> WARM = SheepVariants.createKey(TemperatureVariants.WARM);
    public static final ResourceKey<SheepVariant> COLD = SheepVariants.createKey(TemperatureVariants.COLD);
    public static final ResourceKey<SheepVariant> DEFAULT = TEMPERATE;

    private static ResourceKey<SheepVariant> createKey(ResourceLocation resourceLocation) {
        return ResourceKey.create(ModRegistry.SHEEP_VARIANT_REGISTRY_KEY, (ResourceLocation)resourceLocation);
    }

    public static void bootstrap(BootstrapContext<SheepVariant> bootstrapContext) {
        SheepVariants.register(bootstrapContext, TEMPERATE, SheepVariant.ModelType.NORMAL, ResourceLocationHelper.withDefaultNamespace((String)"sheep"), SpawnPrioritySelectors.fallback((int)0));
        SheepVariants.register(bootstrapContext, WARM, SheepVariant.ModelType.WARM, SheepVariety.id("warm_sheep"), (TagKey<Biome>)BiomeTags.SPAWNS_WARM_VARIANT_FARM_ANIMALS);
        SheepVariants.register(bootstrapContext, COLD, SheepVariant.ModelType.COLD, SheepVariety.id("cold_sheep"), (TagKey<Biome>)BiomeTags.SPAWNS_COLD_VARIANT_FARM_ANIMALS);
    }

    private static void register(BootstrapContext<SheepVariant> bootstrapContext, ResourceKey<SheepVariant> resourceKey, SheepVariant.ModelType modelType, ResourceLocation resourceLocation, TagKey<Biome> tagKey) {
        HolderSet.Named holderSet = bootstrapContext.lookup(Registries.BIOME).getOrThrow(tagKey);
        SheepVariants.register(bootstrapContext, resourceKey, modelType, resourceLocation, SpawnPrioritySelectors.single((SpawnCondition)new BiomeCheck((HolderSet)holderSet), (int)1));
    }

    private static void register(BootstrapContext<SheepVariant> bootstrapContext, ResourceKey<SheepVariant> resourceKey, SheepVariant.ModelType modelType, ResourceLocation resourceLocation, SpawnPrioritySelectors spawnPrioritySelectors) {
        ClientAsset.ResourceTexture assetId = new ClientAsset.ResourceTexture(resourceLocation.withPath(s -> "entity/sheep/" + s));
        ClientAsset.ResourceTexture woolId = new ClientAsset.ResourceTexture(resourceLocation.withPath(s -> "entity/sheep/" + s + "_wool"));
        ClientAsset.ResourceTexture undercoatId = new ClientAsset.ResourceTexture(resourceLocation.withPath(s -> "entity/sheep/" + s + "_wool_undercoat"));
        bootstrapContext.register(resourceKey, (Object)new SheepVariant(new SheepVariant.AssetInfo(modelType, assetId, woolId, undercoatId), spawnPrioritySelectors));
    }

    public static Optional<Holder.Reference<SheepVariant>> selectVariantToSpawn(RandomSource randomSource, RegistryAccess registryAccess, SpawnContext spawnContext) {
        return PriorityProvider.pick((Stream)registryAccess.lookupOrThrow(ModRegistry.SHEEP_VARIANT_REGISTRY_KEY).listElements(), Holder::value, (RandomSource)randomSource, (Object)spawnContext);
    }
}

