/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.genielamp.item.custom;

import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tejty.genielamp.config.GenieLampCommonConfigs;
import net.tejty.genielamp.item.ModItems;
import net.tejty.genielamp.networking.ModMessages;
import net.tejty.genielamp.networking.packet.RenderTotemAnimationForItemS2CPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenieLampItem
extends Item {
    private final Random random = new Random();

    public GenieLampItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        if (Screen.m_96638_()) {
            Item item = pStack.m_41720_();
            if (item instanceof GenieLampItem) {
                GenieLampItem item2 = (GenieLampItem)item;
                pTooltip.add((Component)Component.m_237115_((String)"item.genie_lamp.magic_lamp.tooltip.uncharged").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_PURPLE}));
                pTooltip.add((Component)Component.m_237119_());
                pTooltip.add((Component)Component.m_237115_((String)"item.genie_lamp.magic_lamp.tooltip.experience").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_GREEN}));
                int barLength = 10;
                int chargedLength = (int)((float)this.getExperience(pStack) / (float)GenieLampItem.getMaxExperience() * (float)barLength);
                String chargedBar = "\u2588".repeat(Math.max(0, chargedLength));
                String unchargedBar = "\u2592".repeat(Math.max(0, barLength - chargedLength));
                pTooltip.add((Component)Component.m_237113_((String)chargedBar).m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)unchargedBar).m_130940_(ChatFormatting.GRAY)));
                pTooltip.add((Component)Component.m_237113_((String)(this.getExperience(pStack) + "/" + GenieLampItem.getMaxExperience())));
                pTooltip.add((Component)Component.m_237119_());
                pTooltip.add((Component)Component.m_237115_((String)"item.genie_lamp.magic_lamp.tooltip.tutorial").m_130940_(ChatFormatting.GRAY));
            }
        } else {
            pTooltip.add((Component)Component.m_237115_((String)"item.genie_lamp.magic_lamp.tooltip.press").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)"SHIFT").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW})).m_7220_((Component)Component.m_237115_((String)"item.genie_lamp.magic_lamp.tooltip.for_details").m_130940_(ChatFormatting.GRAY)));
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        Item item;
        ItemStack item2 = pPlayer.m_21120_(pUsedHand);
        if (!pLevel.m_5776_() && (item = item2.m_41720_()) instanceof GenieLampItem) {
            GenieLampItem lamp = (GenieLampItem)item;
            if (!item2.m_41782_()) {
                item2.m_41751_(new CompoundTag());
            }
            int experience = lamp.getExperience(item2);
            if (pPlayer.f_36078_ < 1 || experience >= GenieLampItem.getMaxExperience()) {
                return InteractionResultHolder.m_19100_((Object)item2);
            }
            if (!pPlayer.m_36337_()) {
                pPlayer.m_6749_(-1);
            }
            lamp.setExperience(item2, ++experience);
            if (experience >= GenieLampItem.getMaxExperience()) {
                pPlayer.m_21008_(pUsedHand, new ItemStack((ItemLike)ModItems.CHARGED_MAGIC_LAMP.get()));
                pPlayer.m_36335_().m_41524_(pPlayer.m_21120_(pUsedHand).m_41720_(), 60);
                Vec3 playerPos = pPlayer.m_20318_(0.0f);
                pLevel.m_6263_(null, playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, SoundEvents.f_11868_, SoundSource.PLAYERS, 2.0f, 1.0f);
                pPlayer.m_5661_((Component)Component.m_237113_((String)(GenieLampItem.getMaxExperience() + "/" + GenieLampItem.getMaxExperience())).m_130940_(ChatFormatting.DARK_GREEN), true);
                if (pPlayer instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                    ModMessages.sendToPlayer(new RenderTotemAnimationForItemS2CPacket(new ItemStack((ItemLike)ModItems.CHARGED_MAGIC_LAMP.get(), 1)), serverPlayer);
                }
                for (int i = 0; i < 50; ++i) {
                    Vec3 pos = new Vec3(playerPos.f_82479_ + this.random.nextDouble() - 0.5, playerPos.f_82480_ + this.random.nextDouble(), playerPos.f_82481_ + this.random.nextDouble() - 0.5);
                    ((ServerLevel)pLevel).m_8767_((ParticleOptions)ParticleTypes.f_175827_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.1);
                }
            } else {
                pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, this.random.nextFloat(0.5f, 0.8f));
            }
        }
        return InteractionResultHolder.m_19100_((Object)item2);
    }

    public int m_8105_(ItemStack pStack) {
        return 100;
    }

    public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        Item item;
        super.onInventoryTick(stack, level, player, slotIndex, selectedIndex);
        if ((player.m_21120_(InteractionHand.MAIN_HAND) == stack || player.m_21120_(InteractionHand.OFF_HAND) == stack) && (item = stack.m_41720_()) instanceof GenieLampItem) {
            GenieLampItem lamp = (GenieLampItem)item;
            player.m_5661_((Component)Component.m_237113_((String)(lamp.getExperience(stack) + "/" + GenieLampItem.getMaxExperience())).m_130940_(ChatFormatting.DARK_GREEN), true);
        }
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.SPYGLASS;
    }

    public void setExperience(ItemStack stack, int experience) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        CompoundTag nbtData = stack.m_41783_();
        assert (nbtData != null);
        nbtData.m_128405_("genie_lamp.experience", experience);
        stack.m_41751_(nbtData);
    }

    public int getExperience(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 0;
        }
        return stack.m_41783_().m_128451_("genie_lamp.experience");
    }

    public static int getMaxExperience() {
        return (Integer)GenieLampCommonConfigs.XP_AMOUNT.get();
    }
}

