/*
 * Decompiled with CFR 0.152.
 */
package egorkhabarov.locator_triangulation.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import egorkhabarov.locator_triangulation.data_providers.LocatorDataProvider;
import egorkhabarov.locator_triangulation.state.LocatorInfo;
import egorkhabarov.locator_triangulation.state.LocatorState;
import egorkhabarov.locator_triangulation.state.PlayerInfo;
import egorkhabarov.locator_triangulation.state.TargetInfo;
import egorkhabarov.locator_triangulation.util.ChatUtils;
import egorkhabarov.locator_triangulation.util.Triangulation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.minecraft.class_1657;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class LocatorDataCommand {
    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"locator_data").executes(context -> {
                class_310 client = class_310.method_1551();
                ChatUtils.sendLocatorPositions(LocatorDataProvider.getLocatorInfo(client));
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"locator_pos1").executes(context -> {
                class_310 client = class_310.method_1551();
                LocatorInfo info = LocatorDataProvider.getLocatorInfo(client);
                if (info == null) {
                    ChatUtils.sendErrorMessage("Failed to capture pos1");
                } else {
                    LocatorState.setPos1(info);
                    ChatUtils.sendConfirmationMessage("Locator pos1 saved");
                }
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"locator_pos2").executes(context -> {
                class_310 client = class_310.method_1551();
                LocatorInfo info = LocatorDataProvider.getLocatorInfo(client);
                if (info == null) {
                    ChatUtils.sendErrorMessage("Failed to capture pos2");
                } else {
                    LocatorState.setPos2(info);
                    ChatUtils.sendConfirmationMessage("Locator pos2 saved");
                }
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"locator_get_poses").executes(context -> {
                ChatUtils.sendLocatorPositions(LocatorState.getPos1(), LocatorState.getPos2());
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"locator_clear_pos1").executes(context -> {
                LocatorState.clearPos1();
                ChatUtils.sendConfirmationMessage("pos1 cleared");
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"locator_clear_pos2").executes(context -> {
                LocatorState.clearPos2();
                ChatUtils.sendConfirmationMessage("pos2 cleared");
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"locator_clear_poses").executes(context -> {
                LocatorState.clearAll();
                ChatUtils.sendConfirmationMessage("pos1 and pos2 cleared");
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"locator_locate").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
                class_310 client = class_310.method_1551();
                HashSet<String> names = new HashSet<String>(LocatorState.getNamesMap().keySet());
                if (client.field_1687 != null) {
                    for (class_1657 p : client.field_1687.method_18456()) {
                        names.add(p.method_7334().getName());
                    }
                }
                if (client.field_1724 != null) {
                    String selfName = client.field_1724.method_5477().getString();
                    for (String name : names) {
                        if (name.equalsIgnoreCase(selfName)) continue;
                        builder.suggest(name);
                    }
                }
                return builder.buildFuture();
            }).executes(context -> {
                class_310 client = class_310.method_1551();
                if (client.field_1724 == null) {
                    return 1;
                }
                if (LocatorState.getPos1() == null && LocatorState.getPos2() == null) {
                    ChatUtils.sendErrorMessage("Need both pos1 and pos2");
                    return 1;
                }
                String target_name = StringArgumentType.getString((CommandContext)context, (String)"player");
                UUID uuid = LocatorState.getNamesMap().get(target_name);
                if (uuid == null) {
                    ChatUtils.sendErrorMessage(String.format("Player \"%s\" not found in saved snapshots", target_name));
                    return 1;
                }
                LocatorDataCommand.handleLocateSingle(uuid, target_name);
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"locator_locate_all").executes(context -> {
                class_310 client = class_310.method_1551();
                if (client.field_1724 == null) {
                    return 1;
                }
                if (LocatorState.getPos1() == null && LocatorState.getPos2() == null) {
                    ChatUtils.sendErrorMessage("Need both pos1 and pos2");
                    return 1;
                }
                LocatorDataCommand.handleLocateAll();
                return 1;
            }));
        });
    }

    private static Optional<Triangulation.Result> getResultSingle(UUID uuid) {
        LocatorInfo pos1 = LocatorState.getPos1();
        LocatorInfo pos2 = LocatorState.getPos2();
        if (pos1 == null || pos2 == null) {
            return Optional.empty();
        }
        PlayerInfo self1 = pos1.self();
        PlayerInfo self2 = pos2.self();
        double x1 = self1.x();
        double z1 = self1.z();
        double x2 = self2.x();
        double z2 = self2.z();
        TargetInfo target1 = pos1.targets().get(uuid);
        TargetInfo target2 = pos2.targets().get(uuid);
        if (target1 == null || target2 == null) {
            return Optional.empty();
        }
        double yaw1 = target1.yaw();
        double yaw2 = target2.yaw();
        return Triangulation.triangulate(new PlayerInfo(x1, z1, yaw1), new PlayerInfo(x2, z2, yaw2));
    }

    private static void handleLocateSingle(UUID uuid, String target_name) {
        Optional<Triangulation.Result> result = LocatorDataCommand.getResultSingle(uuid);
        if (result.isEmpty()) {
            ChatUtils.sendErrorMessage("Something went wrong");
            return;
        }
        ChatUtils.sendLocatorResult(target_name, result.get());
    }

    private static void handleLocateAll() {
        Map<String, UUID> names = LocatorState.getNamesMap();
        HashMap<String, Triangulation.Result> calculated = new HashMap<String, Triangulation.Result>();
        HashSet<String> missed = new HashSet<String>();
        int found = 0;
        for (String name : names.keySet()) {
            UUID uuid = names.get(name);
            Optional<Triangulation.Result> result = LocatorDataCommand.getResultSingle(uuid);
            if (result.isEmpty()) {
                missed.add(name);
                continue;
            }
            calculated.put(name, result.get());
            ++found;
        }
        if (found == 0) {
            ChatUtils.sendErrorMessage("No players located (in snapshots)");
        } else {
            ChatUtils.sendLocatorResults(calculated, missed);
        }
    }
}

