/*
 * Decompiled with CFR 0.152.
 */
package egorkhabarov.locator_triangulation.util;

import egorkhabarov.locator_triangulation.state.LocatorInfo;
import egorkhabarov.locator_triangulation.state.PlayerInfo;
import egorkhabarov.locator_triangulation.state.TargetInfo;
import egorkhabarov.locator_triangulation.util.Triangulation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class ChatUtils {
    static class_2561 prefix = class_2561.method_43470((String)"[").method_10852((class_2561)class_2561.method_43470((String)"Locator").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"] "));

    public static void sendModMessage(Object ... parts) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        class_5250 result = prefix.method_27661();
        for (Object part : parts) {
            if (part instanceof class_2561) {
                class_2561 text = (class_2561)part;
                result.method_10852(text);
                continue;
            }
            if (part instanceof String) {
                String str = (String)part;
                result.method_10852((class_2561)class_2561.method_43470((String)str));
                continue;
            }
            result.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(part)));
        }
        client.field_1724.method_7353((class_2561)result, false);
    }

    public static void sendErrorMessage(String message) {
        ChatUtils.sendModMessage(class_2561.method_43470((String)message).method_27692(class_124.field_1061));
    }

    public static void sendConfirmationMessage(String message) {
        ChatUtils.sendModMessage(class_2561.method_43470((String)message).method_27692(class_124.field_1060));
    }

    public static class_2561 formatPlayerCoordinates(double x, double z, double angle) {
        String coordsRaw = String.format("%.0f %.0f", x, z);
        class_5250 coords = class_2561.method_43470((String)coordsRaw).method_27694(style -> style.method_27705(new class_124[]{class_124.field_1080, class_124.field_1073}).method_10958((class_2558)new class_2558.class_10606(coordsRaw)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to copy coordinates"))));
        class_124 angle_color = angle >= 70.0 && angle <= 100.0 ? class_124.field_1060 : (angle >= 20.0 && angle < 70.0 || angle > 100.0 && angle <= 150.0 ? class_124.field_1054 : class_124.field_1061);
        class_5250 angleText = class_2561.method_43470((String)String.format(" %.1f\u00b0", angle)).method_10862(class_2583.field_24360.method_10977(angle_color));
        return class_2561.method_43473().method_10852((class_2561)coords).method_10852((class_2561)angleText);
    }

    public static void sendLocatorResult(String name, Triangulation.Result result) {
        class_2561 formattedPlayerCoordinates = ChatUtils.formatPlayerCoordinates(result.x(), result.z(), result.angle());
        ChatUtils.sendModMessage(name, ": ", formattedPlayerCoordinates);
    }

    public static void sendLocatorResults(Map<String, Triangulation.Result> calculated, Set<String> missed) {
        HashSet<String> unionNames = new HashSet<String>(calculated.keySet());
        unionNames.addAll(missed);
        int maxLength = unionNames.stream().mapToInt(String::length).max().orElse(0);
        if (maxLength > 16) {
            maxLength = 16;
        }
        class_5250 headline = class_2561.method_43470((String)("Found: " + unionNames.size())).method_27692(class_124.field_1080);
        if (!calculated.isEmpty()) {
            headline.method_10852((class_2561)class_2561.method_43470((String)(" Calculated: " + calculated.size())).method_27692(class_124.field_1060));
        }
        if (!missed.isEmpty()) {
            headline.method_10852((class_2561)class_2561.method_43470((String)(" Missed: " + missed.size())).method_27692(class_124.field_1061));
        }
        class_5250 calculated_text = class_2561.method_43473();
        boolean first = true;
        for (String name : calculated.keySet()) {
            if (!first) {
                calculated_text.method_27693("\n");
            }
            Triangulation.Result result = calculated.get(name);
            class_2561 formattedPlayerCoordinates = ChatUtils.formatPlayerCoordinates(result.x(), result.z(), result.angle());
            calculated_text.method_27693(String.format("%" + maxLength + "s", name)).method_27693(": ").method_10852(formattedPlayerCoordinates);
            first = false;
        }
        class_5250 missed_text = class_2561.method_43473();
        for (String name : missed) {
            if (!first) {
                missed_text.method_27693("\n");
            }
            missed_text.method_10852((class_2561)class_2561.method_43470((String)String.format("%" + maxLength + "s", name)).method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
            first = false;
        }
        ChatUtils.sendModMessage(class_2561.method_43473().method_10852((class_2561)headline).method_27693("\n").method_10852((class_2561)calculated_text).method_10852((class_2561)missed_text));
    }

    public static void sendTriangulationResult(Triangulation.Result result) {
        class_2561 formattedPlayerCoordinates = ChatUtils.formatPlayerCoordinates(result.x(), result.z(), result.angle());
        ChatUtils.sendModMessage(formattedPlayerCoordinates);
    }

    public static class_2561 formatLocatorPosition(LocatorInfo pos) {
        if (pos == null) {
            return class_2561.method_43470((String)"No locator data available").method_27692(class_124.field_1061);
        }
        class_5250 text = class_2561.method_43473();
        class_5250 headline = class_2561.method_43470((String)String.format("(%.0f, %.0f) yaw=%.1f\u00b0", pos.self().x(), pos.self().z(), pos.self().yaw())).method_27692(class_124.field_1080);
        text.method_10852((class_2561)headline).method_27693("\n");
        if (!pos.targets().keySet().isEmpty()) {
            for (UUID key : pos.targets().keySet()) {
                TargetInfo target = pos.targets().get(key);
                if (target == null) continue;
                text.method_10852((class_2561)class_2561.method_43470((String)target.name()).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" yaw=").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.format("%.1f\u00b0", target.yaw())).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" dist=").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.format("%.0f", target.distance())).method_27692(class_124.field_1054)).method_27693("\n");
            }
        } else {
            text.method_10852((class_2561)class_2561.method_43470((String)"No locator data").method_27692(class_124.field_1061));
        }
        return text;
    }

    public static class_2561 formatTriangulationPosition(PlayerInfo pos) {
        if (pos == null) {
            return class_2561.method_43470((String)"No data available").method_27692(class_124.field_1061);
        }
        return class_2561.method_43470((String)String.format("(%.0f, %.0f) yaw=%.1f\u00b0", pos.x(), pos.z(), pos.yaw())).method_27692(class_124.field_1080);
    }

    public static void sendLocatorPositions(LocatorInfo ... positions) {
        int count = positions.length;
        if (count == 1) {
            LocatorInfo pos = positions[0];
            ChatUtils.sendModMessage(ChatUtils.formatLocatorPosition(pos));
            return;
        }
        int counter = 1;
        class_5250 text = class_2561.method_43473();
        for (LocatorInfo pos : positions) {
            class_2561 formatLocatorPosition = ChatUtils.formatLocatorPosition(pos);
            text.method_10852((class_2561)class_2561.method_43470((String)("Pos " + counter + "\n")).method_27692(class_124.field_1067)).method_10852(formatLocatorPosition).method_27693("\n");
            ++counter;
        }
        ChatUtils.sendModMessage(text);
    }

    public static void sendTriangulationPositions(PlayerInfo ... positions) {
        int count = positions.length;
        if (count == 1) {
            PlayerInfo pos = positions[0];
            ChatUtils.sendModMessage(ChatUtils.formatTriangulationPosition(pos));
            return;
        }
        int counter = 1;
        class_5250 text = class_2561.method_43473();
        for (PlayerInfo pos : positions) {
            class_2561 formatTriangulationPosition = ChatUtils.formatTriangulationPosition(pos);
            text.method_10852((class_2561)class_2561.method_43470((String)("Pos " + counter + "\n")).method_27692(class_124.field_1067)).method_10852(formatTriangulationPosition).method_27693("\n");
            ++counter;
        }
        ChatUtils.sendModMessage(text);
    }
}

