/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.legendsmobs;

import com.belgie.legendsmobs.BadgerRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class BadgerModel
extends EntityModel<BadgerRenderState> {
    private final ModelPart Head;
    private final ModelPart Body;
    private final ModelPart Tail;
    private final ModelPart FrontLeftFoot;
    private final ModelPart FrontRightFoot;
    private final ModelPart BackLeftFoot;
    private final ModelPart BackRightFoot;

    public BadgerModel(ModelPart root) {
        super(root);
        this.Head = root.getChild("Head");
        this.Body = root.getChild("Body");
        this.Tail = this.Body.getChild("Tail");
        this.FrontLeftFoot = root.getChild("FrontLeftFoot");
        this.FrontRightFoot = root.getChild("FrontRightFoot");
        this.BackLeftFoot = root.getChild("BackLeftFoot");
        this.BackRightFoot = root.getChild("BackRightFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)17.0f, (float)-7.0f));
        PartDefinition cube_r1 = Head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 51).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-2.6f, (float)-2.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = Head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(48, 46).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-2.6f, (float)-2.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = Head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(17, 56).addBox(-5.0f, -3.0f, -5.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)3.6f, (float)-9.6f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = Head.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 29).addBox(-8.0f, -3.0f, -11.0f, 10.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)1.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(4, 4).addBox(-2.0f, -8.0f, -8.0f, 10.0f, 8.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)21.0f, (float)0.0f));
        PartDefinition Tail = Body.addOrReplaceChild("Tail", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)-4.0f, (float)9.0f));
        PartDefinition cube_r5 = Tail.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(40, 29).addBox(-3.0f, -11.0f, -1.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-1.0f, (float)1.0f, (float)-1.789f, (float)0.0f, (float)0.0f));
        PartDefinition FrontLeftFoot = partdefinition.addOrReplaceChild("FrontLeftFoot", CubeListBuilder.create().texOffs(0, 43).addBox(-1.3f, -2.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)21.0f, (float)-4.5f));
        PartDefinition FrontRightFoot = partdefinition.addOrReplaceChild("FrontRightFoot", CubeListBuilder.create().texOffs(12, 43).addBox(-1.7f, -2.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)21.0f, (float)-4.5f));
        PartDefinition BackLeftFoot = partdefinition.addOrReplaceChild("BackLeftFoot", CubeListBuilder.create().texOffs(36, 46).addBox(-1.3f, -2.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)21.0f, (float)4.5f));
        PartDefinition BackRightFoot = partdefinition.addOrReplaceChild("BackRightFoot", CubeListBuilder.create().texOffs(24, 43).addBox(-1.7f, -2.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)21.0f, (float)4.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(BadgerRenderState state) {
        this.Head.xRot = state.digging ? -100.0f : state.xRot * ((float)Math.PI / 180);
        this.Head.yRot = state.yRot * ((float)Math.PI / 180);
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        this.BackRightFoot.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.BackLeftFoot.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.FrontRightFoot.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.FrontLeftFoot.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.Tail.xRot = 0.0f;
    }
}

