/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.legendsmobs;

import com.belgie.legendsmobs.BadgerEntity;
import com.belgie.legendsmobs.BadgerModel;
import com.belgie.legendsmobs.BadgerRenderer;
import com.belgie.legendsmobs.BadgerSoundEvents;
import com.belgie.legendsmobs.BadgerVariant;
import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DataPackRegistryEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="legendsmobs")
public class LegendsMobsMod {
    public static final String MODID = "legendsmobs";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<ResourceKey<LootTable>> LOCATIONS = new HashSet<ResourceKey<LootTable>>();
    public static final DeferredRegister<EntityType<?>> ENTITY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"legendsmobs");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"legendsmobs");
    public static final DeferredRegister<EntityDataSerializer<?>> SERIALIZER_DEFERRED_REGISTER = DeferredRegister.create((DeferredRegister.RegistryHolder)ForgeRegistries.ENTITY_DATA_SERIALIZERS, (String)"legendsmobs");
    public static final RegistryObject<EntityType<BadgerEntity>> BADGER = ENTITY.register("badger", () -> EntityType.Builder.of(BadgerEntity::new, (MobCategory)MobCategory.CREATURE).sized(1.2f, 0.8f).clientTrackingRange(4).updateInterval(4).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"badger"))));
    public static final Supplier<SpawnEggItem> BADGER_SPAWN_EGG_ITEM = ITEMS.register("badger_spawn_egg", () -> new SpawnEggItem((EntityType)BADGER.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"badger_spawn_egg")))));
    public static final ResourceKey<LootTable> BADGER_DIGGING = LegendsMobsMod.register("gameplay/badger_digging");
    public static final ResourceKey<Registry<BadgerVariant>> BADGER_VARIANT_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"badger_variant"));
    public static final EntityDataSerializer<Holder<BadgerVariant>> BADGER_VARIANT_KEY = EntityDataSerializer.forValueType(BadgerVariant.STREAM_CODEC);
    public static final Supplier<EntityDataSerializer<Holder<BadgerVariant>>> BADGER_VARIANT = SERIALIZER_DEFERRED_REGISTER.register("badger_variant", () -> BADGER_VARIANT_KEY);

    public void registerDatapackRegistries(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(BADGER_VARIANT_REGISTRY_KEY, BadgerVariant.DIRECT_CODEC, BadgerVariant.DIRECT_CODEC);
    }

    public LegendsMobsMod(FMLJavaModLoadingContext bus) {
        BusGroup modEventBus = bus.getModBusGroup();
        DataPackRegistryEvent.NewRegistry.getBus((BusGroup)modEventBus).addListener(this::registerDatapackRegistries);
        ITEMS.register(modEventBus);
        ENTITY.register(modEventBus);
        SERIALIZER_DEFERRED_REGISTER.register(modEventBus);
        BadgerSoundEvents.SOUND_EVENTS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        BuildCreativeModeTabContentsEvent.getBus((BusGroup)modEventBus).addListener(this::addCreative);
    }

    @SubscribeEvent
    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private static ResourceKey<LootTable> register(String name) {
        return LegendsMobsMod.register((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name)));
    }

    private static ResourceKey<LootTable> register(ResourceKey<LootTable> name) {
        if (LOCATIONS.add(name)) {
            return name;
        }
        throw new IllegalArgumentException(String.valueOf(name.location()) + " is already a registered built-in loot table");
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            event.accept((ItemLike)BADGER_SPAWN_EGG_ITEM.get());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="legendsmobs", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        public static final ModelLayerLocation BADGER_MODEL = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"legendsmobs", (String)"badger"), "main");

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }

        @SubscribeEvent
        public static void Attributes(SpawnPlacementRegisterEvent e) {
            e.register((EntityType)BADGER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        }

        @SubscribeEvent
        public static void Renderer(EntityRenderersEvent.RegisterRenderers e) {
            e.registerEntityRenderer((EntityType)BADGER.get(), BadgerRenderer::new);
        }

        @SubscribeEvent
        public static void Renderer(EntityRenderersEvent.RegisterLayerDefinitions e) {
            e.registerLayerDefinition(BADGER_MODEL, BadgerModel::createBodyLayer);
        }
    }
}

