/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.legendsmobs;

import com.belgie.legendsmobs.BadgerSoundEvents;
import com.belgie.legendsmobs.Config;
import com.belgie.legendsmobs.badger.BadgerEntity;
import com.belgie.legendsmobs.badger.BadgerModel;
import com.belgie.legendsmobs.badger.BadgerRenderer;
import com.belgie.legendsmobs.badger.BadgerVariant;
import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.slf4j.Logger;

@Mod(value="legendsmobs")
public class LegendsMobs {
    public static final String MODID = "legendsmobs";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<ResourceKey<LootTable>> LOCATIONS = new HashSet<ResourceKey<LootTable>>();
    public static final DeferredRegister<EntityType<?>> ENTITY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"legendsmobs");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"legendsmobs");
    public static final DeferredRegister<EntityDataSerializer<?>> SERIALIZER_DEFERRED_REGISTER = DeferredRegister.create((Registry)NeoForgeRegistries.ENTITY_DATA_SERIALIZERS, (String)"legendsmobs");
    public static final Supplier<EntityType<BadgerEntity>> BADGER = ENTITY.register("badger", () -> EntityType.Builder.of(BadgerEntity::new, (MobCategory)MobCategory.CREATURE).sized(1.2f, 0.8f).clientTrackingRange(4).updateInterval(4).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"badger"))));
    public static final Supplier<SpawnEggItem> BADGER_SPAWN_EGG_ITEM = ITEMS.register("badger_spawn_egg", () -> new SpawnEggItem(new Item.Properties().spawnEgg(BADGER.get()).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"badger_spawn_egg")))));
    public static final ResourceKey<LootTable> BADGER_DIGGING = LegendsMobs.register("gameplay/badger_digging");
    public static final ResourceKey<Registry<BadgerVariant>> BADGER_VARIANT_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"badger_variant"));
    public static final EntityDataSerializer<Holder<BadgerVariant>> BADGER_VARIANT_KEY = EntityDataSerializer.forValueType(BadgerVariant.STREAM_CODEC);
    public static final Supplier<EntityDataSerializer<Holder<BadgerVariant>>> BADGER_VARIANT = SERIALIZER_DEFERRED_REGISTER.register("badger_variant", () -> BADGER_VARIANT_KEY);

    public void registerDatapackRegistries(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(BADGER_VARIANT_REGISTRY_KEY, BadgerVariant.DIRECT_CODEC, BadgerVariant.DIRECT_CODEC, builder -> builder.maxId(256));
    }

    public LegendsMobs(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerDatapackRegistries);
        ITEMS.register(modEventBus);
        ENTITY.register(modEventBus);
        SERIALIZER_DEFERRED_REGISTER.register(modEventBus);
        BadgerSoundEvents.SOUND_EVENTS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private static ResourceKey<LootTable> register(String name) {
        return LegendsMobs.register((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name)));
    }

    private static ResourceKey<LootTable> register(ResourceKey<LootTable> name) {
        if (LOCATIONS.add(name)) {
            return name;
        }
        throw new IllegalArgumentException(String.valueOf(name.location()) + " is already a registered built-in loot table");
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            event.accept((ItemLike)BADGER_SPAWN_EGG_ITEM.get());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @EventBusSubscriber(modid="legendsmobs", value={Dist.CLIENT})
    public static class ClientModEvents {
        public static final ModelLayerLocation BADGER_MODEL = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"legendsmobs", (String)"badger"), "main");

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }

        @SubscribeEvent
        public static void Attributes(EntityAttributeCreationEvent e) {
            e.put(BADGER.get(), BadgerEntity.createPigAttributes().build());
        }

        @SubscribeEvent
        public static void Attributes(RegisterSpawnPlacementsEvent e) {
            e.register(BADGER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        }

        @SubscribeEvent
        public static void Renderer(EntityRenderersEvent.RegisterRenderers e) {
            e.registerEntityRenderer(BADGER.get(), BadgerRenderer::new);
        }

        @SubscribeEvent
        public static void Renderer(EntityRenderersEvent.RegisterLayerDefinitions e) {
            e.registerLayerDefinition(BADGER_MODEL, BadgerModel::createBodyLayer);
        }
    }
}

