/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.legendsmobs.badger;

import com.belgie.legendsmobs.LegendsMobs;
import com.belgie.legendsmobs.badger.BadgerVariant;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.PriorityProvider;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.level.biome.Biome;

public class BadgerVariants {
    public static final ResourceKey<BadgerVariant> NORMAL = BadgerVariants.createKey("normal");
    public static final ResourceKey<BadgerVariant> DEFAULT = NORMAL;

    private static ResourceKey<BadgerVariant> createKey(String name) {
        return ResourceKey.create(LegendsMobs.BADGER_VARIANT_REGISTRY_KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendsmobs", (String)name));
    }

    private static void register(BootstrapContext<BadgerVariant> p_400026_, ResourceKey<BadgerVariant> p_399464_, String p_399971_, TagKey<Biome> p_399473_) {
        HolderSet.Named holderset = p_400026_.lookup(Registries.BIOME).getOrThrow(p_399473_);
        BadgerVariants.register(p_400026_, p_399464_, p_399971_, SpawnPrioritySelectors.single((SpawnCondition)new BiomeCheck((HolderSet)holderset), (int)1));
    }

    private static void register(BootstrapContext<BadgerVariant> p_399696_, ResourceKey<BadgerVariant> p_399649_, String p_400239_, SpawnPrioritySelectors p_399940_) {
        p_399696_.register(p_399649_, (Object)new BadgerVariant(new ClientAsset.ResourceTexture(ResourceLocation.fromNamespaceAndPath((String)"legendsmobs", (String)p_400239_)), p_399940_));
    }

    static Optional<Holder.Reference<BadgerVariant>> selectVariantToSpawn(RandomSource p_399783_, RegistryAccess p_400102_, SpawnContext p_399936_) {
        return PriorityProvider.pick((Stream)p_400102_.lookupOrThrow(LegendsMobs.BADGER_VARIANT_REGISTRY_KEY).listElements(), Holder::value, (RandomSource)p_399783_, (Object)p_399936_);
    }

    public static void bootstrap(BootstrapContext<BadgerVariant> context) {
        BadgerVariants.register(context, NORMAL, "normal", (TagKey<Biome>)BiomeTags.IS_FOREST);
    }
}

