/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.legendsmobs;

import com.belgie.legendsmobs.BadgerSoundEvents;
import com.belgie.legendsmobs.BadgerVariant;
import com.belgie.legendsmobs.BadgerVariants;
import com.belgie.legendsmobs.LegendsMobsMod;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class BadgerEntity
extends Animal {
    public static final EntityDataAccessor<Boolean> HAS_EGG;
    private static final EntityDataAccessor<Boolean> DIGGING_BLOCK;
    private static final Ingredient BREEDING_INGREDIENT;
    int blockDiggingCounter;
    int DigCooldown;
    private static final EntityDataAccessor<Holder<BadgerVariant>> DATA_VARIANT_ID;

    public BadgerEntity(EntityType<? extends BadgerEntity> entityType, Level world) {
        super(entityType, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(10, (Goal)new DigGoal(this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, AbstractPiglin.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), false));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Frog.class, false));
    }

    public static AttributeSupplier.Builder createPigAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public Holder<BadgerVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    public void setVariant(Holder<BadgerVariant> p_332777_) {
        this.entityData.set(DATA_VARIANT_ID, p_332777_);
    }

    public ResourceLocation getTexture() {
        BadgerVariant variant = (BadgerVariant)this.getVariant().value();
        return variant.assetInfo().texturePath();
    }

    public int hasDigCooldown() {
        return this.DigCooldown;
    }

    void setDigCooldown(int hasEgg) {
        this.DigCooldown = hasEgg;
    }

    public boolean hasEgg() {
        return (Boolean)this.entityData.get(HAS_EGG);
    }

    void setHasEgg(boolean hasEgg) {
        this.entityData.set(HAS_EGG, (Object)hasEgg);
    }

    public boolean isDiggingSand() {
        return (Boolean)this.entityData.get(DIGGING_BLOCK);
    }

    void setDiggingSand(boolean diggingSand) {
        this.blockDiggingCounter = diggingSand ? 1 : 0;
        this.entityData.set(DIGGING_BLOCK, (Object)diggingSand);
    }

    public void tick() {
        if (this.hasDigCooldown() != 0) {
            --this.DigCooldown;
        }
        super.tick();
    }

    public void aiStep() {
        super.aiStep();
        if (this.isAlive() && this.blockDiggingCounter >= 1 && this.blockDiggingCounter % 10 == 0) {
            BlockPos blockpos = this.getHeadBlock();
            if (BadgerEntity.isblock((LevelReader)this.level(), blockpos)) {
                this.level().levelEvent(2001, blockpos, Block.getId((BlockState)this.level().getBlockState(blockpos.below())));
                this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            }
        }
    }

    private BlockPos getHeadBlock() {
        Vec3 vec3 = this.getHeadPosition();
        return BlockPos.containing((double)vec3.x(), (double)(this.getY() + (double)0.2f), (double)vec3.z());
    }

    private Vec3 getHeadPosition() {
        return this.position().add(this.getForward().scale(1.0));
    }

    public static boolean isblock(LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.below()).is(BlockTags.BASE_STONE_OVERWORLD) || world.getBlockState(pos.below()).is(BlockTags.SAND) || world.getBlockState(pos.below()).is(BlockTags.DIRT);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_333447_) {
        p_333447_.define(HAS_EGG, (Object)false);
        p_333447_.define(DIGGING_BLOCK, (Object)false);
        super.defineSynchedData(p_333447_);
        RegistryAccess registryaccess = this.registryAccess();
        Registry registry = registryaccess.lookupOrThrow(LegendsMobsMod.BADGER_VARIANT_REGISTRY_KEY);
        EntityDataAccessor<Holder<BadgerVariant>> var10001 = DATA_VARIANT_ID;
        Optional var10002 = registry.get(BadgerVariants.DEFAULT);
        Objects.requireNonNull(registry);
        p_333447_.define(var10001, (Object)((Holder)var10002.or(() -> ((Registry)registry).getAny()).orElseThrow()));
    }

    public void addAdditionalSaveData(ValueOutput nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("HasEgg", this.hasEgg());
        nbt.putInt("DigCooldown", this.DigCooldown);
        this.getVariant().unwrapKey().ifPresent(p_344339_ -> nbt.putString("variant", p_344339_.location().toString()));
    }

    public void readAdditionalSaveData(ValueInput nbt) {
        super.readAdditionalSaveData(nbt);
        this.setHasEgg(nbt.getBooleanOr("HasEgg", false));
        this.DigCooldown = nbt.getIntOr("DigCooldown", 0);
        Optional.ofNullable(ResourceLocation.tryParse((String)nbt.getStringOr("variant", "normal"))).map(p_332608_ -> ResourceKey.create(LegendsMobsMod.BADGER_VARIANT_REGISTRY_KEY, (ResourceLocation)p_332608_)).flatMap(p_390226_ -> this.registryAccess().lookupOrThrow(LegendsMobsMod.BADGER_VARIANT_REGISTRY_KEY).get(p_390226_)).ifPresent(this::setVariant);
    }

    public boolean isFood(ItemStack itemStack) {
        return BREEDING_INGREDIENT.test(itemStack);
    }

    protected SoundEvent getAmbientSound() {
        return BadgerSoundEvents.BADGER_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return BadgerSoundEvents.BADGER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return BadgerSoundEvents.BADGER_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(BadgerSoundEvents.BADGER_WALK.get(), 0.15f, 1.0f);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_332775_, DifficultyInstance p_332793_, EntitySpawnReason p_363578_, @Nullable SpawnGroupData p_332782_) {
        BadgerVariants.selectVariantToSpawn(this.random, this.registryAccess(), SpawnContext.create((ServerLevelAccessor)p_332775_, (BlockPos)this.blockPosition())).ifPresent(this::setVariant);
        return super.finalizeSpawn(p_332775_, p_332793_, p_363578_, p_332782_);
    }

    public BadgerEntity getBreedOffspring(ServerLevel serverWorld, AgeableMob passiveEntity) {
        return (BadgerEntity)((EntityType)LegendsMobsMod.BADGER.get()).create((Level)serverWorld, EntitySpawnReason.BREEDING);
    }

    public boolean isPushable() {
        return !this.isDiggingSand();
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.6f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    static {
        BREEDING_INGREDIENT = Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT, Items.POTATO, Items.BEETROOT});
        HAS_EGG = SynchedEntityData.defineId(BadgerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        DIGGING_BLOCK = SynchedEntityData.defineId(BadgerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        DATA_VARIANT_ID = SynchedEntityData.defineId(BadgerEntity.class, LegendsMobsMod.BADGER_VARIANT.get());
    }

    private static class DigGoal
    extends MoveToBlockGoal {
        private final BadgerEntity turtle;

        DigGoal(BadgerEntity turtle, double speed) {
            super((PathfinderMob)turtle, speed, 16);
            this.turtle = turtle;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return !this.turtle.isBaby() && this.turtle.hasDigCooldown() == 0 && !this.turtle.isDiggingSand() && this.turtle.onGround() && super.canUse();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.turtle.onGround();
        }

        public void tick() {
            super.tick();
            if (this.turtle.isDiggingSand()) {
                this.turtle.stopInPlace();
            }
            BlockPos blockPos = this.turtle.blockPosition();
            if (!this.turtle.isInWater() && this.isReachedTarget()) {
                if (this.turtle.blockDiggingCounter < 1) {
                    this.turtle.setDiggingSand(true);
                } else if (this.turtle.blockDiggingCounter > this.adjustedTickDelay(200)) {
                    this.dropMorningGifts(this.turtle);
                    this.turtle.setDiggingSand(false);
                    this.turtle.setDigCooldown(this.turtle.random.nextIntBetweenInclusive(500, 1000));
                }
                if (this.turtle.isDiggingSand()) {
                    ++this.turtle.blockDiggingCounter;
                }
            }
        }

        private void dropMorningGifts(BadgerEntity badger) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            blockpos$mutableblockpos.set((Vec3i)badger.getHeadBlock());
            LootTable loottable = badger.level().getServer().reloadableRegistries().getLootTable(LegendsMobsMod.BADGER_DIGGING);
            LootParams lootparams = new LootParams.Builder((ServerLevel)badger.level()).withParameter(LootContextParams.ORIGIN, (Object)badger.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)badger).create(LootContextParamSets.GIFT);
            for (ItemStack itemstack : loottable.getRandomItems(lootparams)) {
                badger.level().addFreshEntity((Entity)new ItemEntity(badger.level(), (double)blockpos$mutableblockpos.getX(), (double)blockpos$mutableblockpos.getY(), (double)blockpos$mutableblockpos.getZ(), itemstack));
            }
        }

        public void stop() {
            this.turtle.setDiggingSand(false);
            super.stop();
        }

        protected boolean isValidTarget(LevelReader world, BlockPos pos) {
            return !world.isEmptyBlock(pos.above()) ? false : DigGoal.isblock(world, pos);
        }

        public static boolean isblock(LevelReader world, BlockPos pos) {
            return world.getBlockState(pos).is(BlockTags.BASE_STONE_OVERWORLD) || world.getBlockState(pos).is(BlockTags.SAND) || world.getBlockState(pos).is(BlockTags.DIRT);
        }
    }

    public static class PackData
    extends AgeableMob.AgeableMobGroupData {
        public final Holder<BadgerVariant> type;

        public PackData(Holder<BadgerVariant> type) {
            super(false);
            this.type = type;
        }
    }
}

