/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.tfcagedalcohol.client;

import com.hermitowo.tfcagedalcohol.common.AgedAlcoholFluids;
import java.util.Objects;
import net.dries007.tfc.client.ClientEventHandler;
import net.dries007.tfc.client.extensions.FluidRendererExtension;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.model.DynamicFluidContainerModel;
import net.neoforged.neoforge.fluids.FluidType;

public class ClientEvents {
    public static void init(IEventBus bus) {
        bus.addListener(ClientEvents::registerColorHandlerItems);
        bus.addListener(ClientEvents::registerExtensions);
    }

    public static void registerColorHandlerItems(RegisterColorHandlersEvent.Item event) {
        for (Fluid fluid : BuiltInRegistries.FLUID) {
            if (!Objects.requireNonNull(BuiltInRegistries.FLUID.getKey((Object)fluid)).getNamespace().equals("tfcagedalcohol")) continue;
            event.register((ItemColor)new DynamicFluidContainerModel.Colors(), new ItemLike[]{fluid.getBucket()});
        }
    }

    public static void registerExtensions(RegisterClientExtensionsEvent event) {
        AgedAlcoholFluids.AGED_ALCOHOL.forEach((fluid, holder) -> event.registerFluidType((IClientFluidTypeExtensions)new FluidRendererExtension(fluid.getColor(), ClientEventHandler.WATER_STILL, ClientEventHandler.WATER_FLOW, ClientEventHandler.WATER_OVERLAY, ClientEventHandler.UNDERWATER_LOCATION), new FluidType[]{holder.getType()}));
    }
}

