/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.tfcagedalcohol.client;

import com.hermitowo.tfcagedalcohol.common.AgedAlcoholFluids;
import com.hermitowo.tfcagedalcohol.config.Config;
import net.dries007.tfc.common.fluids.FluidHolder;
import net.dries007.tfc.util.data.Drinkable;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class ClientForgeEvents {
    public static void init() {
        IEventBus bus = NeoForge.EVENT_BUS;
        bus.addListener(ClientForgeEvents::onTooltip);
    }

    private static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (handler == null) {
            return;
        }
        FluidStack fluidStack = handler.getFluidInTank(0);
        if (!fluidStack.isEmpty()) {
            Drinkable drinkable;
            Drinkable alcohol = AgedAlcoholFluids.AGED_ALCOHOL.entrySet().stream().filter(entry -> ((FluidHolder)entry.getValue()).getSource() == fluidStack.getFluid()).findAny().map(entry -> Drinkable.get((Fluid)((FluidHolder)entry.getValue()).getSource())).orElse(null);
            Drinkable drinkable2 = drinkable = Config.CLIENT.showEffectTooltipForAllDrinkables.get() != false ? Drinkable.get((Fluid)fluidStack.getFluid()) : alcohol;
            if (drinkable != null) {
                drinkable.effects().stream().findAny().map(effect -> event.getToolTip().add(ClientForgeEvents.getTooltip((Holder<MobEffect>)effect.type(), effect.duration(), effect.amplifier())));
            }
        }
    }

    private static Component getTooltip(Holder<MobEffect> effect, int duration, int amplifier) {
        MobEffectInstance effectInstance = new MobEffectInstance(effect, duration, amplifier);
        MutableComponent component = Component.empty();
        component.append((Component)Component.translatable((String)effectInstance.getDescriptionId()));
        component.append(" ");
        component.append((Component)Component.translatable((String)("potion.potency." + effectInstance.getAmplifier())));
        if (effectInstance.getAmplifier() > 0) {
            component.append(" ");
        }
        component.append("(" + ClientForgeEvents.formatDuration(effectInstance) + ")");
        return component.withStyle(((MobEffect)effect.value()).getCategory().getTooltipFormatting());
    }

    private static String formatDuration(MobEffectInstance effect) {
        return StringUtil.formatTickDuration((int)Mth.floor((float)effect.getDuration()), (float)20.0f);
    }
}

