/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xanticheat.checks;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import jn.willfrydev.xanticheat.XAntiCheat;
import jn.willfrydev.xanticheat.manager.FreezeManager;
import jn.willfrydev.xanticheat.manager.LangManager;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Check
implements Listener {
    protected final XAntiCheat plugin;
    private final String checkName;
    private final String checkReason;
    private final int maxViolations;
    private final LangManager lang;

    public Check(XAntiCheat plugin, String checkName) {
        this.plugin = plugin;
        this.checkName = checkName;
        this.lang = plugin.getLangManager();
        String configPath = "checks." + checkName + ".";
        this.maxViolations = plugin.getConfig().getInt(configPath + "max_violations", 10);
        this.checkReason = plugin.getConfig().getString(configPath + "reason", "Comportamiento sospechoso");
    }

    protected void flag(Player player) {
        if (player.hasPermission("xanticheat.bypass")) {
            return;
        }
        if (this.plugin.getFreezeManager().isFrozen(player)) {
            return;
        }
        this.plugin.getPlayerDataManager().addViolation(player, this.checkName);
        int violations = this.plugin.getPlayerDataManager().getViolations(player, this.checkName);
        if (this.plugin.getConfig().getBoolean("logging.database.enabled", true)) {
            int ping = player.getPing();
            double tps = Bukkit.getServer().getTPS()[0];
            String clientBrand = this.plugin.getClientManager().getClientBrand(player.getUniqueId());
            String details = "Cliente: " + clientBrand;
            this.plugin.getDatabaseManager().logViolationAsync(player.getUniqueId(), player.getName(), this.checkName, details, ping, tps);
        }
        String alertMessage = this.lang.getMessage("alerts.flag").replace("%player%", player.getName()).replace("%check%", this.checkName).replace("%violations%", String.valueOf(violations));
        String hoverMessage = this.lang.getMessage("alerts.hover_text").replace("%player%", player.getName());
        TextComponent message = new TextComponent(alertMessage);
        message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hoverMessage).create()));
        message.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp " + player.getName()));
        Bukkit.getOnlinePlayers().stream().filter(p -> p.hasPermission("xanticheat.alerts")).forEach(p -> p.spigot().sendMessage((BaseComponent)message));
        if (violations >= this.maxViolations) {
            this.punish(player);
            this.plugin.getPlayerDataManager().clearViolations(player, this.checkName);
        }
    }

    private void punish(Player player) {
        this.plugin.getDiscordManager().sendPunishmentMessage(player, this.checkName, this.checkReason, this.maxViolations);
        boolean freezeEnabled = this.plugin.getConfig().getBoolean("punishment_sequence.freeze.enabled", false);
        if (freezeEnabled) {
            this.executeFreezeSequence(player);
        } else {
            this.executePunishment(player);
        }
    }

    private void executeFreezeSequence(final Player player) {
        final FreezeManager freezeManager = this.plugin.getFreezeManager();
        int freezeSeconds = this.plugin.getConfig().getInt("punishment_sequence.freeze.duration_seconds", 5);
        freezeManager.freezePlayer(player);
        player.sendMessage(this.lang.getMessage("freeze.player_message"));
        String staffAlert = this.lang.getMessage("freeze.staff_alert").replace("%player%", player.getName()).replace("%seconds%", String.valueOf(freezeSeconds));
        Bukkit.getOnlinePlayers().stream().filter(p -> p.hasPermission("xanticheat.alerts")).forEach(p -> p.sendMessage(staffAlert));
        new BukkitRunnable(){

            public void run() {
                if (player.isOnline()) {
                    Check.this.executePunishment(player);
                    freezeManager.unfreezePlayer(player);
                }
            }
        }.runTaskLater((Plugin)this.plugin, (long)freezeSeconds * 20L);
    }

    private void executePunishment(Player player) {
        String punishmentType = this.plugin.getConfig().getString("punishment.type", "command").toLowerCase();
        if ("kick".equals(punishmentType)) {
            String reason;
            List<String> format = this.lang.getMessageList("kick_screen_format");
            String finalReason = reason = String.join((CharSequence)"\n", format).replace("%reason%", this.checkReason).replace("%date%", new SimpleDateFormat("dd-MM-yyyy").format(new Date()));
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.kickPlayer(finalReason));
        } else {
            String command = this.plugin.getConfig().getString("punishment.command_format", "ban %player% %reason%").replace("%player%", player.getName()).replace("%reason%", this.checkReason);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command));
        }
    }
}

