/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xanticheat.checks.combat;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import jn.willfrydev.xanticheat.XAntiCheat;
import jn.willfrydev.xanticheat.checks.Check;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerQuitEvent;

public class AutoClicker
extends Check {
    private final Map<UUID, Queue<Long>> clickTimestamps = new HashMap<UUID, Queue<Long>>();
    private final int maxCPS;

    public AutoClicker(XAntiCheat plugin) {
        super(plugin, "autoclicker");
        this.maxCPS = plugin.getConfig().getInt("checks.autoclicker.max_cps", 20);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerAnimation(PlayerAnimationEvent event) {
        int cps;
        if (event.getAnimationType() != PlayerAnimationType.ARM_SWING) {
            return;
        }
        Player player = event.getPlayer();
        Queue timestamps = this.clickTimestamps.computeIfAbsent(player.getUniqueId(), k -> new LinkedList());
        long currentTime = System.currentTimeMillis();
        timestamps.add(currentTime);
        while (currentTime - (Long)timestamps.peek() > 1000L) {
            timestamps.poll();
            if (!timestamps.isEmpty()) continue;
        }
        if ((cps = timestamps.size()) > this.maxCPS) {
            this.flag(player, "CPS: " + cps);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.clickTimestamps.remove(event.getPlayer().getUniqueId());
    }

    private void flag(Player player, String detail) {
        super.flag(player);
    }
}

