/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xanticheat.checks.combat;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import jn.willfrydev.xanticheat.XAntiCheat;
import jn.willfrydev.xanticheat.checks.Check;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.plugin.Plugin;

public class Velocity
extends Check {
    private final Map<UUID, Long> lastDamageTime = new HashMap<UUID, Long>();
    private final double threshold;

    public Velocity(XAntiCheat plugin) {
        super(plugin, "velocity");
        this.threshold = plugin.getConfig().getDouble("checks.velocity.reduction_threshold_percent", 95.0) / 100.0;
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        switch (event.getCause()) {
            case ENTITY_ATTACK: 
            case ENTITY_SWEEP_ATTACK: 
            case PROJECTILE: {
                this.lastDamageTime.put(event.getEntity().getUniqueId(), System.currentTimeMillis());
            }
        }
    }

    @EventHandler
    public void onVelocityChange(PlayerVelocityEvent event) {
        Player player = event.getPlayer();
        if (player.isBlocking() || player.isGliding()) {
            return;
        }
        long timeSinceDamage = System.currentTimeMillis() - this.lastDamageTime.getOrDefault(player.getUniqueId(), 0L);
        if (timeSinceDamage > 500L) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (!player.isOnline()) {
                return;
            }
            double expectedHorizontalVelocity = Math.sqrt(Math.pow(event.getVelocity().getX(), 2.0) + Math.pow(event.getVelocity().getZ(), 2.0));
            double actualHorizontalVelocity = Math.sqrt(Math.pow(player.getVelocity().getX(), 2.0) + Math.pow(player.getVelocity().getZ(), 2.0));
            if (player.getLocation().getBlock().getRelative(1, 0, 0).getType().isSolid() || player.getLocation().getBlock().getRelative(-1, 0, 0).getType().isSolid() || player.getLocation().getBlock().getRelative(0, 0, 1).getType().isSolid() || player.getLocation().getBlock().getRelative(0, 0, -1).getType().isSolid()) {
                return;
            }
            if (expectedHorizontalVelocity < 0.1) {
                return;
            }
            double reduction = 1.0 - actualHorizontalVelocity / expectedHorizontalVelocity;
            if (reduction >= this.threshold) {
                this.flag(player);
            }
        });
    }
}

