/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xanticheat.checks.movement;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import jn.willfrydev.xanticheat.XAntiCheat;
import jn.willfrydev.xanticheat.checks.Check;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.potion.PotionEffectType;

public class Fly
extends Check
implements Listener {
    private final Map<UUID, Integer> violationLevels = new HashMap<UUID, Integer>();
    private final Map<UUID, Double> lastYDiff = new HashMap<UUID, Double>();
    private final Map<UUID, Integer> ticksInAir = new HashMap<UUID, Integer>();
    private static final int VL_THRESHOLD = 20;
    private static final double GRAVITY_ACCELERATION = 0.08;
    private static final double AIR_FRICTION = 0.98;

    public Fly(XAntiCheat plugin) {
        super(plugin, "fly");
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR || player.getAllowFlight() || player.isInsideVehicle() || player.hasPotionEffect(PotionEffectType.LEVITATION) || player.isGliding()) {
            return;
        }
        if (this.isInLiquid(player) || this.isOnClimbable(player) || this.isNearSlimeBlock(player)) {
            this.resetPlayerData(player.getUniqueId());
            return;
        }
        double yDiff = event.getTo().getY() - event.getFrom().getY();
        if (!player.isOnGround()) {
            int airTicks = this.ticksInAir.getOrDefault(player.getUniqueId(), 0) + 1;
            this.ticksInAir.put(player.getUniqueId(), airTicks);
            if (airTicks > 5) {
                double lastDiff = this.lastYDiff.getOrDefault(player.getUniqueId(), 0.0);
                double predictedFall = (lastDiff - 0.08) * 0.98;
                if (yDiff > 0.0 && lastDiff > 0.0) {
                    this.incrementVL(player, "Ascension");
                }
                if (yDiff < 0.0 && predictedFall < yDiff - 0.01) {
                    this.incrementVL(player, "Glide");
                }
            }
            this.lastYDiff.put(player.getUniqueId(), yDiff);
        } else {
            this.resetPlayerData(player.getUniqueId());
        }
    }

    private void incrementVL(Player player, String type) {
        int vl = this.violationLevels.getOrDefault(player.getUniqueId(), 0) + 1;
        this.violationLevels.put(player.getUniqueId(), vl);
        if (vl > 20) {
            this.violationLevels.put(player.getUniqueId(), 0);
        }
    }

    private void resetPlayerData(UUID uuid) {
        this.ticksInAir.remove(uuid);
        this.lastYDiff.remove(uuid);
        int vl = this.violationLevels.getOrDefault(uuid, 0);
        if (vl > 0) {
            this.violationLevels.put(uuid, vl - 1);
        }
    }

    private boolean isInLiquid(Player player) {
        Material blockType = player.getLocation().getBlock().getType();
        return blockType == Material.WATER || blockType == Material.LAVA;
    }

    private boolean isOnClimbable(Player player) {
        Material blockType = player.getLocation().getBlock().getType();
        return blockType == Material.LADDER || blockType == Material.VINE;
    }

    private boolean isNearSlimeBlock(Player player) {
        for (int i = 0; i < 3; ++i) {
            if (player.getLocation().subtract(0.0, (double)i, 0.0).getBlock().getType() != Material.SLIME_BLOCK) continue;
            return true;
        }
        return false;
    }
}

