/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xanticheat.checks.movement;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import jn.willfrydev.xanticheat.XAntiCheat;
import jn.willfrydev.xanticheat.checks.Check;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class NoFall
extends Check
implements Listener {
    private final Map<UUID, Integer> violationLevels = new HashMap<UUID, Integer>();
    private static final double FALL_DISTANCE_THRESHOLD = 3.5;
    private static final int VL_THRESHOLD = 10;

    public NoFall(XAntiCheat plugin) {
        super(plugin, "nofall");
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        int vl;
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR || player.getAllowFlight() || player.isFlying() || player.isInsideVehicle() || player.hasMetadata("teleporting")) {
            return;
        }
        if (this.isNearFallDamageNegatingBlock(player)) {
            return;
        }
        double fallDistance = player.getFallDistance();
        boolean isOnGround = player.isOnGround();
        if (fallDistance > 3.5 && isOnGround) {
            int vl2 = this.violationLevels.getOrDefault(player.getUniqueId(), 0) + 1;
            this.violationLevels.put(player.getUniqueId(), vl2);
            if (vl2 > 10) {
                this.flag(player);
                this.violationLevels.remove(player.getUniqueId());
            }
        } else if (fallDistance == 0.0 && (vl = this.violationLevels.getOrDefault(player.getUniqueId(), 0).intValue()) > 0) {
            this.violationLevels.put(player.getUniqueId(), vl - 1);
        }
    }

    private boolean isNearFallDamageNegatingBlock(Player player) {
        Block block = player.getLocation().getBlock();
        for (int i = 0; i < 2; ++i) {
            Material type = block.getRelative(0, -i, 0).getType();
            switch (type) {
                case WATER: 
                case LAVA: 
                case VINE: 
                case LADDER: 
                case COBWEB: {
                    return true;
                }
            }
        }
        return false;
    }
}

