/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xanticheat.checks.movement;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import jn.willfrydev.xanticheat.XAntiCheat;
import jn.willfrydev.xanticheat.checks.Check;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class Speed
extends Check
implements Listener {
    private final Map<UUID, Integer> violationLevels = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> lastViolationTime = new HashMap<UUID, Long>();
    private static final int VIOLATION_THRESHOLD = 25;
    private static final long DECAY_TIME = 2000L;

    public Speed(XAntiCheat plugin) {
        super(plugin, "speed");
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR || player.getAllowFlight() || player.isFlying() || player.isInsideVehicle()) {
            return;
        }
        if (event.getFrom().getX() == event.getTo().getX() && event.getFrom().getZ() == event.getTo().getZ()) {
            return;
        }
        this.decayViolationLevel(player.getUniqueId());
        Vector from = event.getFrom().toVector();
        Vector to = event.getTo().toVector();
        double horizontalDistance = Math.sqrt(Math.pow(to.getX() - from.getX(), 2.0) + Math.pow(to.getZ() - from.getZ(), 2.0));
        double maxSpeed = this.getMaxAllowedSpeed(player);
        if (horizontalDistance > maxSpeed) {
            this.incrementViolationLevel(player.getUniqueId());
        }
        if (this.violationLevels.getOrDefault(player.getUniqueId(), 0) > 25) {
            this.flag(player);
            this.violationLevels.put(player.getUniqueId(), 0);
        }
    }

    private double getMaxAllowedSpeed(Player player) {
        double maxSpeed = 0.43;
        if (player.isSprinting()) {
            maxSpeed = 0.58;
        }
        if (!player.isOnGround()) {
            maxSpeed += 0.2;
        }
        if (player.hasPotionEffect(PotionEffectType.SPEED)) {
            for (PotionEffect effect : player.getActivePotionEffects()) {
                if (!effect.getType().equals((Object)PotionEffectType.SPEED)) continue;
                int level = effect.getAmplifier() + 1;
                maxSpeed *= 1.0 + 0.2 * (double)level;
            }
        }
        return maxSpeed += 0.05;
    }

    private void incrementViolationLevel(UUID uuid) {
        int vl = this.violationLevels.getOrDefault(uuid, 0) + 1;
        this.violationLevels.put(uuid, vl);
        this.lastViolationTime.put(uuid, System.currentTimeMillis());
    }

    private void decayViolationLevel(UUID uuid) {
        int currentVl;
        long timeSinceLast;
        if (this.lastViolationTime.containsKey(uuid) && (timeSinceLast = System.currentTimeMillis() - this.lastViolationTime.get(uuid)) > 2000L && (currentVl = this.violationLevels.getOrDefault(uuid, 0).intValue()) > 0) {
            this.violationLevels.put(uuid, currentVl - 1);
        }
    }
}

